/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IBlockChoice;
import jp.jasminesoft.jfc.gen.appschema.IDisplaymodelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Movebutton;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Block
implements Serializable,
Cloneable,
IRNode,
IDisplaymodelChoice {
    private String name_;
    private Integer column_;
    private Boolean autoalignment_;
    private List content_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Block() {
    }

    public Block(Block source) {
        this.setup(source);
    }

    public Block(RStack stack) {
        this.setup(stack);
    }

    public Block(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Block(Element element) {
        this.setup(element);
    }

    public Block(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Block(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Block(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Block(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Block(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Block(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Block source) {
        this.setName(source.getName());
        this.setColumn(source.getColumn());
        this.setAutoalignment(source.getAutoalignment());
        this.content_.clear();
        int size = source.content_.size();
        for (int i = 0; i < size; ++i) {
            this.addContent((IBlockChoice)source.getContent(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.column_ = URelaxer.getAttributePropertyAsIntObject(element, "column");
        this.autoalignment_ = URelaxer.getAttributePropertyAsBooleanObject(element, "autoalignment");
        this.content_.clear();
        while (true) {
            if (Displayitem.isMatch(stack)) {
                this.addContent(factory.createDisplayitem(stack));
                continue;
            }
            if (Link.isMatch(stack)) {
                this.addContent(factory.createLink(stack));
                continue;
            }
            if (!Movebutton.isMatch(stack)) break;
            this.addContent(factory.createMovebutton(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createBlock(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("block");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.column_ != null) {
            URelaxer.setAttributePropertyByInt(element, "column", this.column_);
        }
        if (this.autoalignment_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "autoalignment", this.autoalignment_);
        }
        int size = this.content_.size();
        for (int i = 0; i < size; ++i) {
            IBlockChoice value = (IBlockChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public int getColumn() {
        if (this.column_ == null) {
            return 1;
        }
        return this.column_;
    }

    public int getColumn(int column) {
        if (this.column_ == null) {
            return column;
        }
        return this.column_;
    }

    public Integer getColumnAsInteger() {
        return this.column_;
    }

    public boolean checkColumn() {
        return this.column_ != null;
    }

    public void setColumn(int column) {
        this.column_ = new Integer(column);
    }

    public void setColumn(Integer column) {
        this.column_ = column;
    }

    public boolean getAutoalignment() {
        if (this.autoalignment_ == null) {
            return false;
        }
        return this.autoalignment_;
    }

    public boolean getAutoalignment(boolean autoalignment) {
        if (this.autoalignment_ == null) {
            return autoalignment;
        }
        return this.autoalignment_;
    }

    public Boolean getAutoalignmentAsBoolean() {
        return this.autoalignment_;
    }

    public boolean checkAutoalignment() {
        return this.autoalignment_ != null;
    }

    public void setAutoalignment(boolean autoalignment) {
        this.autoalignment_ = new Boolean(autoalignment);
    }

    public void setAutoalignment(Boolean autoalignment) {
        this.autoalignment_ = autoalignment;
    }

    public final IBlockChoice[] getContent() {
        IBlockChoice[] array = new IBlockChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IBlockChoice[] content) {
        int i;
        this.content_.clear();
        if (content != null) {
            for (i = 0; i < content.length; ++i) {
                this.addContent(content[i]);
            }
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setContent(IBlockChoice content) {
        this.content_.clear();
        this.addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IBlockChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IBlockChoice[] content) {
        int i;
        for (i = 0; i < content.length; ++i) {
            this.addContent(content[i]);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeContent() {
        return this.content_.size();
    }

    public final IBlockChoice getContent(int index) {
        return (IBlockChoice)this.content_.get(index);
    }

    public final void setContent(int index, IBlockChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(int index, IBlockChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IBlockChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        IBlockChoice value;
        int i;
        buffer.append("<block");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.column_ != null) {
            buffer.append(" column=\"");
            buffer.append(URelaxer.getString(this.getColumn()));
            buffer.append("\"");
        }
        if (this.autoalignment_ != null) {
            buffer.append(" autoalignment=\"");
            buffer.append(URelaxer.getString(this.getAutoalignment()));
            buffer.append("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</block>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        IBlockChoice value;
        int i;
        buffer.write("<block");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.column_ != null) {
            buffer.write(" column=\"");
            buffer.write(URelaxer.getString(this.getColumn()));
            buffer.write("\"");
        }
        if (this.autoalignment_ != null) {
            buffer.write(" autoalignment=\"");
            buffer.write(URelaxer.getString(this.getAutoalignment()));
            buffer.write("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</block>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        IBlockChoice value;
        int i;
        buffer.print("<block");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.column_ != null) {
            buffer.print(" column=\"");
            buffer.print(URelaxer.getString(this.getColumn()));
            buffer.print("\"");
        }
        if (this.autoalignment_ != null) {
            buffer.print(" autoalignment=\"");
            buffer.print(URelaxer.getString(this.getAutoalignment()));
            buffer.print("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IBlockChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</block>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getColumnAsString() {
        return URelaxer.getString(this.getColumn());
    }

    public String getAutoalignmentAsString() {
        return URelaxer.getString(this.getAutoalignment());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setColumnByString(String string) {
        this.setColumn(Integer.parseInt(string));
    }

    public void setAutoalignmentByString(String string) {
        this.setAutoalignment((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "block")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (Displayitem.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Link.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Movebutton.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Block.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Block.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

