/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IEnvironmentChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.Replication;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Cacheinfo
implements Serializable,
Cloneable,
IRNode,
IEnvironmentChoice {
    public static final String TYPE_CLASSIC = "classic";
    public static final String TYPE_HIBERNATE = "hibernate";
    public static final String TYPE_SLIM = "slim";
    private String type_ = "classic";
    private String maxBytesLocalHeap_;
    private Replication replication_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Cacheinfo() {
    }

    public Cacheinfo(Cacheinfo source) {
        this.setup(source);
    }

    public Cacheinfo(RStack stack) {
        this.setup(stack);
    }

    public Cacheinfo(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Cacheinfo(Element element) {
        this.setup(element);
    }

    public Cacheinfo(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Cacheinfo(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Cacheinfo(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Cacheinfo(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Cacheinfo(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Cacheinfo(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Cacheinfo source) {
        this.setType(source.getType());
        this.setMaxBytesLocalHeap(source.getMaxBytesLocalHeap());
        if (source.replication_ != null) {
            this.setReplication((Replication)source.getReplication().clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.maxBytesLocalHeap_ = URelaxer.getAttributePropertyAsString(element, "maxBytesLocalHeap");
        if (Replication.isMatch(stack)) {
            this.setReplication(factory.createReplication(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createCacheinfo(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("cacheinfo");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.maxBytesLocalHeap_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxBytesLocalHeap", this.maxBytesLocalHeap_);
        }
        if (this.replication_ != null) {
            this.replication_.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getMaxBytesLocalHeap() {
        if (this.maxBytesLocalHeap_ == null) {
            return "100";
        }
        return this.maxBytesLocalHeap_;
    }

    public final void setMaxBytesLocalHeap(String maxBytesLocalHeap) {
        this.maxBytesLocalHeap_ = maxBytesLocalHeap;
    }

    public final Replication getReplication() {
        return this.replication_;
    }

    public final void setReplication(Replication replication) {
        this.replication_ = replication;
        if (replication != null) {
            replication.rSetParentRNode(this);
        }
        if (replication != null) {
            replication.rSetRContext(this.rGetRContext());
        }
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<cacheinfo");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.maxBytesLocalHeap_ != null) {
            buffer.append(" maxBytesLocalHeap=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxBytesLocalHeap())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.replication_ != null) {
            this.replication_.makeTextElement(buffer);
        }
        buffer.append("</cacheinfo>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<cacheinfo");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.maxBytesLocalHeap_ != null) {
            buffer.write(" maxBytesLocalHeap=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxBytesLocalHeap())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.replication_ != null) {
            this.replication_.makeTextElement(buffer);
        }
        buffer.write("</cacheinfo>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<cacheinfo");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.maxBytesLocalHeap_ != null) {
            buffer.print(" maxBytesLocalHeap=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMaxBytesLocalHeap())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.replication_ != null) {
            this.replication_.makeTextElement(buffer);
        }
        buffer.print("</cacheinfo>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getMaxBytesLocalHeapAsString() {
        return URelaxer.getString(this.getMaxBytesLocalHeap());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setMaxBytesLocalHeapByString(String string) {
        this.setMaxBytesLocalHeap(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList<Replication> classNodes = new ArrayList<Replication>();
        if (this.replication_ != null) {
            classNodes.add(this.replication_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "cacheinfo")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (Replication.isMatchHungry(target)) {
            // empty if block
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Cacheinfo.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Cacheinfo.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

