/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IConstraintChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Notnull;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Constraint
implements Serializable,
Cloneable,
IRNode,
IModelitemChoice {
    public static final String TYPE_ENABLED = "enabled";
    public static final String TYPE_DISABLED = "disabled";
    public static final String TYPE_EQUAL = "equal";
    public static final String TYPE_NOTEQUAL = "notequal";
    public static final String TYPE_OTHERWISE = "otherwise";
    private String target_;
    private String type_;
    private String value_;
    private Boolean keep_;
    private List content_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Constraint() {
    }

    public Constraint(Constraint source) {
        this.setup(source);
    }

    public Constraint(RStack stack) {
        this.setup(stack);
    }

    public Constraint(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Constraint(Element element) {
        this.setup(element);
    }

    public Constraint(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Constraint(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Constraint(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Constraint(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Constraint(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Constraint(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Constraint source) {
        this.setTarget(source.getTarget());
        this.setType(source.getType());
        this.setValue(source.getValue());
        this.setKeep(source.getKeep());
        this.content_.clear();
        int size = source.content_.size();
        for (int i = 0; i < size; ++i) {
            this.addContent((IConstraintChoice)source.getContent(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.target_ = URelaxer.getAttributePropertyAsString(element, "target");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.value_ = URelaxer.getAttributePropertyAsString(element, "value");
        this.keep_ = URelaxer.getAttributePropertyAsBooleanObject(element, "keep");
        this.content_.clear();
        while (true) {
            if (Relation.isMatch(stack)) {
                this.addContent(factory.createRelation(stack));
                continue;
            }
            if (!Notnull.isMatch(stack)) break;
            this.addContent(factory.createNotnull(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createConstraint(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("constraint");
        if (this.target_ != null) {
            URelaxer.setAttributePropertyByString(element, "target", this.target_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.value_ != null) {
            URelaxer.setAttributePropertyByString(element, "value", this.value_);
        }
        if (this.keep_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "keep", this.keep_);
        }
        int size = this.content_.size();
        for (int i = 0; i < size; ++i) {
            IConstraintChoice value = (IConstraintChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getTarget() {
        return this.target_;
    }

    public final void setTarget(String target) {
        this.target_ = target;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_ENABLED;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getValue() {
        return this.value_;
    }

    public final void setValue(String value) {
        this.value_ = value;
    }

    public boolean getKeep() {
        if (this.keep_ == null) {
            return false;
        }
        return this.keep_;
    }

    public boolean getKeep(boolean keep) {
        if (this.keep_ == null) {
            return keep;
        }
        return this.keep_;
    }

    public Boolean getKeepAsBoolean() {
        return this.keep_;
    }

    public boolean checkKeep() {
        return this.keep_ != null;
    }

    public void setKeep(boolean keep) {
        this.keep_ = new Boolean(keep);
    }

    public void setKeep(Boolean keep) {
        this.keep_ = keep;
    }

    public final IConstraintChoice[] getContent() {
        IConstraintChoice[] array = new IConstraintChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IConstraintChoice[] content) {
        int i;
        this.content_.clear();
        if (content != null) {
            for (i = 0; i < content.length; ++i) {
                this.addContent(content[i]);
            }
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setContent(IConstraintChoice content) {
        this.content_.clear();
        this.addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IConstraintChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IConstraintChoice[] content) {
        int i;
        for (i = 0; i < content.length; ++i) {
            this.addContent(content[i]);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeContent() {
        return this.content_.size();
    }

    public final IConstraintChoice getContent(int index) {
        return (IConstraintChoice)this.content_.get(index);
    }

    public final void setContent(int index, IConstraintChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(int index, IConstraintChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IConstraintChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        IConstraintChoice value;
        int i;
        buffer.append("<constraint");
        if (this.target_ != null) {
            buffer.append(" target=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.value_ != null) {
            buffer.append(" value=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValue())));
            buffer.append("\"");
        }
        if (this.keep_ != null) {
            buffer.append(" keep=\"");
            buffer.append(URelaxer.getString(this.getKeep()));
            buffer.append("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</constraint>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        IConstraintChoice value;
        int i;
        buffer.write("<constraint");
        if (this.target_ != null) {
            buffer.write(" target=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.value_ != null) {
            buffer.write(" value=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValue())));
            buffer.write("\"");
        }
        if (this.keep_ != null) {
            buffer.write(" keep=\"");
            buffer.write(URelaxer.getString(this.getKeep()));
            buffer.write("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</constraint>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        IConstraintChoice value;
        int i;
        buffer.print("<constraint");
        if (this.target_ != null) {
            buffer.print(" target=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTarget())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.value_ != null) {
            buffer.print(" value=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getValue())));
            buffer.print("\"");
        }
        if (this.keep_ != null) {
            buffer.print(" keep=\"");
            buffer.print(URelaxer.getString(this.getKeep()));
            buffer.print("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IConstraintChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</constraint>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTargetAsString() {
        return URelaxer.getString(this.getTarget());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getValueAsString() {
        return URelaxer.getString(this.getValue());
    }

    public String getKeepAsString() {
        return URelaxer.getString(this.getKeep());
    }

    public void setTargetByString(String string) {
        this.setTarget(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setValueByString(String string) {
        this.setValue(string);
    }

    public void setKeepByString(String string) {
        this.setKeep((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "constraint")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (Relation.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Notnull.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Constraint.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Constraint.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

