/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Control
implements Serializable,
Cloneable,
IRNode,
IModelitemChoice {
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_READONLY = "readonly";
    private String type_;
    private String principals_;
    private String permclass_;
    private String permname_;
    private String permactions_;
    private String condition_;
    private Boolean clear_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Control() {
    }

    public Control(Control source) {
        this.setup(source);
    }

    public Control(RStack stack) {
        this.setup(stack);
    }

    public Control(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Control(Element element) {
        this.setup(element);
    }

    public Control(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Control(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Control(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Control(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Control(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Control(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Control source) {
        this.setType(source.getType());
        this.setPrincipals(source.getPrincipals());
        this.setPermclass(source.getPermclass());
        this.setPermname(source.getPermname());
        this.setPermactions(source.getPermactions());
        this.setCondition(source.getCondition());
        this.setClear(source.getClear());
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.principals_ = URelaxer.getAttributePropertyAsString(element, "principals");
        this.permclass_ = URelaxer.getAttributePropertyAsString(element, "permclass");
        this.permname_ = URelaxer.getAttributePropertyAsString(element, "permname");
        this.permactions_ = URelaxer.getAttributePropertyAsString(element, "permactions");
        this.condition_ = URelaxer.getAttributePropertyAsString(element, "condition");
        this.clear_ = URelaxer.getAttributePropertyAsBooleanObject(element, "clear");
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createControl(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("control");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.principals_ != null) {
            URelaxer.setAttributePropertyByString(element, "principals", this.principals_);
        }
        if (this.permclass_ != null) {
            URelaxer.setAttributePropertyByString(element, "permclass", this.permclass_);
        }
        if (this.permname_ != null) {
            URelaxer.setAttributePropertyByString(element, "permname", this.permname_);
        }
        if (this.permactions_ != null) {
            URelaxer.setAttributePropertyByString(element, "permactions", this.permactions_);
        }
        if (this.condition_ != null) {
            URelaxer.setAttributePropertyByString(element, "condition", this.condition_);
        }
        if (this.clear_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "clear", this.clear_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_HIDDEN;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getPrincipals() {
        return this.principals_;
    }

    public final void setPrincipals(String principals) {
        this.principals_ = principals;
    }

    public final String getPermclass() {
        if (this.permclass_ == null) {
            return "jp.jasminesoft.jfc.JFCAppPermission";
        }
        return this.permclass_;
    }

    public final void setPermclass(String permclass) {
        this.permclass_ = permclass;
    }

    public final String getPermname() {
        return this.permname_;
    }

    public final void setPermname(String permname) {
        this.permname_ = permname;
    }

    public final String getPermactions() {
        return this.permactions_;
    }

    public final void setPermactions(String permactions) {
        this.permactions_ = permactions;
    }

    public final String getCondition() {
        return this.condition_;
    }

    public final void setCondition(String condition) {
        this.condition_ = condition;
    }

    public boolean getClear() {
        if (this.clear_ == null) {
            return false;
        }
        return this.clear_;
    }

    public boolean getClear(boolean clear) {
        if (this.clear_ == null) {
            return clear;
        }
        return this.clear_;
    }

    public Boolean getClearAsBoolean() {
        return this.clear_;
    }

    public boolean checkClear() {
        return this.clear_ != null;
    }

    public void setClear(boolean clear) {
        this.clear_ = new Boolean(clear);
    }

    public void setClear(Boolean clear) {
        this.clear_ = clear;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<control");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.principals_ != null) {
            buffer.append(" principals=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPrincipals())));
            buffer.append("\"");
        }
        if (this.permclass_ != null) {
            buffer.append(" permclass=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermclass())));
            buffer.append("\"");
        }
        if (this.permname_ != null) {
            buffer.append(" permname=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermname())));
            buffer.append("\"");
        }
        if (this.permactions_ != null) {
            buffer.append(" permactions=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermactions())));
            buffer.append("\"");
        }
        if (this.condition_ != null) {
            buffer.append(" condition=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCondition())));
            buffer.append("\"");
        }
        if (this.clear_ != null) {
            buffer.append(" clear=\"");
            buffer.append(URelaxer.getString(this.getClear()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</control>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<control");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.principals_ != null) {
            buffer.write(" principals=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPrincipals())));
            buffer.write("\"");
        }
        if (this.permclass_ != null) {
            buffer.write(" permclass=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermclass())));
            buffer.write("\"");
        }
        if (this.permname_ != null) {
            buffer.write(" permname=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermname())));
            buffer.write("\"");
        }
        if (this.permactions_ != null) {
            buffer.write(" permactions=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermactions())));
            buffer.write("\"");
        }
        if (this.condition_ != null) {
            buffer.write(" condition=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCondition())));
            buffer.write("\"");
        }
        if (this.clear_ != null) {
            buffer.write(" clear=\"");
            buffer.write(URelaxer.getString(this.getClear()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</control>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<control");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.principals_ != null) {
            buffer.print(" principals=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPrincipals())));
            buffer.print("\"");
        }
        if (this.permclass_ != null) {
            buffer.print(" permclass=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermclass())));
            buffer.print("\"");
        }
        if (this.permname_ != null) {
            buffer.print(" permname=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermname())));
            buffer.print("\"");
        }
        if (this.permactions_ != null) {
            buffer.print(" permactions=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPermactions())));
            buffer.print("\"");
        }
        if (this.condition_ != null) {
            buffer.print(" condition=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getCondition())));
            buffer.print("\"");
        }
        if (this.clear_ != null) {
            buffer.print(" clear=\"");
            buffer.print(URelaxer.getString(this.getClear()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</control>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getPrincipalsAsString() {
        return URelaxer.getString(this.getPrincipals());
    }

    public String getPermclassAsString() {
        return URelaxer.getString(this.getPermclass());
    }

    public String getPermnameAsString() {
        return URelaxer.getString(this.getPermname());
    }

    public String getPermactionsAsString() {
        return URelaxer.getString(this.getPermactions());
    }

    public String getConditionAsString() {
        return URelaxer.getString(this.getCondition());
    }

    public String getClearAsString() {
        return URelaxer.getString(this.getClear());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setPrincipalsByString(String string) {
        this.setPrincipals(string);
    }

    public void setPermclassByString(String string) {
        this.setPermclass(string);
    }

    public void setPermnameByString(String string) {
        this.setPermname(string);
    }

    public void setPermactionsByString(String string) {
        this.setPermactions(string);
    }

    public void setConditionByString(String string) {
        this.setCondition(string);
    }

    public void setClearByString(String string) {
        this.setClear((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "control")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Control.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Control.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

