/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ForeignKey
implements Serializable,
Cloneable,
IRNode,
IModelChoice {
    public static final String TYPE_STRING = "string";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_TIME = "time";
    public static final String TYPE_DATETIME = "dateTime";
    private String name_;
    private String type_;
    private String idref_;
    private String refname_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public ForeignKey() {
        this.name_ = "";
        this.idref_ = "";
    }

    public ForeignKey(ForeignKey source) {
        this.setup(source);
    }

    public ForeignKey(RStack stack) {
        this.setup(stack);
    }

    public ForeignKey(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public ForeignKey(Element element) {
        this.setup(element);
    }

    public ForeignKey(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public ForeignKey(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public ForeignKey(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public ForeignKey(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public ForeignKey(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public ForeignKey(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(ForeignKey source) {
        this.setName(source.getName());
        this.setType(source.getType());
        this.setIdref(source.getIdref());
        this.setRefname(source.getRefname());
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.idref_ = URelaxer.getAttributePropertyAsString(element, "idref");
        this.refname_ = URelaxer.getAttributePropertyAsString(element, "refname");
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createForeignKey(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("foreignKey");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.idref_ != null) {
            URelaxer.setAttributePropertyByString(element, "idref", this.idref_);
        }
        if (this.refname_ != null) {
            URelaxer.setAttributePropertyByString(element, "refname", this.refname_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getType() {
        if (this.type_ == null) {
            return TYPE_STRING;
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getIdref() {
        return this.idref_;
    }

    public final void setIdref(String idref) {
        this.idref_ = idref;
    }

    public final String getRefname() {
        return this.refname_;
    }

    public final void setRefname(String refname) {
        this.refname_ = refname;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<foreignKey");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.idref_ != null) {
            buffer.append(" idref=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.append("\"");
        }
        if (this.refname_ != null) {
            buffer.append(" refname=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</foreignKey>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<foreignKey");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.idref_ != null) {
            buffer.write(" idref=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.write("\"");
        }
        if (this.refname_ != null) {
            buffer.write(" refname=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</foreignKey>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<foreignKey");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.idref_ != null) {
            buffer.print(" idref=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getIdref())));
            buffer.print("\"");
        }
        if (this.refname_ != null) {
            buffer.print(" refname=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRefname())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</foreignKey>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getIdrefAsString() {
        return URelaxer.getString(this.getIdref());
    }

    public String getRefnameAsString() {
        return URelaxer.getString(this.getRefname());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setIdrefByString(String string) {
        this.setIdref(string);
    }

    public void setRefnameByString(String string) {
        this.setRefname(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public IRNode getIdrefAsIRNode() {
        if (this.rContext_ == null) {
            return null;
        }
        return this.rContext_.getIRNode(this.getIdref());
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "foreignKey")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return ForeignKey.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (ForeignKey.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

