/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Javascript
implements Serializable,
Cloneable,
IRNode {
    private String content_;
    private String type_;
    private Boolean remove_;
    private Integer order_;
    private IRNode parentRNode_;
    private RContext rContext_;

    public Javascript() {
    }

    public Javascript(Javascript source) {
        this.setup(source);
    }

    public Javascript(RStack stack) {
        this.setup(stack);
    }

    public Javascript(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Javascript(Element element) {
        this.setup(element);
    }

    public Javascript(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Javascript(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Javascript(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Javascript(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Javascript(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Javascript(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Javascript source) {
        this.setContent(source.getContent());
        this.setType(source.getType());
        this.setRemove(source.getRemove());
        this.setOrder(source.getOrder());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.remove_ = URelaxer.getAttributePropertyAsBooleanObject(element, "remove");
        this.order_ = URelaxer.getAttributePropertyAsIntObject(element, "order");
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createJavascript(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("javascript");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.remove_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "remove", this.remove_);
        }
        if (this.order_ != null) {
            URelaxer.setAttributePropertyByInt(element, "order", this.order_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String content) {
        this.content_ = content;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public boolean getRemove() {
        if (this.remove_ == null) {
            return false;
        }
        return this.remove_;
    }

    public boolean getRemove(boolean remove) {
        if (this.remove_ == null) {
            return remove;
        }
        return this.remove_;
    }

    public Boolean getRemoveAsBoolean() {
        return this.remove_;
    }

    public boolean checkRemove() {
        return this.remove_ != null;
    }

    public void setRemove(boolean remove) {
        this.remove_ = new Boolean(remove);
    }

    public void setRemove(Boolean remove) {
        this.remove_ = remove;
    }

    public int getOrder() {
        if (this.order_ == null) {
            return 100;
        }
        return this.order_;
    }

    public int getOrder(int order) {
        if (this.order_ == null) {
            return order;
        }
        return this.order_;
    }

    public Integer getOrderAsInteger() {
        return this.order_;
    }

    public boolean checkOrder() {
        return this.order_ != null;
    }

    public void setOrder(int order) {
        this.order_ = new Integer(order);
    }

    public void setOrder(Integer order) {
        this.order_ = order;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<javascript");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.remove_ != null) {
            buffer.append(" remove=\"");
            buffer.append(URelaxer.getString(this.getRemove()));
            buffer.append("\"");
        }
        if (this.order_ != null) {
            buffer.append(" order=\"");
            buffer.append(URelaxer.getString(this.getOrder()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</javascript>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<javascript");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.remove_ != null) {
            buffer.write(" remove=\"");
            buffer.write(URelaxer.getString(this.getRemove()));
            buffer.write("\"");
        }
        if (this.order_ != null) {
            buffer.write(" order=\"");
            buffer.write(URelaxer.getString(this.getOrder()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</javascript>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<javascript");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.remove_ != null) {
            buffer.print(" remove=\"");
            buffer.print(URelaxer.getString(this.getRemove()));
            buffer.print("\"");
        }
        if (this.order_ != null) {
            buffer.print(" order=\"");
            buffer.print(URelaxer.getString(this.getOrder()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</javascript>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getRemoveAsString() {
        return URelaxer.getString(this.getRemove());
    }

    public String getOrderAsString() {
        return URelaxer.getString(this.getOrder());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setRemoveByString(String string) {
        this.setRemove((boolean)new Boolean(string));
    }

    public void setOrderByString(String string) {
        this.setOrder(Integer.parseInt(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "javascript")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Javascript.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Javascript.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

