/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IActionChoice;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IJobChoice;
import jp.jasminesoft.jfc.gen.appschema.IProjectChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Jobdesc;
import jp.jasminesoft.jfc.gen.appschema.Jobparam;
import jp.jasminesoft.jfc.gen.appschema.Jobrule;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import jp.jasminesoft.jfc.gen.appschema.Usebean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Job
implements Serializable,
Cloneable,
IRNode,
IActionChoice,
IProjectChoice {
    private String name_;
    private String classname_;
    private String memo_;
    private String type_;
    private String model_;
    private List content_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Job() {
        this.name_ = "";
        this.classname_ = "";
        this.type_ = "";
    }

    public Job(Job source) {
        this.setup(source);
    }

    public Job(RStack stack) {
        this.setup(stack);
    }

    public Job(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Job(Element element) {
        this.setup(element);
    }

    public Job(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Job(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Job(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Job(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Job(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Job(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Job source) {
        this.setName(source.getName());
        this.setClassname(source.getClassname());
        this.setMemo(source.getMemo());
        this.setType(source.getType());
        this.setModel(source.getModel());
        this.content_.clear();
        int size = source.content_.size();
        for (int i = 0; i < size; ++i) {
            this.addContent((IJobChoice)source.getContent(i).clone());
        }
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.classname_ = URelaxer.getAttributePropertyAsString(element, "classname");
        this.memo_ = URelaxer.getAttributePropertyAsString(element, "memo");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.model_ = URelaxer.getAttributePropertyAsString(element, "model");
        this.content_.clear();
        while (true) {
            if (Jobparam.isMatch(stack)) {
                this.addContent(factory.createJobparam(stack));
                continue;
            }
            if (Usebean.isMatch(stack)) {
                this.addContent(factory.createUsebean(stack));
                continue;
            }
            if (Jobrule.isMatch(stack)) {
                this.addContent(factory.createJobrule(stack));
                continue;
            }
            if (!Jobdesc.isMatch(stack)) break;
            this.addContent(factory.createJobdesc(stack));
        }
    }

    @Override
    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createJob(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("job");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.classname_ != null) {
            URelaxer.setAttributePropertyByString(element, "classname", this.classname_);
        }
        if (this.memo_ != null) {
            URelaxer.setAttributePropertyByString(element, "memo", this.memo_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.model_ != null) {
            URelaxer.setAttributePropertyByString(element, "model", this.model_);
        }
        int size = this.content_.size();
        for (int i = 0; i < size; ++i) {
            IJobChoice value = (IJobChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getClassname() {
        return this.classname_;
    }

    public final void setClassname(String classname) {
        this.classname_ = classname;
    }

    public final String getMemo() {
        return this.memo_;
    }

    public final void setMemo(String memo) {
        this.memo_ = memo;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getModel() {
        return this.model_;
    }

    public final void setModel(String model) {
        this.model_ = model;
    }

    public final IJobChoice[] getContent() {
        IJobChoice[] array = new IJobChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IJobChoice[] content) {
        int i;
        this.content_.clear();
        if (content != null) {
            for (i = 0; i < content.length; ++i) {
                this.addContent(content[i]);
            }
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setContent(IJobChoice content) {
        this.content_.clear();
        this.addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IJobChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
        if (content != null) {
            content.rSetRContext(this.rGetRContext());
        }
    }

    public final void addContent(IJobChoice[] content) {
        int i;
        for (i = 0; i < content.length; ++i) {
            this.addContent(content[i]);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetParentRNode(this);
        }
        for (i = 0; i < content.length; ++i) {
            content[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizeContent() {
        return this.content_.size();
    }

    public final IJobChoice getContent(int index) {
        return (IJobChoice)this.content_.get(index);
    }

    public final void setContent(int index, IJobChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void addContent(int index, IJobChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IJobChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        IJobChoice value;
        int i;
        buffer.append("<job");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.classname_ != null) {
            buffer.append(" classname=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getClassname())));
            buffer.append("\"");
        }
        if (this.memo_ != null) {
            buffer.append(" memo=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMemo())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.model_ != null) {
            buffer.append(" model=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getModel())));
            buffer.append("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</job>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        IJobChoice value;
        int i;
        buffer.write("<job");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.classname_ != null) {
            buffer.write(" classname=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getClassname())));
            buffer.write("\"");
        }
        if (this.memo_ != null) {
            buffer.write(" memo=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMemo())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.model_ != null) {
            buffer.write(" model=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getModel())));
            buffer.write("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</job>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        IJobChoice value;
        int i;
        buffer.print("<job");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.classname_ != null) {
            buffer.print(" classname=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getClassname())));
            buffer.print("\"");
        }
        if (this.memo_ != null) {
            buffer.print(" memo=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getMemo())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.model_ != null) {
            buffer.print(" model=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getModel())));
            buffer.print("\"");
        }
        int size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (i = 0; i < size; ++i) {
            value = (IJobChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</job>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getClassnameAsString() {
        return URelaxer.getString(this.getClassname());
    }

    public String getMemoAsString() {
        return URelaxer.getString(this.getMemo());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getModelAsString() {
        return URelaxer.getString(this.getModel());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setClassnameByString(String string) {
        this.setClassname(string);
    }

    public void setMemoByString(String string) {
        this.setMemo(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setModelByString(String string) {
        this.setModel(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "job")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (Jobparam.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Usebean.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Jobrule.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Jobdesc.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Job.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Job.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

