/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.appschema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Panel;
import jp.jasminesoft.jfc.gen.appschema.RContext;
import jp.jasminesoft.jfc.gen.appschema.RStack;
import jp.jasminesoft.jfc.gen.appschema.UJAXP;
import jp.jasminesoft.jfc.gen.appschema.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Layout
implements Serializable,
Cloneable,
IRNode {
    private String type_;
    private String outputmethod_;
    private List panel_ = new ArrayList();
    private IRNode parentRNode_;
    private RContext rContext_;

    public Layout() {
    }

    public Layout(Layout source) {
        this.setup(source);
    }

    public Layout(RStack stack) {
        this.setup(stack);
    }

    public Layout(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Layout(Element element) {
        this.setup(element);
    }

    public Layout(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Layout(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Layout(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Layout(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Layout(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Layout(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Layout source) {
        this.setType(source.getType());
        this.setOutputmethod(source.getOutputmethod());
        this.panel_.clear();
        int size = source.panel_.size();
        for (int i = 0; i < size; ++i) {
            this.addPanel((Panel)source.getPanel(i).clone());
        }
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        RStack stack = new RStack(element);
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.outputmethod_ = URelaxer.getAttributePropertyAsString(element, "outputmethod");
        this.panel_.clear();
        while (Panel.isMatch(stack)) {
            this.addPanel(factory.createPanel(stack));
        }
    }

    public Object clone() {
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        return factory.createLayout(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("layout");
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        if (this.outputmethod_ != null) {
            URelaxer.setAttributePropertyByString(element, "outputmethod", this.outputmethod_);
        }
        int size = this.panel_.size();
        for (int i = 0; i < size; ++i) {
            Panel value = (Panel)this.panel_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getType() {
        if (this.type_ == null) {
            return "standard";
        }
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final String getOutputmethod() {
        if (this.outputmethod_ == null) {
            return "CSSGrid";
        }
        return this.outputmethod_;
    }

    public final void setOutputmethod(String outputmethod) {
        this.outputmethod_ = outputmethod;
    }

    public final Panel[] getPanel() {
        Panel[] array = new Panel[this.panel_.size()];
        return this.panel_.toArray(array);
    }

    public final void setPanel(Panel[] panel) {
        int i;
        this.panel_.clear();
        if (panel != null) {
            for (i = 0; i < panel.length; ++i) {
                this.addPanel(panel[i]);
            }
        }
        for (i = 0; i < panel.length; ++i) {
            panel[i].rSetParentRNode(this);
        }
        for (i = 0; i < panel.length; ++i) {
            panel[i].rSetRContext(this.rGetRContext());
        }
    }

    public final void setPanel(Panel panel) {
        this.panel_.clear();
        this.addPanel(panel);
        if (panel != null) {
            panel.rSetParentRNode(this);
        }
        if (panel != null) {
            panel.rSetRContext(this.rGetRContext());
        }
    }

    public final void addPanel(Panel panel) {
        this.panel_.add(panel);
        if (panel != null) {
            panel.rSetParentRNode(this);
        }
        if (panel != null) {
            panel.rSetRContext(this.rGetRContext());
        }
    }

    public final void addPanel(Panel[] panel) {
        int i;
        for (i = 0; i < panel.length; ++i) {
            this.addPanel(panel[i]);
        }
        for (i = 0; i < panel.length; ++i) {
            panel[i].rSetParentRNode(this);
        }
        for (i = 0; i < panel.length; ++i) {
            panel[i].rSetRContext(this.rGetRContext());
        }
    }

    public final int sizePanel() {
        return this.panel_.size();
    }

    public final Panel getPanel(int index) {
        return (Panel)this.panel_.get(index);
    }

    public final void setPanel(int index, Panel panel) {
        this.panel_.set(index, panel);
        if (panel != null) {
            panel.rSetParentRNode(this);
        }
    }

    public final void addPanel(int index, Panel panel) {
        this.panel_.add(index, panel);
        if (panel != null) {
            panel.rSetParentRNode(this);
        }
    }

    public final void removePanel(int index) {
        this.panel_.remove(index);
    }

    public final void removePanel(Panel panel) {
        this.panel_.remove(panel);
    }

    public final void clearPanel() {
        this.panel_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<layout");
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        if (this.outputmethod_ != null) {
            buffer.append(" outputmethod=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOutputmethod())));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.panel_.size();
        for (int i = 0; i < size; ++i) {
            Panel value = (Panel)this.panel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</layout>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<layout");
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        if (this.outputmethod_ != null) {
            buffer.write(" outputmethod=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOutputmethod())));
            buffer.write("\"");
        }
        buffer.write(">");
        int size = this.panel_.size();
        for (int i = 0; i < size; ++i) {
            Panel value = (Panel)this.panel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</layout>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<layout");
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        if (this.outputmethod_ != null) {
            buffer.print(" outputmethod=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getOutputmethod())));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.panel_.size();
        for (int i = 0; i < size; ++i) {
            Panel value = (Panel)this.panel_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</layout>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public String getOutputmethodAsString() {
        return URelaxer.getString(this.getOutputmethod());
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public void setOutputmethodByString(String string) {
        this.setOutputmethod(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    @Override
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    @Override
    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        classNodes.addAll(this.panel_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    @Override
    public final RContext rGetRContext() {
        return this.rContext_;
    }

    @Override
    public final void rSetRContext(RContext rContext) {
        this.rContext_ = rContext;
        IRNode[] contextRNodes = this.rGetRNodes();
        for (int i = 0; i < contextRNodes.length; ++i) {
            contextRNodes[i].rSetRContext(this.rContext_);
        }
    }

    @Override
    public RContext rGetRContextResolved() {
        if (this.rContext_ != null) {
            return this.rContext_;
        }
        if (this.parentRNode_ == null) {
            return null;
        }
        return this.parentRNode_.rGetRContextResolved();
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "layout")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!Panel.isMatchHungry(target)) {
            return false;
        }
        $match$ = true;
        while (Panel.isMatchHungry(target)) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Layout.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Layout.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

