/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model;

import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractContent {
    public abstract String getName();

    public String getFieldName() {
        return JavaSourceGenerator.convertInstanceNameInRelaxerObject(this.getName());
    }

    public String getFieldName2() {
        String field_name = this.getFieldName();
        if (StringUtils.isNotBlank((CharSequence)field_name) && field_name.endsWith("_")) {
            return field_name.substring(0, field_name.length() - 1);
        }
        return field_name;
    }

    public String getRealFieldName() {
        return this.getFieldName();
    }

    public String getRealFieldName2() {
        String real_field_name = this.getRealFieldName();
        if (StringUtils.isNotBlank((CharSequence)real_field_name) && real_field_name.endsWith("_")) {
            return real_field_name.substring(0, real_field_name.length() - 1);
        }
        return real_field_name;
    }

    public String getVariableName() {
        return JavaSourceGenerator.convClassname4Relax(this.getName());
    }

    public String getAccessorName() {
        return SourceGenerator.capFirst(this.getName());
    }

    public abstract String getDataType();

    public String getWrapperClass() {
        String datatype = this.getDataType();
        if (JavaSourceGenerator.isBasicType(datatype)) {
            return JavaSourceGenerator.b2wc(this.getProperType());
        }
        return this.getProperType();
    }

    public String getProperType() {
        return JavaSourceGenerator.getProperType(this.getDataType());
    }

    public String getCapType() {
        String datatype = this.getDataType();
        if ("byte".equalsIgnoreCase(datatype)) {
            return "Byte";
        }
        if ("short".equalsIgnoreCase(datatype)) {
            return "Short";
        }
        if ("int".equalsIgnoreCase(datatype)) {
            return "Int";
        }
        if ("long".equalsIgnoreCase(datatype)) {
            return "Long";
        }
        if ("float".equalsIgnoreCase(datatype)) {
            return "Float";
        }
        if ("double".equalsIgnoreCase(datatype)) {
            return "Double";
        }
        if ("string".equalsIgnoreCase(datatype)) {
            return "String";
        }
        if ("date".equalsIgnoreCase(datatype)) {
            return "SQLDate";
        }
        if ("time".equalsIgnoreCase(datatype)) {
            return "SQLTime";
        }
        if ("dateTime".equalsIgnoreCase(datatype)) {
            return "SQLTimestamp";
        }
        if ("boolean".equalsIgnoreCase(datatype)) {
            return "Boolean";
        }
        return "";
    }

    public abstract String getClassName();

    public String getParseMethod(String param) {
        String datatype = this.getDataType();
        if ("byte".equalsIgnoreCase(datatype)) {
            return "Byte.parseByte(" + param + ")";
        }
        if ("short".equalsIgnoreCase(datatype)) {
            return "Short.parseShort(" + param + ")";
        }
        if ("int".equalsIgnoreCase(datatype)) {
            return "Integer.parseInt(" + param + ")";
        }
        if ("long".equalsIgnoreCase(datatype)) {
            return "Long.parseLong(" + param + ")";
        }
        if ("float".equalsIgnoreCase(datatype)) {
            return "Float.parseFloat(" + param + ")";
        }
        if ("double".equalsIgnoreCase(datatype)) {
            return "Double.parseDouble(" + param + ")";
        }
        if ("date".equalsIgnoreCase(datatype)) {
            return "jp.jasminesoft.jfc.model.URelaxer.getSQLDate(" + param + ")";
        }
        if ("time".equalsIgnoreCase(datatype)) {
            return "java.sql.Time.valueOf(" + param + ")";
        }
        if ("dateTime".equalsIgnoreCase(datatype)) {
            return "jp.jasminesoft.jfc.model.URelaxer.getSQLTimestamp(" + param + ")";
        }
        if ("boolean".equalsIgnoreCase(datatype)) {
            return "Boolean.valueOf(" + param + ").booleanValue()";
        }
        return param;
    }

    public String getParseMethod4Helper(String param) {
        String datatype = this.getDataType();
        if ("dateTime".equalsIgnoreCase(datatype)) {
            return "java.sql.Timestamp.valueOf(" + param + ").trim().replace('T', ' ')";
        }
        return this.getParseMethod(param);
    }

    public boolean isStringType() {
        return "string".equalsIgnoreCase(this.getDataType());
    }

    public boolean isBasicType() {
        return JavaSourceGenerator.isBasicType(this.getDataType());
    }

    public boolean isDateOrTimeType() {
        return JavaSourceGenerator.isDateOrTimeType(this.getDataType());
    }

    public boolean isBooleanType() {
        return "boolean".equalsIgnoreCase(this.getDataType());
    }
}

