/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.model.AbstractModelitemContent;
import jp.jasminesoft.jfc.gen.model.AttributeContent;
import jp.jasminesoft.jfc.gen.model.ButtonfieldContent;
import jp.jasminesoft.jfc.gen.model.ModelGeneratorBase;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModelGenerator
extends ModelGeneratorBase {
    protected Logger logger = LogManager.getLogger((String)AbstractModelGenerator.class.getName());
    private List<AttributeContent> attributeContentList = new ArrayList<AttributeContent>();
    private List<AbstractModelitemContent> modelitemContentList = new ArrayList<AbstractModelitemContent>();

    protected AbstractModelGenerator(Project project, Model model) {
        super(project, model);
    }

    public void addAttributeContent(AttributeContent attributeContent) {
        if (attributeContent != null) {
            this.attributeContentList.add(attributeContent);
        }
    }

    public void addModelitemContent(AbstractModelitemContent modelitemContent) {
        if (modelitemContent != null) {
            this.modelitemContentList.add(modelitemContent);
        }
    }

    public List<AttributeContent> getAttributeContentList() {
        return this.attributeContentList;
    }

    public List<AbstractModelitemContent> getModelitemContentList() {
        return this.modelitemContentList;
    }

    public List<ButtonfieldContent> getButtonfieldContentList() {
        return Collections.emptyList();
    }

    public void setAttributeContentList(List<AttributeContent> attributeContentList) {
        if (attributeContentList == null) {
            return;
        }
        this.attributeContentList.clear();
        for (AttributeContent attributeContent : attributeContentList) {
            this.addAttributeContent(attributeContent);
        }
    }

    public void setModelitemContentList(List<AbstractModelitemContent> modelitemContentList) {
        if (modelitemContentList == null) {
            return;
        }
        this.modelitemContentList.clear();
        for (AbstractModelitemContent modelitemContent : modelitemContentList) {
            this.addModelitemContent(modelitemContent);
        }
    }

    @Override
    public String process0() {
        if (this.project == null || this.model == null) {
            this.logger.error("skip generate modelitem");
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map = this.putParameter(map);
        return VelocityUtils.mergeContent((String)this.getTemplateFilePath(), map);
    }

    private String getModelType() {
        String type = this.model.getType();
        if (!type.equals("presentation")) {
            return type;
        }
        IRNode refmodel = this.model.getIdrefAsIRNode();
        if (refmodel == null || !(refmodel instanceof Model)) {
            throw new IllegalStateException("presentation model " + this.model.getId() + " idref is not model");
        }
        return ((Model)refmodel).getType() + "_" + type;
    }

    protected Map<String, Object> putParameter(Map<String, Object> context) {
        context.put("packageName", this.getPackageNameAsJavaRule());
        context.put("modelName", this.model.getId());
        context.put("version", this.project.getVersion());
        context.put("className", this.getClassname());
        context.put("className2", this.getClassname2());
        context.put("elementName", this.getElementName());
        context.put("templateRoot", "template/javasrc/model/");
        context.put("attributes", this.getAttributeContentList());
        context.put("modelitems", this.getModelitemContentList());
        context.put("buttonfields", this.getButtonfieldContentList());
        context.put("isValidNoselection", this.isValidNolselection());
        context.put("isStoreModel", this.isStoreModel());
        context.put("isPathlist", this.isPathlist());
        context.put("isPreparedDefaultAttribute", this.isPreparedDefaultAttribute());
        context.put("isContainer", this.isContainer());
        context.put("modelType", this.getModelType());
        context.put("implement", this.getImplement());
        String propOrderOfModelitems = this.createPropOrder();
        if (StringUtils.isNotBlank((CharSequence)propOrderOfModelitems)) {
            context.put("xmlType", "@XmlType(propOrder={ " + propOrderOfModelitems + " })");
        }
        context.put("appendCodes", this.appendCodes());
        return context;
    }

    protected String getImplement() {
        Object implement_str = this.model.getImplement();
        implement_str = StringUtils.isNotBlank((CharSequence)implement_str) && ("Juser".equals(this.getClassname()) || "Jfccspreferenceitem".equals(this.getClassname()) || "Jfcpreferenceitem".equals(this.getClassname()) || "Jfcjobschedule".equals(this.getClassname()) || "Jfcjobstatus".equals(this.getClassname()) || "Jfcjobstatususer".equals(this.getClassname()) || "Jfcjob".equals(this.getClassname()) || "Jfcmodel".equals(this.getClassname())) ? "java.io.Serializable, Cloneable, " + (String)implement_str : "java.io.Serializable, Cloneable";
        return implement_str;
    }

    protected String appendCodes() {
        return "";
    }

    private String createPropOrder() {
        return Stream.concat(this.getModelitemContentList().stream().map(mitem -> mitem.getFieldName()), this.getButtonfieldContentList().stream().map(bField -> bField.getFieldName())).map(fieldName -> StringUtils.wrap((String)fieldName, (String)"\"")).collect(Collectors.joining(", "));
    }

    protected String getClassname2() {
        return this.getClassname();
    }

    protected boolean isPreparedDefaultAttribute() {
        return false;
    }

    protected boolean isValidNolselection() {
        return false;
    }

    protected boolean isSortable() {
        return false;
    }

    protected boolean isStoreModel() {
        return this.model != null && "store".equals(this.model.getType());
    }

    protected boolean isPathlist() {
        return false;
    }

    @Override
    protected String getTemplateFile() {
        return "JFCModel.vm";
    }

    protected boolean isContainer() {
        return false;
    }
}

