/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.model.store.modelitem;

import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.model.store.ModelitemContent_store;
import jp.jasminesoft.jfc.gen.model.store.StoreModelGenerator;

public class StoreModelitemContainerGenerator
extends StoreModelGenerator {
    private Set<Modelitem> smitemSet;
    private String containerName;
    private Modelitem container_mitem;

    public StoreModelitemContainerGenerator(Project project, Model model, String containerName, Set<Modelitem> smitemSet) {
        super(project, model);
        this.containerName = containerName;
        this.smitemSet = smitemSet;
        if (this.isListModel()) {
            this.smodel = AppSchemaUtil.getStoreModel(model);
        }
        this.init();
    }

    private void init() {
        this.container_mitem = AppSchemaUtil.getModelitem(this.containerName, this.model);
        if (this.container_mitem == null) {
            Model __smodel = AppSchemaUtil.getStoreModel(this.model);
            this.container_mitem = AppSchemaUtil.getModelitem(this.containerName, __smodel);
        }
        if ("store".equals(this.model.getType())) {
            PrimaryKey[] pkeys;
            for (PrimaryKey pkey : pkeys = AppSchemaUtil.getPrimaryKey(AppSchemaUtil.getStoreModel(this.model))) {
                Modelitem smitem = AppSchemaUtil.getModelitem(pkey.getName(), this.model);
                this.generateModelitem(smitem);
            }
            Modelitem cont_jshid_mitem = new Modelitem();
            cont_jshid_mitem.setName(this.containerName + "jshid");
            cont_jshid_mitem.setType("int");
            cont_jshid_mitem.setMust(true);
            this.addModelitemContent(new ModelitemContent_store(this.project, cont_jshid_mitem, this.model));
        }
    }

    @Override
    public String getClassname() {
        if (this.container_mitem != null) {
            return AppSchemaUtil.getModelitemClassname(this.container_mitem);
        }
        return SourceGenerator.capFirst(this.containerName);
    }

    @Override
    public String getElementName() {
        return this.containerName;
    }

    @Override
    protected void generateModelitem() {
        if (this.smitemSet == null || this.smitemSet.size() == 0) {
            return;
        }
        for (Modelitem smitem : this.smitemSet.toArray(new Modelitem[0])) {
            if (this.isListModel()) {
                smitem = AppSchemaUtil.getModelitem(smitem.getName(), this.smodel);
            }
            this.generateModelitem(smitem);
        }
    }

    @Override
    protected void generateModelitem(Modelitem smitem) {
        Relation relation = AppSchemaUtil.getRelationTypeExceptRef(smitem);
        if (relation != null) {
            Model _rmodel = (Model)relation.getIdrefAsIRNode();
            PrimaryKey[] _r_pkeys = AppSchemaUtil.getPrimaryKey(_rmodel);
            if (_r_pkeys != null && _r_pkeys.length > 1) {
                for (int i = 0; i < _r_pkeys.length; ++i) {
                    Modelitem c_smitem = null;
                    try {
                        c_smitem = new Modelitem(smitem.makeDocument());
                    }
                    catch (ParserConfigurationException e) {
                        this.logger.warn(e.getMessage());
                        this.logger.debug((Object)e);
                        c_smitem = (Modelitem)smitem.clone();
                    }
                    c_smitem.setName(c_smitem.getName() + "_" + _r_pkeys[i].getName());
                    this.addModelitemContent(new ModelitemContent_store(this.project, c_smitem, smitem, i, this.smodel));
                }
            } else {
                this.addModelitemContent(new ModelitemContent_store(this.project, smitem, this.smodel));
            }
        } else {
            this.addModelitemContent(new ModelitemContent_store(this.project, smitem, this.smodel));
        }
    }

    @Override
    protected String getClassname2() {
        if (this.isListModel()) {
            return "";
        }
        return this.getClassname();
    }

    @Override
    protected boolean isGenerateThisClass() {
        return this.getModelitemContentList().size() > 0;
    }

    @Override
    protected boolean isContainer() {
        return true;
    }

    @Override
    protected String generateCompositeKey() {
        return "";
    }
}

