/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import jp.jasminesoft.jfc.gen.openapi.Str;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;

public class ApiResponseFactory {
    public static ApiResponses createStandard_200_400_401_500(String desc200, String contentType, Schema<?> schemaFor200) {
        ApiResponse res200 = ApiResponseFactory.create(desc200, contentType, schemaFor200);
        ApiResponse res400 = ApiResponseFactory.create("Unauthorized: \u30ed\u30b0\u30aa\u30f3\u8a8d\u8a3c\u3092\u884c\u308f\u305a\u306b\u64cd\u4f5c\u3057\u305f\u5834\u5408", null, null);
        ApiResponse res401 = ApiResponseFactory.create("Bad Request: Wagby\u304c\u5185\u90e8\u3067\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8(p.errors)\u3092\u30bb\u30c3\u30c8\u3057\u305f\u5834\u5408", "application/json", Toolbox.createRef("ErrorsWithMessage"));
        ApiResponse res500 = ApiResponseFactory.create("Internal Server Error: Wagby\u304c\u5185\u90e8\u3067\u4f8b\u5916\u3092\u691c\u51fa\u3057\u305f\u5834\u5408", null, null);
        ApiResponses all = new ApiResponses();
        all.addApiResponse("200", res200);
        all.addApiResponse("400", res400);
        all.addApiResponse("401", res401);
        all.addApiResponse("500", res500);
        return all;
    }

    public static ApiResponses createStandard_200_400_401_404_500(String desc200, String contentType, Schema<?> schemaFor200) {
        ApiResponse res404 = ApiResponseFactory.create("Not Found: \u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u5834\u5408 (\u65e2\u306b\u524a\u9664\u3055\u308c\u3066\u3044\u308b\u304b\uff0c\u95b2\u89a7\u6a29\u9650\u304c\u306a\u3044\u306a\u3069)", "application/json", Toolbox.createRef("ErrorsWithMessage"));
        ApiResponses all = ApiResponseFactory.createStandard_200_400_401_500(desc200, contentType, schemaFor200);
        all.addApiResponse("404", res404);
        return all;
    }

    public static ApiResponse create(String desc, String contentType, Schema<?> contentSchema) {
        ApiResponse resp = new ApiResponse();
        if (Str.notEmpty(desc)) {
            resp.setDescription(desc);
        }
        if (Str.notEmpty(contentType)) {
            MediaType mediaType = new MediaType();
            mediaType.setSchema(contentSchema);
            Content content = new Content();
            content.addMediaType(contentType, mediaType);
            resp.setContent(content);
        }
        return resp;
    }

    public static ApiResponse addHeader(ApiResponse resp, String headerType, String example) {
        StringSchema schema = new StringSchema();
        if (Str.notEmpty(example)) {
            schema.setExample((Object)example);
        }
        Header header = new Header();
        header.setSchema((Schema)schema);
        resp.addHeaderObject(headerType, header);
        return resp;
    }
}

