/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.gen.openapi.ComponentSchemaFactory;
import jp.jasminesoft.jfc.gen.openapi.Str;
import jp.jasminesoft.jfc.gen.openapi.spec.Metadata;
import jp.jasminesoft.jfc.gen.openapi.spec.ModelSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAPIBuilder {
    private static Logger LOGGER = LogManager.getLogger();
    private OpenAPI openApi = new OpenAPI();
    private List<ModelSpec> modelSpecs = null;

    public OpenAPIBuilder() {
        this.openApi.setInfo(new Info());
        this.modelSpecs = new ArrayList<ModelSpec>();
    }

    public void addModelSpec(ModelSpec ms) {
        this.modelSpecs.add(ms);
        LOGGER.debug("added ModelSpec '{} ({})'", (Object)ms.getId(), (Object)ms.getName());
    }

    public void setMetadata(Metadata metadata) {
        metadata.getExternalDoc().ifPresent(ext -> this.openApi.setExternalDocs(ext));
        metadata.getServers().ifPresent(servers -> this.openApi.setServers(servers));
        Info info = this.openApi.getInfo();
        info.setTitle(Str.trim(metadata.getApplicationName()));
        info.setDescription(Str.trim(metadata.getDescription()));
        info.setVersion(Str.trim(metadata.getWagbyVersion()));
        metadata.getContact().ifPresent(cnt -> info.setContact(cnt));
        metadata.getLicense().ifPresent(lic -> info.setLicense(lic));
        this.openApi.setInfo(info);
    }

    public OpenAPI build() {
        LOGGER.debug("start creating OpenAPI document...");
        Paths paths = new Paths();
        Components components = new Components();
        this.openApi.setPaths(paths);
        this.openApi.setComponents(components);
        this.modelSpecs.forEach(ms -> {
            this.openApi.addTagsItem(ms.getTag());
            ms.getPathItems().forEach((subUrl, pathItem) -> paths.addPathItem(subUrl, pathItem));
            ms.getComponentSchema().forEach((schemaId, schema) -> components.addSchemas(schemaId, schema));
        });
        ComponentSchemaFactory.createErrorSchema().forEach((id, schema) -> components.addSchemas(id, schema));
        components.setSecuritySchemes(ComponentSchemaFactory.createSecuritySchemes());
        LOGGER.debug("done.");
        return this.openApi;
    }
}

