/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class OpenAPIWriter {
    public void transformAndWrite(OutputFormat outputFormat, OpenAPI openApi, Path outputDir, String fileName) throws JsonProcessingException, IOException {
        if (fileName == null || ((String)fileName).trim().length() < 1) {
            fileName = "openapi." + outputFormat.toString().toLowerCase();
        }
        String yamlStr = this.transform(outputFormat, openApi);
        this.writeTo(yamlStr, outputDir, (String)fileName);
    }

    public String transform(OutputFormat outputFormat, OpenAPI openApi) throws JsonProcessingException {
        return outputFormat == OutputFormat.YAML ? Yaml.mapper().writeValueAsString((Object)openApi) : Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)openApi);
    }

    public void writeTo(String formattedOpenApi, Path outputDir, String fileName) throws IOException {
        Path outputFile = outputDir.resolve(fileName);
        Files.write(outputFile, formattedOpenApi.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static enum OutputFormat {
        YAML,
        JSON;

    }
}

