/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.bridge;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.AppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.IAppschemaFactory;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgModel;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgUtil;
import jp.jasminesoft.jfc.gen.openapi.spec.Metadata;
import org.xml.sax.SAXException;

public class AppschemaTransformer {
    private Project project_;
    private Metadata metadata_;
    private Map<String, BrdgModel> wagbyModels_ = new TreeMap<String, BrdgModel>();

    public AppschemaTransformer(File appschemaXmlFile) throws IOException {
        this(AppschemaTransformer.getProject(appschemaXmlFile));
    }

    public AppschemaTransformer(Project project) {
        this.project_ = project;
        this.init();
    }

    private static Project getProject(File appschemaXmlFile) throws IOException {
        Project project = null;
        if (appschemaXmlFile == null || !appschemaXmlFile.exists()) {
            throw new FileNotFoundException("Appschema XML File does not exist.");
        }
        IAppschemaFactory factory = AppschemaFactory.getFactory();
        try {
            project = factory.createProject(appschemaXmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new IOException("Cannot load Appschema XML file correctly.", e);
        }
        return project;
    }

    public Metadata getMetadata() {
        return this.metadata_;
    }

    public Map<String, BrdgModel> getBridgeModels() {
        return this.wagbyModels_;
    }

    private void init() {
        this.metadata_ = new Metadata(this.project_.getName(), this.project_.getDescription(), this.project_.getVersion());
        List<String> storeModelIds = BrdgUtil.findUserDefinedModelIds(this.project_);
        storeModelIds.forEach(storeModelId -> {
            Model model_s = AppSchemaUtil.getModel(this.project_, storeModelId);
            if (!model_s.getRestV3()) {
                return;
            }
            Model model_p = AppSchemaUtil.getModel(this.project_, storeModelId, "presentation");
            Model model_l = AppSchemaUtil.getModel(this.project_, storeModelId, "list");
            Model model_lp = AppSchemaUtil.getPresentationModel(this.project_, model_l);
            Model model_c = AppSchemaUtil.getModel(this.project_, storeModelId, "condition");
            Model model_cp = AppSchemaUtil.getPresentationModel(this.project_, model_c);
            BrdgModel wagModel = new BrdgModel(model_s, model_p, model_l, model_lp, model_c, model_cp);
            this.wagbyModels_.put((String)storeModelId, wagModel);
        });
    }
}

