/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.bridge;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.appgen.component.AbstractPrimarykey;
import jp.jasminesoft.jfc.appgen.component.BaseModel;
import jp.jasminesoft.jfc.appgen.component.CompositePrimarykey;
import jp.jasminesoft.jfc.appgen.component.SimplePrimarykey;
import jp.jasminesoft.jfc.appgen.component.StoreModel;
import jp.jasminesoft.jfc.appgen.component.appschema.ModelUtils;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.appschema.Format;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Relation;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgAttribute;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrdgModel
extends BaseModel {
    private static Logger LOGGER = LogManager.getLogger();
    private String modelId_;
    private String modelDesc_;
    private boolean readOnly_ = false;
    private List<String> presentationModelitems_ = null;
    private List<String> listModelitems_ = null;
    private Map<String, BrdgAttribute> attrs_ = new LinkedHashMap<String, BrdgAttribute>();

    public BrdgModel(Model model_s, Model model_p, Model model_l, Model model_lp, Model model_c, Model model_cp) {
        super(model_s);
        this.modelId_ = model_s.getId();
        this.modelDesc_ = model_s.getDescription();
        this.initModelItems(model_s, model_p, model_l);
        this.readOnly_ = model_s.getStatic();
    }

    @Override
    public String getId() {
        return this.modelId_;
    }

    public String getDescription() {
        return this.modelDesc_;
    }

    public boolean isReadOnlyModel() {
        return this.readOnly_;
    }

    public Schema<?> getSchema() {
        ObjectSchema schema = new ObjectSchema();
        try {
            this.attrs_.forEach((itemId, attr) -> schema.addProperties(attr.getId(), attr.toSchema()));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Error during conversion to Schema (model: " + this.modelId_ + "): " + e.getMessage());
        }
        schema.addProperties("wbversion", (Schema)new IntegerSchema());
        return schema;
    }

    public Schema<?> getListSchema() {
        ArraySchema arr = new ArraySchema();
        ObjectSchema schema = new ObjectSchema();
        this.attrs_.forEach((itemId, attr) -> {
            if (!this.listModelitems_.contains(itemId)) {
                return;
            }
            Schema<?> attrSchema = attr.toSchema();
            if (itemId.endsWith("_jshfilename")) {
                attrSchema = Toolbox.create_jshfilenameSchema();
            }
            schema.addProperties(attr.getId(), attrSchema);
        });
        arr.setItems((Schema)schema);
        return arr;
    }

    public Schema<?> getFormSchema() {
        ObjectSchema schema = new ObjectSchema();
        this.attrs_.forEach((itemId, attr) -> {
            if (!this.presentationModelitems_.contains(itemId)) {
                return;
            }
            Schema<?> attrSchema = attr.toSchema();
            if (itemId.endsWith("_jshfilename")) {
                attrSchema = Toolbox.create_jshfilenameSchema();
            }
            schema.addProperties(attr.getId(), attrSchema);
        });
        schema.addProperties("jshfilenames", Toolbox.createJshfilenamesSchema());
        schema.addProperties("wbversion", (Schema)new IntegerSchema());
        return schema;
    }

    private void initModelItems(Model model_s, Model model_p, Model model_l) {
        this.presentationModelitems_ = Arrays.asList(ModelUtils.getModelitems(model_p)).stream().map(item -> item.getName()).collect(Collectors.toList());
        this.listModelitems_ = Arrays.asList(ModelUtils.getModelitems(model_l)).stream().map(item -> item.getName()).collect(Collectors.toList());
        Map pModelItems = Arrays.asList(ModelUtils.getModelitems(model_p)).stream().collect(Collectors.toMap(item -> item.getName(), Function.identity()));
        Arrays.stream(ModelUtils.getModelitems(model_s)).forEach(item_s -> {
            String itemId = item_s.getName();
            Modelitem item_p = (Modelitem)pModelItems.get(itemId);
            if (item_p == null) {
                return;
            }
            String label = item_p.getLabel();
            BrdgAttribute attr = new BrdgAttribute(itemId, label);
            attr.setRequired(item_s.getMust());
            attr.setDataType(item_s.getType());
            if ("storeref".equals(attr.getDataType())) {
                Relation relation = AppSchemaUtil.getRelation(item_s);
                String refType = relation.getType();
                if (relation != null) {
                    String refModelId = relation.getIdref();
                    Model refModel = AppSchemaUtil.getModel(this.getProject(), refModelId);
                    PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKey(refModel);
                    String pkeyName = pkeys[0].getName();
                    Modelitem pkeyModelItem = AppSchemaUtil.getModelitem(pkeyName, refModel);
                    attr.setRefModelInfo(refType, refModelId, pkeyName, pkeyModelItem.getType());
                }
            }
            String regex = BrdgUtil.getRegex(item_p);
            Format[] formats = AppSchemaUtil.getFormat(item_s);
            if (regex != null) {
                attr.setFormat(regex);
            } else if (formats != null && formats.length > 0) {
                attr.setFormat(formats[0].getContent());
            }
            this.attrs_.put(itemId, attr);
        });
    }

    public String getPath() {
        return Stream.of(this.getPrimarykeyElements()).map(element -> "{" + element.getName() + "}").collect(Collectors.joining("/", "/", ""));
    }

    private SimplePrimarykey[] getPrimarykeyElements() {
        AbstractPrimarykey primaryKey = new StoreModel(this.getModel()).getPrimarykey();
        if (!primaryKey.isCompositeKey()) {
            return new SimplePrimarykey[]{(SimplePrimarykey)primaryKey};
        }
        return ((CompositePrimarykey)primaryKey).getElements();
    }

    public Parameter[] createParameters() {
        return (Parameter[])Stream.of(this.getPrimarykeyElements()).map(element -> this.createParameter(this.attrs_.get(element.getName()))).toArray(Parameter[]::new);
    }

    private Parameter createParameter(BrdgAttribute brdgAttribute) {
        return Toolbox.createParameter(Toolbox.ParamType.PATH, brdgAttribute.getId(), brdgAttribute.getName() + "\u3092\u6307\u5b9a", true, brdgAttribute.toSchema().description(null));
    }
}

