/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.spec;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jp.jasminesoft.jfc.gen.openapi.Str;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Metadata {
    private static Logger LOGGER = LogManager.getLogger();
    private String applicationName;
    private String description;
    private String wagbyVersion;
    private Contact contact = null;
    private License license = null;
    private ExternalDocumentation externalDoc = null;
    private List<Server> servers = null;

    public Metadata() {
    }

    public Metadata(String appName, String desc, String wagbyVersion) {
        this.applicationName = appName;
        this.description = desc;
        this.wagbyVersion = wagbyVersion;
        LOGGER.debug("app name: {}, desc: {}, version: {}", (Object)this.applicationName, (Object)this.description, (Object)this.wagbyVersion);
    }

    public String toString() {
        return String.format("Name: %s, Desc: %s, Ver.%s", this.applicationName, this.description, this.wagbyVersion);
    }

    public void setExternalDocs(String desc, String url) {
        if (Str.empty(desc) && Str.empty(url)) {
            return;
        }
        this.externalDoc = new ExternalDocumentation();
        this.externalDoc.setDescription(Str.trim(desc));
        this.externalDoc.setUrl(Str.trim(url));
        LOGGER.debug("added External Doc: {} ()", (Object)desc, (Object)url);
    }

    public void addServer(String url, String desc) {
        if (Str.empty(url) && Str.empty(desc)) {
            return;
        }
        Server server = new Server();
        server.setUrl(Str.trim(url));
        server.setDescription(Str.trim(desc));
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
        LOGGER.debug("added server: {} ({})", (Object)desc, (Object)url);
    }

    public void setContact(String name, String url, String email) {
        if (Str.empty(name) && Str.empty(url) && Str.empty(email)) {
            return;
        }
        this.contact = new Contact();
        if (Str.notEmpty(name)) {
            this.contact.setName(name);
        }
        if (Str.notEmpty(url)) {
            this.contact.setUrl(url);
        }
        if (Str.notEmpty(email)) {
            this.contact.setEmail(email);
        }
        LOGGER.debug("added contact: {} ({})", (Object)name, (Object)url);
    }

    public void setLicense(String name, String url) {
        if (Str.empty(name) && Str.empty(url)) {
            return;
        }
        this.license = new License();
        if (Str.notEmpty(name)) {
            this.license.setName(name);
        }
        if (Str.notEmpty(url)) {
            this.license.setUrl(url);
        }
        LOGGER.debug("added license: {}, ({})", (Object)name, (Object)url);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWagbyVersion() {
        return this.wagbyVersion;
    }

    public Optional<Contact> getContact() {
        return Optional.ofNullable(this.contact);
    }

    public Optional<License> getLicense() {
        return Optional.ofNullable(this.license);
    }

    public Optional<ExternalDocumentation> getExternalDoc() {
        return Optional.ofNullable(this.externalDoc);
    }

    public Optional<List<Server>> getServers() {
        return Optional.ofNullable(this.servers);
    }
}

