/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.openapi.spec;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.openapi.ApiResponseFactory;
import jp.jasminesoft.jfc.gen.openapi.Toolbox;
import jp.jasminesoft.jfc.gen.openapi.bridge.BrdgModel;
import jp.jasminesoft.jfc.gen.openapi.spec.ModelSpec;

public class ModelSpecImpl
implements ModelSpec {
    protected String modelId_;
    protected String modelName_;
    protected String modelListId_;
    protected String modelFormId_;
    private BrdgModel wagbyModel_;

    public void setBridgeModel(BrdgModel wagModel) {
        this.wagbyModel_ = wagModel;
        this.setName(this.wagbyModel_.getDescription());
        this.setId(this.wagbyModel_.getId());
    }

    @Override
    public String getId() {
        return this.modelId_;
    }

    public void setId(String id) {
        this.modelId_ = id;
        this.modelListId_ = this.modelId_ + "List";
        this.modelFormId_ = this.modelId_ + "Form";
    }

    @Override
    public String getName() {
        return this.modelName_;
    }

    public void setName(String name) {
        this.modelName_ = name;
    }

    @Override
    public Tag getTag() {
        Tag tag = new Tag();
        tag.setName(this.modelId_);
        tag.setDescription(this.modelName_);
        return tag;
    }

    @Override
    public Map<String, Schema<?>> getComponentSchema() {
        LinkedHashMap results = new LinkedHashMap();
        results.put(this.modelId_, this.wagbyModel_.getSchema());
        results.put(this.modelListId_, this.wagbyModel_.getListSchema());
        if (!this.wagbyModel_.isReadOnlyModel()) {
            results.put(this.modelFormId_, this.wagbyModel_.getFormSchema());
        }
        return results;
    }

    @Override
    public Map<String, PathItem> getPathItems() {
        String v3_modelx = "/v3/" + this.modelId_;
        String v3_modelx_id = "/v3/" + this.modelId_ + this.wagbyModel_.getPath();
        String v3_modelx_init = "/v3/" + this.modelId_ + "/_";
        LinkedHashMap<String, PathItem> results = new LinkedHashMap<String, PathItem>();
        results.put(v3_modelx, this.prepare_V3_MODELx());
        results.put(v3_modelx_id, this.prepare_V3_MODELx_ID());
        if (!this.wagbyModel_.isReadOnlyModel()) {
            results.put(v3_modelx_init, this.prepare_V3_MODELx_init());
        }
        return results;
    }

    protected List<SecurityRequirement> prepareSecurityRequirements() {
        SecurityRequirement secq0 = new SecurityRequirement();
        secq0.addList("cookieAuth", new ArrayList());
        SecurityRequirement secq1 = new SecurityRequirement();
        secq1.addList("autoLogonAuth", new ArrayList());
        return Arrays.asList(secq0, secq1);
    }

    protected PathItem prepare_V3_MODELx() {
        PathItem pathItem = new PathItem();
        Operation opGet = new Operation();
        opGet.addTagsItem(this.getTag().getName());
        opGet.setDescription("\u4e00\u89a7\u8868\u793a\u30c7\u30fc\u30bf\u3092\u53d6\u5f97");
        opGet.setSecurity(this.prepareSecurityRequirements());
        opGet.addParametersItem(Toolbox.createParameter(Toolbox.ParamType.QUERY, "_start", "\u53d6\u5f97\u958b\u59cb\u4f4d\u7f6e", false, Toolbox.addProps(new IntegerSchema(), null, "0", null)));
        opGet.addParametersItem(Toolbox.createParameter(Toolbox.ParamType.QUERY, "_end", "\u53d6\u5f97\u7d42\u4e86\u4f4d\u7f6e", false, Toolbox.addProps(new IntegerSchema(), null, "10", null)));
        opGet.addParametersItem(Toolbox.createParameter(Toolbox.ParamType.QUERY, "_order", "\u4e26\u3073\u9806", false, Toolbox.addProps(new StringSchema(), null, "ASC", null)));
        opGet.addParametersItem(Toolbox.createParameter(Toolbox.ParamType.QUERY, "_sort", "\u30bd\u30fc\u30c8\u9805\u76ee", false, Toolbox.addProps(new StringSchema(), null, "id", null)));
        opGet.setResponses(ApiResponseFactory.createStandard_200_400_401_500("\u4e00\u89a7\u53d6\u5f97\u7d50\u679c", "application/json", Toolbox.createRef(this.modelListId_)));
        pathItem.setGet(opGet);
        if (!this.wagbyModel_.isReadOnlyModel()) {
            Operation opPost = new Operation();
            opPost.addTagsItem(this.getTag().getName());
            opPost.setDescription("\u65b0\u898f\u8ffd\u52a0");
            opPost.setSecurity(this.prepareSecurityRequirements());
            RequestBody reqBody = new RequestBody();
            Content content = new Content();
            MediaType mediaType = new MediaType();
            mediaType.setSchema((Schema)Toolbox.createRef(this.modelFormId_));
            content.addMediaType("application/json", mediaType);
            reqBody.setContent(content);
            opPost.setRequestBody(reqBody);
            opPost.setResponses(ApiResponseFactory.createStandard_200_400_401_500("\u6210\u529f", "application/json", Toolbox.createRef(this.modelId_)));
            pathItem.setPost(opPost);
        }
        return pathItem;
    }

    protected PathItem prepare_V3_MODELx_ID() {
        PathItem pathItem = new PathItem();
        Parameter[] parameters = this.wagbyModel_.createParameters();
        Operation opGet = new Operation();
        opGet.addTagsItem(this.getTag().getName());
        opGet.setDescription("\u8a73\u7d30\u30c7\u30fc\u30bf\u53d6\u5f97");
        opGet.setSecurity(this.prepareSecurityRequirements());
        Stream.of(parameters).forEach(parameter -> opGet.addParametersItem(parameter));
        opGet.setResponses(ApiResponseFactory.createStandard_200_400_401_404_500("\u6210\u529f", "application/json", Toolbox.createRef(this.modelId_)));
        pathItem.setGet(opGet);
        if (!this.wagbyModel_.isReadOnlyModel()) {
            Operation opPut = new Operation();
            opPut.addTagsItem(this.getTag().getName());
            opPut.setDescription("\u66f4\u65b0\u64cd\u4f5c");
            opPut.setSecurity(this.prepareSecurityRequirements());
            Stream.of(parameters).forEach(parameter -> opPut.addParametersItem(parameter));
            MediaType mediaType = new MediaType();
            mediaType.setSchema((Schema)Toolbox.createRef(this.modelFormId_));
            Content content = new Content();
            content.addMediaType("application/json", mediaType);
            RequestBody reqBody = new RequestBody();
            reqBody.setContent(content);
            opPut.setRequestBody(reqBody);
            opPut.setResponses(ApiResponseFactory.createStandard_200_400_401_500("\u6210\u529f", "application/json", Toolbox.createRef(this.modelId_)));
            pathItem.setPut(opPut);
            Operation opDel = new Operation();
            opDel.addTagsItem(this.getTag().getName());
            opDel.setDescription("\u524a\u9664");
            opDel.setSecurity(this.prepareSecurityRequirements());
            Stream.of(parameters).forEach(parameter -> opDel.addParametersItem(parameter));
            opDel.setResponses(ApiResponseFactory.createStandard_200_400_401_500("\u6210\u529f", "application/json", Toolbox.createRef("ErrorsWithMessage")));
            pathItem.setDelete(opDel);
        }
        return pathItem;
    }

    protected PathItem prepare_V3_MODELx_init() {
        Operation opGet = new Operation();
        opGet.addTagsItem(this.getTag().getName());
        opGet.setDescription("\u521d\u671f\u5024\u3092\u53d6\u5f97\u3059\u308b: \u30ec\u30b9\u30dd\u30f3\u30b9\u306b\u306f\u521d\u671f\u5024\u306e\u307f\u30bb\u30c3\u30c8\u3055\u308c\u305f\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u304c\u8fd4\u308b");
        opGet.setSecurity(this.prepareSecurityRequirements());
        opGet.setResponses(ApiResponseFactory.createStandard_200_400_401_500("\u6210\u529f", "application/json", Toolbox.createRef(this.modelId_)));
        PathItem pathItem = new PathItem();
        pathItem.setGet(opGet);
        return pathItem;
    }
}

