/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.dojo;

import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.dojo.WidgetProps;
import org.apache.commons.lang3.StringUtils;

public class DateTimeProps
extends WidgetProps<DateTimeProps> {
    String dateFormat;
    String timeFormat;
    String subformat;
    String rangeType;
    String enterKeyAction;

    public DateTimeProps(Project project, Model pmodel, Displayitem ditem, Modelitem mitem, Modelitem pitem) {
        super(project, pmodel, ditem, mitem, pitem);
        this.initProps();
    }

    public DateTimeProps() {
    }

    @Override
    public void initProps() {
        super.initProps();
        this.setDateFormat();
        this.setSubformat();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getRangeType() {
        return this.rangeType;
    }

    @Override
    public String getEnterKeyAction() {
        return this.enterKeyAction;
    }

    public DateTimeProps setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    public DateTimeProps setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    public DateTimeProps setRangeType(String rangeType) {
        this.rangeType = rangeType;
        return this;
    }

    @Override
    public DateTimeProps setEnterKeyAction(String enterKeyAction) {
        this.enterKeyAction = enterKeyAction;
        return this;
    }

    private void setDateFormat() {
        Displayitem ditem = this.getDitem();
        if (ditem == null) {
            return;
        }
        String format = ditem.getDateformat();
        if (StringUtils.isBlank((CharSequence)format)) {
            return;
        }
        if (!StringUtils.contains((CharSequence)format, (CharSequence)" ")) {
            this.dateFormat = format;
            return;
        }
        String[] dateTimeFormat = format.split(" ");
        this.dateFormat = dateTimeFormat[0];
        this.timeFormat = dateTimeFormat[1];
    }

    private void setSubformat() {
        Displayitem ditem = this.getDitem();
        if (ditem == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)ditem.getSubformat())) {
            return;
        }
        this.subformat = ditem.getSubformat();
    }

    @Override
    public DateTimeProps setDisplayitem(Displayitem ditem) {
        super.setDisplayitem(ditem);
        this.setSubformat();
        return this;
    }

    @Override
    public DateTimeProps getThis() {
        return this;
    }
}

