/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.dojo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.gen.ui.dojo.WidgetProps;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Widget {
    protected Logger logger = LogManager.getLogger((String)Widget.class.getName());
    String id;
    String name;
    String type;
    String valueEl;
    String htmlClass;
    String style;
    String tabIndex;
    String attr;
    String original;
    WidgetProps<?> widgetProps;

    public Widget(String id, String valueEl, String style) {
        this.id = id;
        this.valueEl = valueEl;
        this.style = style;
    }

    public Widget(WidgetProps<?> widgetProps) {
        this.widgetProps = widgetProps;
        this.setProps(widgetProps.getProps());
    }

    public Widget() {
    }

    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            return this.id;
        }
        return this.name;
    }

    public String getThValue() {
        if (this.widgetProps == null) {
            return this.valueEl;
        }
        return this.getProp("th:value", this.getWidgetPropValue("valueEl"));
    }

    public String getThText(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return "";
        }
        return this.getProp("th:text", label);
    }

    public String getThUText(String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return "";
        }
        return this.getProp("th:utext", label);
    }

    public String getType() {
        return this.getWidgetPropValue("type");
    }

    public String getDojoProps() {
        String dataOriginal;
        String pid;
        StringBuilder dojoProps = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getWidgetPropValue("dojoProps"))) {
            dojoProps.append(this.getWidgetPropValue("dojoProps")).append(", ");
        }
        ArrayList<String> dojoPropList = new ArrayList<String>();
        dojoPropList.add(this.getDojoProp("inputError"));
        dojoPropList.add(this.getDojoProp("tabIndex"));
        dojoPropList.add(this.getDojoProp("cursorPosition"));
        dojoPropList.add(this.getDojoProp("enterKeyAction"));
        dojoPropList.add(this.getEventFunc("onChange", this.getOnChange()));
        dojoPropList.add(this.getEventFunc("onKeyDown", this.getEnterKeyEventFunc()));
        dojoPropList.add(this.getEventFunc("onBlur", this.getOnBlur()));
        dojoPropList.add(this.getEventFunc("onFocus", "setScrollPosition(this.id);"));
        dojoProps.append(this.getDojoPropsFromList(dojoPropList));
        StringBuilder attrsb = null;
        String dateFormat = this.getWidgetPropValue("dateFormat");
        String numberFormat = this.getWidgetPropValue("numberFormat");
        if (dateFormat != null && (dateFormat.indexOf("${") >= 0 || dateFormat.indexOf("SESSION") >= 0 || dateFormat.indexOf("ATTRIBUTE") > 0)) {
            attrsb = new StringBuilder();
            pid = this.id.substring(0, this.id.indexOf("_002f"));
            if (dateFormat.startsWith("SESSION") || dateFormat.startsWith("ATTRIBUTE")) {
                String code = "#session.getAttribute";
                if (dateFormat.startsWith("ATTRIBUTE")) {
                    code = "#httpServletRequest.getAttribute";
                }
                int ptr1 = dateFormat.indexOf("\"");
                int ptr2 = dateFormat.lastIndexOf("\"");
                if (ptr1 > 0 && ptr2 > 0 && ptr1 < ptr2) {
                    String key = dateFormat.substring(ptr1 + 1, ptr2);
                    key = key.replace("\\", "");
                    attrsb.append("dateFormat=|${#jfc.conversionDateFormat(").append(code).append("('").append(key).append("'))}|");
                }
            }
        } else if (numberFormat != null && (numberFormat.indexOf("${") >= 0 || numberFormat.indexOf("SESSION") >= 0 || numberFormat.indexOf("ATTRIBUTE") > 0)) {
            attrsb = new StringBuilder();
            pid = this.id.substring(0, this.id.indexOf("_002f"));
            attrsb.append("constraints=|{pattern: '${");
            attrsb.append(ThBodyGenerator.convertNumberFormat(pid, numberFormat, ".content"));
            attrsb.append("}' }|");
        }
        if (attrsb != null) {
            this.attr = attrsb.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)(dataOriginal = this.getDojoProp("dataOriginal"))) && this.valueEl != null) {
            String originalEl = null;
            originalEl = "${idValue}".equals(this.valueEl) ? this.valueEl.replace("idValue", "originalValue") : this.valueEl.replace(".content", ".original");
            this.original = "data-original=|" + originalEl + "|";
        }
        if (dojoProps.length() == 0 && this.attr == null && this.original == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.contains((CharSequence)dojoProps.toString(), (CharSequence)"${") || StringUtils.contains((CharSequence)dojoProps.toString(), (CharSequence)"#{") || this.attr != null || this.original != null) {
            sb.append(" th:attr=\"data-dojo-props=|").append(dojoProps.toString()).append("|");
            if (this.attr != null) {
                sb.append(",").append(this.attr);
            }
            if (this.original != null) {
                sb.append(",").append(this.original);
            }
            sb.append("\"");
        } else {
            sb.append(" data-dojo-props=\"").append(dojoProps.toString()).append("\"");
        }
        return sb.toString();
    }

    private String getDojoPropsFromList(List<String> dojoPropList) {
        return dojoPropList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p)).collect(Collectors.joining(", "));
    }

    private String getEventFunc(String eventName, String func) {
        if (StringUtils.isBlank((CharSequence)func)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(eventName).append(": function(event) { ").append(func).append(" }");
        return sb.toString();
    }

    public String getEnterKeyEventFunc() {
        if ("changetab".equals(this.widgetProps.enterKeyAction)) {
            return "if (event.keyCode !== 0x0d) return; enterKeyHandler.focusNextElement(this, event);";
        }
        if ("ignore".equals(this.widgetProps.enterKeyAction)) {
            return "if (event.keyCode !== 0x0d) return; event.preventDefault();";
        }
        if ("default".equals(this.widgetProps.enterKeyAction)) {
            return "if (event.keyCode !== 0x0d) return; doSubmitForm(event.srcElement.form);";
        }
        return null;
    }

    private String escapeDojoPropsQuote(String props) {
        String escapedProps = RegExUtils.replaceAll((String)props, (Pattern)Pattern.compile("'"), (String)"\\\\'");
        return RegExUtils.replaceAll((String)escapedProps, (Pattern)Pattern.compile("\"\""), (String)"''");
    }

    public String getDisabled() {
        return this.getProp("disabled");
    }

    public String getReadonly() {
        return this.getProp("readonly");
    }

    public String getTitle() {
        return this.getProp("title");
    }

    public String getPlaceholder() {
        return this.getProp("placeholder");
    }

    public String getWith() {
        String key = "with";
        String value = this.getWidgetPropValue(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" th:").append(key).append("=\"").append(value).append("\"");
        return sb.toString();
    }

    public String getOnChange() {
        return this.getWidgetPropValue("onChange");
    }

    public String getOnBlur() {
        return this.getWidgetPropValue("onBlur");
    }

    public String getStyle() {
        Object style = this.getWidgetPropValue("style");
        String size = this.getWidgetPropValue("size");
        if (StringUtils.isNotBlank((CharSequence)size)) {
            String sizeStyle = "width: " + size + "em;";
            if (StringUtils.isBlank((CharSequence)style)) {
                style = sizeStyle;
            } else if (StringUtils.isBlank((CharSequence)sizeStyle) && !StringUtils.contains((CharSequence)style, (CharSequence)"width")) {
                style = (String)style + ";" + sizeStyle;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)style)) {
            return this.getProp("style", ((String)style).replaceAll("\"", ""));
        }
        return "";
    }

    public String getCommonProps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProp("id", this.id)).append(this.getProp("name", this.getName())).append(this.getProp("class", this.htmlClass)).append(this.getStyle()).append(this.getWith()).append(this.getDojoProps()).append(this.getThValue()).append(this.getDisabled()).append(this.getReadonly()).append(this.getTitle()).append(this.getPlaceholder()).append(this.getProp("byteSize")).append(this.getProp("required")).append(this.getProp("regExp"));
        return sb.toString();
    }

    public String getConstraints() {
        String range;
        ArrayList<Object> constraints = new ArrayList<Object>();
        String pattern = this.getPattern();
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            constraints.add("pattern: '" + pattern + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)(range = this.getWidgetPropValue("range")))) {
            constraints.add(range);
        }
        if (constraints.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" constraints=\"{").append(constraints.stream().collect(Collectors.joining(", "))).append("}\"");
        return sb.toString();
    }

    public String getDojoProp(String key) {
        return this.getDojoProp(key, this.getWidgetPropValue(key));
    }

    public String getDojoProp(String key, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPropKey(key, value)).append(": '").append(value).append("'");
        return sb.toString();
    }

    public String getProp(String key) {
        return this.getProp(key, this.getWidgetPropValue(key), true);
    }

    public String getProp(String key, boolean condition) {
        return this.getProp(key, this.getWidgetPropValue(key), condition);
    }

    public String getProp(String key, String value) {
        return this.getProp(key, value, true);
    }

    public String getProp(String key, String value, boolean condition) {
        if (StringUtils.isBlank((CharSequence)value) || !condition) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(this.getPropKey(key, value)).append("=\"").append(this.getPropValue(value)).append("\"");
        return sb.toString();
    }

    private String getPropKey(String key, String value) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"th:") || "inputError".equals(key)) {
            return key;
        }
        StringBuilder sb = new StringBuilder();
        if (StringUtils.contains((CharSequence)value, (CharSequence)"${") || StringUtils.contains((CharSequence)value, (CharSequence)"#{")) {
            sb.append("th:");
        }
        sb.append(key);
        return sb.toString();
    }

    private String getPropValue(String value) {
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"|") || (StringUtils.startsWith((CharSequence)value, (CharSequence)"${") || StringUtils.startsWith((CharSequence)value, (CharSequence)"#{")) && StringUtils.endsWith((CharSequence)value, (CharSequence)"}")) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value);
        if (StringUtils.contains((CharSequence)value, (CharSequence)"${") || StringUtils.contains((CharSequence)value, (CharSequence)"#{")) {
            sb.insert(0, "|");
            sb.append("|");
        }
        return sb.toString();
    }

    public String getWidgetPropValue(String key) {
        if (this.widgetProps == null) {
            return "";
        }
        return this.widgetProps.getProps().get(key);
    }

    public void setProps(Map<String, String> attrProps) {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.setFields(this.getClass(), fields);
        if (fields.size() == 0) {
            return;
        }
        for (Field f : fields) {
            String value = attrProps.get(f.getName());
            if (StringUtils.isBlank((CharSequence)value)) continue;
            try {
                f.set(this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.warn("Set Widget property error: " + e.getMessage());
            }
        }
    }

    public void setFields(Class<?> clazz, List<Field> fields) {
        if (clazz == null) {
            return;
        }
        Field[] fieldArr = clazz.getDeclaredFields();
        if (fieldArr.length > 0) {
            fields.addAll(Arrays.asList(fieldArr));
        }
        this.setFields(clazz.getSuperclass(), fields);
    }

    public abstract String toString();

    public String getPattern() {
        return "";
    }
}

