/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.util.Arrays;
import java.util.HashMap;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4Displayitem;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4enable;
import jp.jasminesoft.jfc.gen.HelperGenerator_buttonControl4show;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.JspLayoutManager;
import jp.jasminesoft.jfc.gen.JspLayoutManagerFactory;
import jp.jasminesoft.jfc.gen.JspPanelContent_displaycondition;
import jp.jasminesoft.jfc.gen.JspSourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Css;
import jp.jasminesoft.jfc.gen.appschema.Csslist;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.Displayitem;
import jp.jasminesoft.jfc.gen.appschema.Displayitemgroup;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Layout;
import jp.jasminesoft.jfc.gen.appschema.Link;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.dojo.CommonProps;
import jp.jasminesoft.jfc.gen.ui.dojo.Input;
import jp.jasminesoft.jfc.gen.ui.dojo.Widget;
import jp.jasminesoft.jfc.gen.ui.dojo.WidgetProps;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator_show;
import jp.jasminesoft.jfc.gen.ui.th.ThSourceGenerator;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.VelocityUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ThGenerator
extends ThSourceGenerator {
    protected boolean isLogonForm = false;

    public ThGenerator(Project project, Action action, Presentation presentation) {
        this(project, action, presentation, null);
    }

    public ThGenerator(Project project, Action action, Presentation presentation, String fid) {
        super(project, action, presentation);
    }

    @Override
    public String getFilename() {
        return ThGenerator.convertJspFilename(this.fid);
    }

    @Override
    public String getFileSuffix() {
        return ".html";
    }

    public boolean outputCheckLogonTag() {
        return true;
    }

    @Override
    public Presentation getPresentation() {
        return this.presentation;
    }

    @Override
    public String process0() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.gHeader1());
        sb.append(this.gHeader2());
        sb.append(this.gHeader3());
        sb.append(this.gBody());
        return sb.toString();
    }

    protected String gHeader1() {
        return "";
    }

    protected String gHeader2() {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>").append(CR).append("<html xmlns:th=\"http://www.thymeleaf.org\"").append(CR).append(" th:replace=\"").append(this.getThTemplate()).append("\">").append(CR);
        return sb.toString();
    }

    protected String getThTemplate() {
        String fileName = "template";
        String navigationBar = "navigationbar=~{:: form[name='navigation'] }, ";
        if (StringUtils.startsWith((CharSequence)this.getPresentation().getIdref(), (CharSequence)"searchList")) {
            fileName = "standard";
            navigationBar = "";
        } else if (StringUtils.startsWith((CharSequence)this.getPresentation().getLayout().getType(), (CharSequence)"thymeleaf:")) {
            fileName = StringUtils.substringAfter((String)this.getPresentation().getLayout().getType(), (String)":");
            navigationBar = "";
        }
        return "~{ jfc/layout/base_" + fileName + " :: layout( title=~{:: title }, links=~{:: head/link }, scripts=~{:: head/script }, pagetitle=~{:: div.pagetitle/content() }, description=~{:: div.description }, " + navigationBar + "body=~{:: div[id='contents']/content() }, endbody=~{:: div[id='endbody']/content() } )}";
    }

    protected String gHeader3() {
        String cnt_javascript;
        String cnt_stylesheet;
        StringBuilder sb = new StringBuilder();
        sb.append("<head>").append(CR).append("<meta charset=\"utf-8\">").append(CR);
        Csslist csslist = this.getPresentation().getCsslist();
        if (csslist != null) {
            Css[] css_ary;
            for (Css css : css_ary = csslist.getCss()) {
                String cssfilename = css.getContent();
                String media = css.getMedia();
                sb.append(this.getStyleSheetTag(cssfilename));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(cnt_stylesheet = this.gStyleSheetRef()))) {
            sb.append(cnt_stylesheet);
        }
        if (StringUtils.isNotBlank((CharSequence)(cnt_javascript = this.gJavaScriptTag()))) {
            sb.append(cnt_javascript);
        }
        String escapedTitle = this.getEscapedTitle();
        String rkey = JFCAppResourceGenerator.createTitleResourceKey("title", escapedTitle, this);
        sb.append("<title th:text=\"#{").append(rkey).append("}\">").append(escapedTitle).append("</title>").append(CR).append("</head>").append(CR);
        return sb.toString();
    }

    protected String gBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("<body>").append(CR).append(this.gBody0()).append(this.gBody1()).append("</body>").append(CR).append("</html>");
        return sb.toString();
    }

    protected String gBody0() {
        String _body;
        Layout layout = this.getPresentation().getLayout();
        if (layout == null) {
            return "";
        }
        JspLayoutManager lman = JspLayoutManagerFactory.create(layout, this);
        if (lman == null) {
            return "";
        }
        lman.setPagetitle(this.getPresentation().getDescription());
        StringBuilder sb = new StringBuilder();
        String _head = lman.getPreparedContent();
        if (StringUtils.isNotBlank((CharSequence)_head)) {
            sb.append(_head).append(CR);
        }
        if (StringUtils.isNotBlank((CharSequence)(_body = lman.process()))) {
            sb.append(_body);
        }
        return sb.toString();
    }

    protected String gBody1() {
        return "";
    }

    @Override
    protected String gJavaScriptTag() {
        String code;
        StringBuilder sb = new StringBuilder();
        sb.append(this.gComment("gJavaScript"));
        String[] ref = this.gJavaScriptRef();
        if (ref != null) {
            Arrays.asList(ref).stream().forEach(e -> sb.append("<script type=\"text/javascript\" th:src=\"@{|").append((String)e).append("?${application.__jfc_buildTimestamp}|}").append("\" charset=\"").append(this.getEncoding()).append("\"").append("></script>").append(CR));
        }
        if (StringUtils.isNotBlank((CharSequence)(code = this.gJavaScript0()))) {
            sb.append("<script type=\"text/javascript\"").append(code).append(CR).append("</script>").append(CR);
        }
        return sb.toString();
    }

    @Override
    protected String getStyleSheetTag(String src) {
        StringBuilder sb = new StringBuilder();
        sb.append("<link type=\"text/css\" rel=\"stylesheet\"").append(" th:href=\"@{|").append(src).append("?${application.__jfc_buildTimestamp}|}\">").append(CR);
        return sb.toString();
    }

    public static String getMethodName4ButtonControlAddCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String addbuttonshowcondition = ditem.getAddbuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(addbuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "addbuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlRemoveCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String removebuttonshowcondition = ditem.getRemovebuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(removebuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "removebuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlMoveCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String movebuttonshowcondition = ditem.getMovebuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(movebuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "movebuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlInsertCondition(Displayitem ditem, Model pmodel, Presentation presentation) {
        String insertbuttonshowcondition = ditem.getInsertbuttonshowcondition();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(insertbuttonshowcondition)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "insertbuttonshowcondition");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlAddButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String addbuttonlabel = ditem.getAddbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(addbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "addbuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlRemoveButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String removebuttonlabel = ditem.getRemovebuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(removebuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "removebuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlInsertButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String insertbuttonlabel = ditem.getInsertbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(insertbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "insertbuttonlabel");
        }
        return methodname;
    }

    public static String getMethodName4ButtonControlClearButtonLabel(Displayitem ditem, Model pmodel, Presentation presentation) {
        String clearbuttonlabel = ditem.getClearbuttonlabel();
        String methodname = null;
        if (JavaSourceGenerator.isUseExpression(clearbuttonlabel)) {
            methodname = HelperGenerator_buttonControl4Displayitem.createMethodBodyName(ditem, presentation.getIdref(), "clearbuttonlabel");
        }
        return methodname;
    }

    public static String parsePlaceHolder4ShowButtonControl(Link link, Model pmodel, Presentation presentation) {
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        Model tmodel = (Model)pmodel.getIdrefAsIRNode();
        String showcondition = link.getShowcondition();
        String methodName = null;
        if (StringUtils.isNotBlank((CharSequence)showcondition)) {
            if (ThGenerator.isUseEL_Expression(showcondition)) {
                return showcondition;
            }
        } else {
            return null;
        }
        methodName = "buttonControl_show";
        StringBuilder sb = new StringBuilder();
        sb.append("${#jfc.").append(methodName).append("(#request,");
        sb.append("'");
        sb.append(smodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(pmodel.getId());
        sb.append("'");
        sb.append(",");
        if (link.getOriginalPerRow() && tmodel.getType().equals("list")) {
            sb.append("iterStat.index,");
        }
        sb.append("'");
        sb.append(HelperGenerator_buttonControl4show.createLinkIdWithControlPattern(link, presentation));
        sb.append("'");
        sb.append(")");
        sb.append("}");
        return sb.toString();
    }

    public static String parsePlaceHolder4EnableButtonControl(Link link, Model pmodel, Presentation presentation) {
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        Model tmodel = (Model)pmodel.getIdrefAsIRNode();
        String enablecondition = link.getEnablecondition();
        String methodName = null;
        if (StringUtils.isNotBlank((CharSequence)enablecondition)) {
            if (ThGenerator.isUseEL_Expression(enablecondition)) {
                return enablecondition;
            }
        } else {
            return null;
        }
        methodName = "buttonControl_enable";
        StringBuilder sb = new StringBuilder();
        sb.append("${#jfc.").append(methodName).append("(#request,");
        sb.append("'");
        sb.append(smodel.getId());
        sb.append("'");
        sb.append(",");
        sb.append("'");
        sb.append(pmodel.getId());
        sb.append("'");
        sb.append(",");
        if (link.getOriginalPerRow() && tmodel.getType().equals("list")) {
            sb.append("iterStat.index,");
        }
        sb.append("'");
        sb.append(HelperGenerator_buttonControl4enable.createLinkIdWithControlPattern(link, presentation));
        sb.append("'");
        sb.append(")");
        sb.append("}");
        return sb.toString();
    }

    public static boolean isUseEL_Expression(String s) {
        if ((s = s.trim()).startsWith("${") && s.endsWith("}")) {
            return true;
        }
        return s.startsWith("TEXTSEARCH_");
    }

    protected void gWizardHiddenPageAttribute(String basetab, StringBuilder sb) {
        sb.append(basetab).append("  ").append("<th:block th:if=\"${").append("__jfc_keyname").append(" ne null}\"").append(" th:with=\"key=${").append("__jfc_keyname").append("}").append(", page=${#request.getAttribute(key)}\">").append(CR).append(basetab).append("    ").append("<input th:if=\"${page ne null}\" type=\"hidden\" th:name=\"${key}\" th:value=\"${page}\">").append(CR).append(basetab).append("  ").append("</th:block>").append(CR);
    }

    public static boolean isValidShowcondition(String condition) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return false;
        }
        return !"true".equalsIgnoreCase(condition) && !"\u25cb".equals(condition);
    }

    public static boolean needsCheckCondiiton(String condition) {
        return StringUtils.isNotBlank((CharSequence)condition) && !"false".equals(condition.toLowerCase());
    }

    public static boolean isIncludeELExpr(String str) {
        return JavaSourceGenerator.isUseExpression(str);
    }

    protected static String convertJavaVariableString(String s) {
        return StringUtil.convertHtmlIdString((String)s);
    }

    public String createResourceKey(String content) {
        return this.createResourceKey("_group.1", content);
    }

    public String createResourceKey(String name, String content) {
        String id = null;
        Model pmodel = AppSchemaUtil.getModel(this.project, this.action);
        Model smodel = AppSchemaUtil.getStoreModel(pmodel);
        if (smodel != null) {
            id = smodel.getId();
        }
        return JFCAppResourceGenerator.createModelResourceKey(id, name, content);
    }

    protected String gThLabel(String name, String label) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return "";
        }
        if (!JFCAppResourceGenerator.isFullBuild) {
            return "";
        }
        String rkey = this.createResourceKey(name, label);
        JFCAppResourceGenerator.put(rkey, label);
        return this.gThUText(this.wrapMessageEl(rkey));
    }

    protected String gThLabel(String name, String label, JspSourceGenerator jspgen) {
        if (StringUtils.isBlank((CharSequence)label)) {
            return "";
        }
        String rkey = JFCAppResourceGenerator.createMessageResourceKey(name, label, jspgen);
        JFCAppResourceGenerator.put(rkey, label);
        return this.gThText(this.wrapMessageEl(rkey));
    }

    protected String gValueEl(String id, String name, Modelitem mitem, boolean isMultipleFlag, Modelitem pitem, Displayitem ditem) {
        String __name;
        StringBuilder value = new StringBuilder();
        if (isMultipleFlag) {
            __name = "c";
        } else {
            boolean hasChild = mitem != null ? AppSchemaUtil.hasChildPart(mitem.getName()) : false;
            String cname = mitem != null ? AppSchemaUtil.getChildPart(mitem.getName()) : null;
            __name = hasChild ? cname : name;
            value.append(SourceGenerator.convertELId(id)).append(".");
        }
        value.append(SourceGenerator.convertELProperty(__name));
        String type = AppSchemaUtil.getModelitemType(this.project, name, mitem);
        if ((ditem == null || !ditem.getReadonly()) && ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || "dateTime".equalsIgnoreCase(type))) {
            value.append(".rawvalue");
        } else if (ditem.getReadonly() && ("byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type))) {
            value.append(".formatted");
        } else {
            String itemId = value.toString();
            value.append(".content");
            if (pitem != null && pitem.getStandalone()) {
                value.insert(0, itemId + " ne null ? ").append(" : ''");
            }
        }
        return this.wrapValueEl(value.toString());
    }

    protected String gValueEl(Model pmodel, Displayitem ditem, Modelitem mitem, Modelitem pitem) {
        boolean hasChild = mitem != null ? AppSchemaUtil.hasChildPart(mitem.getName()) : false;
        String pname = mitem != null ? AppSchemaUtil.getParentPart(mitem.getName()) : null;
        StringBuilder value = new StringBuilder();
        if (hasChild && !StringUtils.endsWith((CharSequence)pmodel.getId(), (CharSequence)"_cp")) {
            value.append(pname);
        } else {
            value.append(ThGenerator.convertJavaVariableString(pmodel.getId()));
        }
        value.append(".");
        value.append(ThGenerator.convertELProperty(AppSchemaUtil.getChildPart(pitem.getName())));
        value.append(".content");
        return this.wrapValueEl(value.toString());
    }

    protected String gThText(String el) {
        return this.gThString("text", el);
    }

    protected String gThUText(String el) {
        return this.gThString("utext", el);
    }

    protected String gThValue(String el) {
        return this.gThString("value", el);
    }

    protected String gThString(String type, String el) {
        StringBuilder sb = new StringBuilder();
        sb.append(" th:").append(type).append("=\"").append(el).append("\"");
        return sb.toString();
    }

    protected String wrapMessageEl(String el) {
        if (StringUtils.startsWith((CharSequence)el, (CharSequence)"#{") || StringUtils.startsWith((CharSequence)el, (CharSequence)"${")) {
            return el;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("#{").append(el).append("}");
        return sb.toString();
    }

    protected String wrapValueEl(String el) {
        if (StringUtils.startsWith((CharSequence)el, (CharSequence)"${")) {
            return el;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("${").append(el).append("}");
        return sb.toString();
    }

    protected static String getThLiteralReplacement(String content) {
        StringBuilder sb = new StringBuilder();
        sb.append("|").append(content).append("|");
        return sb.toString();
    }

    protected String getFormName(String idref) {
        return this.getActionType() + idref;
    }

    protected String getTooltip(String id, Displayitem ditem, String type) {
        String tooltip = ditem.getTooltip();
        if (StringUtils.isBlank((CharSequence)tooltip)) {
            return "";
        }
        return this.wrapMessageEl(this.getResourceKey(id, ditem.getName(), type, tooltip));
    }

    protected String gThTitle(String id, Displayitem ditem, String type) {
        String tooltip = this.getTooltip(id, ditem, type);
        if (StringUtils.isBlank((CharSequence)tooltip)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" th:title=\"").append(tooltip).append("\"");
        return sb.toString();
    }

    protected String getPlaceholder(String id, Displayitem ditem, String type) {
        String placeholder = ditem.getPlaceholder();
        if (StringUtils.isBlank((CharSequence)placeholder)) {
            return "";
        }
        return this.wrapMessageEl(this.getResourceKey(id, ditem.getName(), type, placeholder));
    }

    protected String gThPlaceholder(String id, Displayitem ditem, String type) {
        String placeholder = this.getPlaceholder(id, ditem, type);
        if (StringUtils.isBlank((CharSequence)placeholder)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" th:placeholder=\"").append(placeholder).append("\"");
        return sb.toString();
    }

    protected String getResourceKey(String id, String name, String type, String message) {
        StringBuilder key = new StringBuilder();
        key.append(name).append(".tooltip");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            key.append(".").append(type);
        }
        String rkey = JFCAppResourceGenerator.createValueResourceKey(id, key.toString(), message);
        JFCAppResourceGenerator.put(rkey, message);
        return rkey;
    }

    public String getInputStyle(Model pmodel, Displayitem ditem, String actionType) {
        return this.getStyle(pmodel, ditem, actionType, "centerfield");
    }

    public String getFieldContainerStyle(Model pmodel, Displayitem ditem, String actionType) {
        String style = this.getStyle(pmodel, ditem, actionType, "around");
        if (StringUtils.isBlank((CharSequence)style) || !StringUtils.startsWith((CharSequence)style, (CharSequence)"${#jfc.")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" th:style=\"").append(ThGenerator.getThLiteralReplacement(style)).append("\"");
        return sb.toString();
    }

    private String getStyle(Model pmodel, Displayitem ditem, String actionType, String stylePlace) {
        if (ditem == null || StringUtils.isBlank((CharSequence)stylePlace) || !"show".equals(actionType) && !stylePlace.equals(ditem.getStylePlace()) && !"all".equals(ditem.getStylePlace()) || StringUtils.isBlank((CharSequence)ditem.getStyle())) {
            return "";
        }
        return ThBodyGenerator_show.createStyle(pmodel, ditem, actionType);
    }

    public String getHiddenInput(String id, String name, String valueEl) {
        Object widgetProps = ((CommonProps)((CommonProps)((CommonProps)new CommonProps().setId(id)).setName(name)).setType("hidden")).setValueEl(valueEl);
        Input widget = new Input((WidgetProps<CommonProps>)widgetProps);
        return ((Widget)widget).toString();
    }

    public String getPreString(Displayitem ditem, String labelid, ThSourceGenerator thgen) {
        return this.getPrePostString(ditem, labelid, thgen, "prestring");
    }

    public String getPostString(Displayitem ditem, String labelid, ThSourceGenerator thgen) {
        return this.getPrePostString(ditem, labelid, thgen, "poststring");
    }

    private String getPrePostString(Displayitem ditem, String labelid, ThSourceGenerator thgen, String type) {
        String string = null;
        if ("prestring".equals(type)) {
            string = ditem.getPrestring();
        } else if ("poststring".equals(type)) {
            string = ditem.getPoststring();
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        name.append(ditem.getName()).append(".").append(type);
        StringBuilder sb = new StringBuilder();
        String rkey = JFCAppResourceGenerator.createModelResourceKey(thgen.getActionIdref(), name.toString(), string);
        JFCAppResourceGenerator.put(rkey, string);
        sb.append("<span");
        if (StringUtils.isNotBlank((CharSequence)labelid)) {
            sb.append(" th:id=\"|").append(StringUtils.replace((String)labelid, (String)"${#strings.escapeXml(c.id)}", (String)"1")).append("_").append(type).append("|\"");
        }
        sb.append(" class=\"").append(type).append("\"");
        sb.append(this.gThUText(this.wrapMessageEl(rkey))).append("></span>");
        return sb.toString();
    }

    public static boolean isConditionDitemgLayoutLeft(Displayitem ditem) {
        if (!StringUtils.endsWith((CharSequence)ditem.getName(), (CharSequence)"1jshparam") && !StringUtils.endsWith((CharSequence)ditem.getName(), (CharSequence)"2jshparam")) {
            return false;
        }
        IRNode node = ditem.rGetParentRNode();
        if (node == null || !(node instanceof Displayitemgroup)) {
            return false;
        }
        Displayitemgroup ditemg = (Displayitemgroup)node;
        String separate = ditemg.getSeparate();
        return "100%".equals(separate);
    }

    protected String getPaddingCode(Displayitem ditem, String type) {
        if ("hidden".equals(type) || ditem == null || ditem.getPadding() == null) {
            return "";
        }
        String[] padData = ditem.getPadding().split(",");
        if (padData == null || padData.length != 2 || padData[0].length() == 0 || !padData[1].matches("[0-9]+")) {
            this.logger.error(this.rman.getValue("value.illegal.displayitem.padding", new Object[]{ditem.getPadding()}));
            return "";
        }
        StringBuilder code = new StringBuilder();
        code.append("padding(this, '").append(padData[0]).append("', ").append(padData[1]).append(");");
        return code.toString();
    }

    protected String getDisableDownloadButtonScript() {
        Displaycondition displaycondition = AppSchemaUtil.findDisplaycondition(this.presentation);
        if (displaycondition == null) {
            return "";
        }
        if (!this.downloadButtonExists(displaycondition) && !this.printShowListButtonExists()) {
            return "";
        }
        String cpmodelname = JspPanelContent_displaycondition.createFormName(displaycondition.getIdref());
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("cpmodel", cpmodelname);
        return VelocityUtils.mergeContent((String)"template/javascriptsrc/disableDownloadButton.vm", m);
    }

    protected boolean downloadButtonExists(Displaycondition displaycondition) {
        IRNode downloadactionidref_irnode = displaycondition.getDownloadactionidrefAsIRNode();
        if (downloadactionidref_irnode == null || !(downloadactionidref_irnode instanceof Action)) {
            return false;
        }
        String showcondition = displaycondition.getDownloadshowcondition();
        String enablecondition = displaycondition.getDownloadenablecondition();
        return !StringUtils.isBlank((CharSequence)showcondition) || !StringUtils.isBlank((CharSequence)enablecondition);
    }

    protected boolean printShowListButtonExists() {
        if (!StringUtils.startsWith((CharSequence)this.getPresentation().getIdref(), (CharSequence)"showList")) {
            return false;
        }
        return Arrays.stream(AppSchemaUtil.findLink(this.getPresentation(), "navigationbar")).anyMatch(l -> l.getAction().startsWith("Print"));
    }

    protected Modelitem getPresentationModelitemForInputCheckProps(String smodelId, Modelitem pitem, String ditemName) {
        if (!this.presentation.getIdref().startsWith("showList") && !this.presentation.getIdref().startsWith("searchList")) {
            return pitem;
        }
        Model presentationModel = AppSchemaUtil.getModel(this.project, smodelId, "presentation");
        String presentationModelitemName = ditemName.replaceAll("[12]jshparam", "");
        Modelitem presentationModelitem = AppSchemaUtil.getModelitem(presentationModelitemName, presentationModel);
        return presentationModelitem == null ? pitem : presentationModelitem;
    }

    protected static enum ParsePlaceHolderMode {
        Show,
        ShowList;

    }
}

