/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.JavaSourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Displaycondition;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Presentation;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.appschema.View;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator;
import jp.jasminesoft.jfc.gen.ui.th.ThPanelContentBase;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThPanelContent_displaycondition
extends ThPanelContentBase {
    protected Logger logger = LogManager.getLogger((String)ThPanelContent_displaycondition.class.getName());
    private Displaycondition displaycondition;
    private String idref;
    private String conditionTabContainerId = "calendarConditionTabContainer";

    public ThPanelContent_displaycondition(IPanelChoice ipc, ThGenerator thgen, StringBuilder pcontent) {
        super(thgen, pcontent);
        this.displaycondition = (Displaycondition)ipc;
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.thgen.gComment("ThPanelContent_displaycondition::process"));
        if (this.idref == null) {
            this.idref = this.displaycondition.getIdref();
        }
        this.setUseBeanTagIntoPcontent(this.idref);
        String jscode = "";
        boolean isCalendarView = false;
        boolean isModernCalendarView = false;
        String type = this.displaycondition.getType();
        if ("calendar".equals(type)) {
            isCalendarView = true;
        } else if ("modernCalendar".equals(type)) {
            isModernCalendarView = true;
        }
        Project project = this.thgen.getProject();
        Action action = this.thgen.getAction();
        if (action != null && !isCalendarView && !isModernCalendarView) {
            Object formName = ThPanelContent_displaycondition.createFormName(this.displaycondition.getIdref());
            if (this.displaycondition.getTextsearch()) {
                formName = (String)formName + "Index";
            }
            if (this.displaycondition.getFoldable()) {
                StringBuilder titlePane = new StringBuilder();
                titlePane.append("<div id=\"").append(this.titlePaneId()).append("\"").append(" data-dojo-type=\"wagby/TitlePane\" th:data-dojo-props=\"|");
                String title = this.displaycondition.getLabel();
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    Model smodel = AppSchemaUtil.getModel(project, action.getIdref());
                    String rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), action.getId() + ".titlePane.label", title);
                    JFCAppResourceGenerator.put(rkey, title);
                    titlePane.append("title: '").append(this.wrapMessageEl(rkey)).append("', ");
                }
                titlePane.append("open: ").append(!this.displaycondition.getFolded()).append(", persist: true|\">").append(CR);
                sb.append(titlePane.toString());
            }
            sb.append(this.thgen.gRequestFormBegin((String)formName, this.displaycondition.getAction(), jscode, basetab));
            if (this.displaycondition.getTextsearch()) {
                sb.append(basetab).append("  ").append("<input type=\"hidden\" name=\"TEXTSEARCH_QMODE\" value=\"index\"/>").append(CR).append(basetab).append("  ").append("<input type=\"hidden\" name=\"TEXTSEARCH_CURRENT\" value=\"0\"/>").append(CR);
            } else {
                Model smodel;
                IRNode node = action.getIdrefAsIRNode();
                if (node != null && node instanceof Model && (smodel = (Model)node).getTextsearch()) {
                    sb.append(basetab).append("  ");
                    sb.append("<input type=\"hidden\" name=\"TEXTSEARCH_QMODE\" value=\"db\"/>").append(CR);
                }
            }
            sb.append(this.gBodyContent(this.displaycondition));
            sb.append(this.thgen.gRequestFormEnd(basetab));
            if (this.displaycondition.getFoldable()) {
                sb.append("</div>").append(CR);
            }
            return sb.toString();
        }
        Map<String, Action> targetActionMap = this.getTargetActionMap(project, action);
        boolean isConditionTabExist = false;
        sb.append("<div data-dojo-type=\"dijit/layout/TabContainer\" id=\"").append(this.conditionTabContainerId).append("\" ");
        sb.append("data-dojo-props=\"doLayout: false, persist: true\" style=\"width: 100%;");
        if (isModernCalendarView) {
            sb.append(" height: 100%; overflow: auto;");
        }
        sb.append("\">").append(CR);
        if (targetActionMap.size() > 1) {
            Action[] actions = targetActionMap.values().toArray(new Action[0]);
            if (actions.length > 0) {
                isConditionTabExist = true;
            }
            for (int k = 0; k < actions.length; ++k) {
                Action _action = actions[k];
                Model smodel = AppSchemaUtil.getModel(project, _action.getIdref());
                String desc = smodel.getDescription();
                String rkey = JFCAppResourceGenerator.getKeyFromValue(desc);
                if (rkey == null) {
                    rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), "name", desc);
                    JFCAppResourceGenerator.put(rkey, desc);
                }
                sb.append("  ");
                Presentation syncPresentation = this.getPresentation(project, _action);
                Displaycondition syncDisplaycondition = AppSchemaUtil.findDisplaycondition(syncPresentation);
                String syncDisplayconditionIdref = syncDisplaycondition.getIdref();
                String formname = ThPanelContent_displaycondition.createFormName(syncDisplayconditionIdref);
                String tabId = syncDisplayconditionIdref + "Tab";
                sb.append("<div data-dojo-type=\"dijit/layout/ContentPane\" id=\"").append(tabId).append("\"").append(" class=\"calendarConditionTab\" th:title=\"#{").append(rkey).append("}\"").append(" style=\"padding 0.5em;").append("overflow: auto;\" onFocus=\"setSelectedTabId('").append(this.conditionTabContainerId).append("', '").append(tabId).append("');\">").append(CR).append(this.thgen.gRequestFormBegin(formname, syncPresentation.getIdref(), jscode, basetab)).append(this.gButtonShowlist(_action.getIdref())).append(this.gBodyContent(syncDisplaycondition)).append(this.thgen.gRequestFormEnd(basetab)).append("  ").append("</div>").append(CR);
            }
        } else {
            Model smodel = AppSchemaUtil.getModel(project, action.getIdref());
            String desc = smodel.getDescription();
            String rkey = JFCAppResourceGenerator.getKeyFromValue(desc);
            if (rkey == null) {
                rkey = JFCAppResourceGenerator.createModelResourceKey(smodel.getId(), "name", desc);
                JFCAppResourceGenerator.put(rkey, desc);
            }
            sb.append("<div data-dojo-type=\"dijit/layout/ContentPane\" class=\"calendarConditionTab\"").append(" th:title=\"#{").append(rkey).append("}\"").append(" style=\"padding: 0.5em; overflow: auto;\">").append(CR).append(this.thgen.gRequestFormBegin(ThPanelContent_displaycondition.createFormName(this.displaycondition.getIdref()), this.displaycondition.getAction(), jscode, basetab)).append(this.gButtonShowlist(action.getIdref())).append(this.gBodyContent(this.displaycondition)).append(this.thgen.gRequestFormEnd(basetab)).append("</div>").append(CR);
        }
        if (AppSchemaUtil.isMobile(action, project)) {
            sb.append("</div>").append(CR);
        }
        sb.append("</div>").append(CR).append(CR);
        if (!isModernCalendarView) {
            sb.append("<script>").append(CR);
            sb.append("require([\"dijit/registry\", \"dojo/dom-style\", \"dojo/on\", \"dojo/query\", \"dojo/ready\"], function(registry, domStyle, on, query, ready) {").append(CR);
            sb.append("  ready(function() {").append(CR);
            sb.append("    var forms = [];").append(CR);
            sb.append("    var tabContainer = registry.byId(\"").append(this.conditionTabContainerId).append("\");").append(CR);
            sb.append("    query(\"form\", tabContainer.domNode).forEach(function(form) {").append(CR);
            sb.append("      domStyle.set(form, \"height\", \"auto\");").append(CR);
            sb.append("      forms.push(form);").append(CR);
            sb.append("    });").append(CR);
            sb.append("    on(window, \"resize\", function() {").append(CR);
            sb.append("      for (var i=0,l=forms.length; i<l; i++) {").append(CR);
            sb.append("        domStyle.set(forms[i], \"height\", \"auto\");").append(CR);
            sb.append("      }").append(CR);
            sb.append("    });").append(CR);
            sb.append("  });").append(CR);
            sb.append("});").append(CR);
            sb.append("</script>").append(CR);
        }
        if (isConditionTabExist) {
            sb.append("<script type=\"text/javascript\">");
            sb.append(CR);
            sb.append("  selectTabOnLoad('").append(this.conditionTabContainerId).append("', '").append(this.conditionTabContainerId).append("', '");
            sb.append(this.idref);
            sb.append("Tab");
            sb.append("');");
            sb.append(CR);
            sb.append("</script>");
            sb.append(CR);
        }
        return sb.toString();
    }

    private Presentation getPresentation(Project project, Action action) {
        Presentation[] presentations;
        for (Presentation presentation : presentations = AppSchemaUtil.getPresentation(project, action)) {
            if (!presentation.getIdref().equals(action.getId())) continue;
            return presentation;
        }
        return null;
    }

    private Map<String, Action> getTargetActionMap(Project project, Action action) {
        TreeMap<String, Action> targetActionMap = new TreeMap<String, Action>();
        targetActionMap.put(action.getIdref(), action);
        View view = AppSchemaUtil.getView(action);
        if (view == null) {
            return targetActionMap;
        }
        String sync = view.getSync();
        if (StringUtils.isBlank((CharSequence)sync)) {
            return targetActionMap;
        }
        String[] syncModels = sync.split(",");
        if (syncModels == null || syncModels.length == 0) {
            return targetActionMap;
        }
        Stream.of(syncModels).filter(m -> StringUtils.isNotBlank((CharSequence)m)).map(m -> AppSchemaUtil.getActionByModelIdAndTypeAndView(project, m.trim(), "showList", "calendar")).filter(a -> a != null).forEach(a -> targetActionMap.put(a.getIdref(), (Action)a));
        return targetActionMap;
    }

    private String gButtonShowlist(String idref) {
        String capitalizedModelId = JavaSourceGenerator.capFirst(idref);
        String forward = "showList" + capitalizedModelId;
        Action showListAction = AppSchemaUtil.getAction(this.thgen.getProject(), forward);
        if (showListAction == null) {
            return "";
        }
        String rkey = this.getCalendarviewNavigationSearchButtonRkey(forward);
        StringBuilder sb = new StringBuilder();
        sb.append("<th:block th:if=\"${#jfc.ifLogon(#request, 'permclassname=jp.jasminesoft.jfc.JFCAppPermission,").append(" permname=").append(idref).append(", permactions=select')}\">").append(CR).append("  <div class=\"action_button\" style=\"margin-bottom: 3px;\">").append(CR).append("    <button id=\"btnSendShowList").append(capitalizedModelId).append("\"").append(" data-dojo-type=\"wagby/Button\" type=\"button\" name=\"btnSend\"").append(" th:attr=\"onClick=|var form = this.valueNode.form;").append(" form.action = '").append(forward).append(".do';").append(" doSubmitForm(form, 'action_Send');|\"").append(" faIconClass=\"fas fa-share\"").append(" th:text=\"#{").append(rkey).append("}\"></button>").append(CR).append("  </div>").append(CR).append("</th:block>").append(CR);
        return sb.toString();
    }

    private String getCalendarviewNavigationSearchButtonRkey(String forward) {
        String label = "\u691c\u7d22\u753b\u9762\u3078";
        String rkey = JFCAppResourceGenerator.createLinkResourceKey("button", "navigation.search", forward + "Calendarview", null, label, this.thgen);
        JFCAppResourceGenerator.put(rkey, label);
        return rkey;
    }

    public static String createFormName(String idref) {
        return "condition" + JavaSourceGenerator.capFirst(idref);
    }

    protected String titlePaneId() {
        return "jfc" + StringUtils.capitalize((String)this.displaycondition.getAction()) + "TitlePane";
    }
}

