/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.gen.ui.th;

import java.util.ArrayList;
import jp.jasminesoft.jfc.gen.AppSchemaUtil;
import jp.jasminesoft.jfc.gen.JFCAppResourceGenerator;
import jp.jasminesoft.jfc.gen.SourceGenerator;
import jp.jasminesoft.jfc.gen.appschema.Action;
import jp.jasminesoft.jfc.gen.appschema.Condition;
import jp.jasminesoft.jfc.gen.appschema.Conditionlist;
import jp.jasminesoft.jfc.gen.appschema.Displaytext;
import jp.jasminesoft.jfc.gen.appschema.ForeignKey;
import jp.jasminesoft.jfc.gen.appschema.IModelChoice;
import jp.jasminesoft.jfc.gen.appschema.IModelitemChoice;
import jp.jasminesoft.jfc.gen.appschema.IPanelChoice;
import jp.jasminesoft.jfc.gen.appschema.IRNode;
import jp.jasminesoft.jfc.gen.appschema.Model;
import jp.jasminesoft.jfc.gen.appschema.Modelitem;
import jp.jasminesoft.jfc.gen.appschema.Notnull;
import jp.jasminesoft.jfc.gen.appschema.Permission;
import jp.jasminesoft.jfc.gen.appschema.PrimaryKey;
import jp.jasminesoft.jfc.gen.appschema.Project;
import jp.jasminesoft.jfc.gen.ui.th.ThBodyGenerator_show;
import jp.jasminesoft.jfc.gen.ui.th.ThGenerator;
import jp.jasminesoft.jfc.gen.ui.th.ThPanelContentBase;
import org.apache.commons.lang3.StringUtils;

public class ThPanelContent_displaytext
extends ThPanelContentBase {
    private Displaytext displaytext;
    private Project project;
    private String idref;

    public ThPanelContent_displaytext(IPanelChoice ipc, String idref, ThGenerator thgen) {
        super(thgen);
        this.displaytext = (Displaytext)ipc;
        this.idref = idref;
        this.project = thgen.getProject();
    }

    @Override
    public String process(String basetab) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.thgen.gComment("ThPanelContent_displaytext::process"));
        String foreignkey_forward_url = this.createForeignKeyForwardUrl();
        if (StringUtils.isNotBlank((CharSequence)foreignkey_forward_url) && !this.thgen.isMobile()) {
            sb.append("<div>").append(CR);
            sb.append("<a th:href=\"|").append(foreignkey_forward_url).append("|\">");
        }
        Permission permission = this.getProperPermissionByForeignKeyForwardUrl();
        if (this.idref != null) {
            Model pmodel = AppSchemaUtil.getModel(this.project, this.idref);
            sb.append(ThPanelContent_displaytext.process0(basetab, this.displaytext, pmodel, permission, this.thgen));
        } else {
            sb.append(ThPanelContent_displaytext.process0(basetab, this.displaytext, null, permission, this.thgen));
        }
        if (StringUtils.isNotBlank((CharSequence)foreignkey_forward_url) && !this.thgen.isMobile()) {
            sb.append("</a>");
            sb.append(CR);
            sb.append("</div>");
            sb.append(CR);
        }
        return sb.toString();
    }

    public static String process0(String basetab, Displaytext displaytext, Model pmodel, ThGenerator thgen) {
        return ThPanelContent_displaytext.process0(basetab, displaytext, pmodel, null, thgen);
    }

    public static String process0(String basetab, Displaytext displaytext, Model pmodel, Permission permission, ThGenerator thgen) {
        String id;
        StringBuilder sb = new StringBuilder();
        String content = displaytext.getContent();
        if (content == null || content.length() == 0) {
            return sb.toString();
        }
        if (displaytext.getRawContent()) {
            sb.append(content);
            return sb.toString();
        }
        String align = displaytext.getAlign();
        String valign = displaytext.getValign();
        String width = displaytext.getWidth();
        String valueClass = displaytext.getValueClass();
        String style = pmodel != null ? ThBodyGenerator_show.createStyle(pmodel, displaytext, null) : displaytext.getStyle();
        Object rkeybase = "__jfc_displaytext";
        String fid = displaytext.getForeignKeyForwardActionid();
        if (StringUtils.isBlank((CharSequence)fid)) {
            String string = id = thgen != null && thgen.getPresentation() != null ? thgen.getPresentation().getIdref() : null;
            if (StringUtils.isNotBlank((CharSequence)id)) {
                rkeybase = (String)rkeybase + "." + id;
            }
        } else {
            String tmp;
            id = displaytext.getId();
            int ptr = id.lastIndexOf("_");
            if (ptr > 0 && StringUtils.isNumeric((CharSequence)(tmp = id.substring(ptr + 1)))) {
                id = id.substring(0, ptr);
            }
            rkeybase = (String)rkeybase + "." + id;
        }
        String rkey = JFCAppResourceGenerator.checkUniqueRKey((String)rkeybase + "._group.1", content);
        JFCAppResourceGenerator.put(rkey, content);
        String mtab = "";
        if (permission != null) {
            sb.append(basetab).append("<th:block th:if=\"${#jfc.ifLogon(#request, '").append("permclassname").append("=jp.jasminesoft.jfc.JFCAppPermission").append(", ").append("permname").append("=").append(permission.getName()).append(", ").append("permactions").append("=").append(permission.getAction()).append("')}\">").append(CR);
            mtab = "  ";
        }
        sb.append(basetab).append(mtab);
        sb.append("<div");
        if (!"left".equals(align)) {
            sb.append(" align=\"" + align + "\"");
        }
        if (!"top".equals(valign)) {
            sb.append(" valign=\"" + valign + "\"");
        }
        if (width != null && width.length() > 0) {
            sb.append(" width=\"" + width + "\"");
        }
        if (valueClass != null && valueClass.length() > 0) {
            sb.append(" class=\"" + valueClass + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)style)) {
            sb.append(" style=\"" + style + "\"");
        }
        sb.append(">").append(CR);
        if (displaytext.getToggle()) {
            String offMark = "[-]";
            String onMark = "[+]";
            Project project = thgen.getProject();
            Action f_action = AppSchemaUtil.getAction(project, displaytext.getForeignKeyForwardActionid());
            if (f_action != null && pmodel != null) {
                Model target = (Model)f_action.getIdrefAsIRNode();
                Model target_l = AppSchemaUtil.getModel(project, target.getId(), "list");
                Model target_lp = AppSchemaUtil.getModel(project, target_l.getId(), "presentation");
                Model me = (Model)pmodel.getIdrefAsIRNode();
                Action me_show_action = AppSchemaUtil.getActionByModelIdAndType(project, me.getId(), "show");
                String link = me_show_action.getId() + ".do";
                String changePreferenceParameter = "_sm_" + target.getId();
                String target_lp_id = target_lp.getId();
                sb.append("<a href=\"").append(link).append("?action_ChangePreference=").append(changePreferenceParameter).append("\"").append(" th:text=\"${!#strings.isEmpty(").append(target_lp_id).append(") ?").append(" '").append(offMark).append("' : '").append(onMark).append("'}\"></a>").append(CR).append("[[#{").append(rkey).append("}]]").append(CR);
            }
        } else {
            sb.append(basetab).append(mtab).append("[[#{").append(rkey).append("}]]").append(CR);
        }
        sb.append(basetab).append(mtab).append("</div>").append(CR);
        if (permission != null) {
            sb.append(basetab).append("</th:block>").append(CR);
        }
        return sb.toString();
    }

    private Permission getProperPermissionByForeignKeyForwardUrl() {
        Permission permission = null;
        if (this.displaytext == null || StringUtils.isBlank((CharSequence)this.displaytext.getForeignKeyForwardActionid())) {
            return null;
        }
        Action f_action = AppSchemaUtil.getAction(this.project, this.displaytext.getForeignKeyForwardActionid());
        if (f_action == null) {
            return null;
        }
        permission = AppSchemaUtil.getPermission(f_action);
        return permission;
    }

    public String createForeignKeyForwardUrl() {
        if (this.displaytext == null || StringUtils.isBlank((CharSequence)this.displaytext.getForeignKeyForwardActionid())) {
            return null;
        }
        Action f_action = AppSchemaUtil.getAction(this.project, this.displaytext.getForeignKeyForwardActionid());
        if (f_action == null) {
            return null;
        }
        Conditionlist f_clist = AppSchemaUtil.getConditionlist(f_action);
        if (f_clist == null) {
            return null;
        }
        Action showAction = this.thgen.getAction();
        if (showAction == null) {
            return null;
        }
        IRNode node = showAction.getIdrefAsIRNode();
        if (node == null || !(node instanceof Model)) {
            return null;
        }
        Model smodel = (Model)node;
        PrimaryKey[] pkeys = AppSchemaUtil.getPrimaryKeyConsideringCompositeKey(smodel, this.project);
        ArrayList<String> pkeyparam_list = new ArrayList<String>();
        Model[] models = AppSchemaUtil.getDataitemAsModel(showAction);
        if (models == null || models.length == 0) {
            return null;
        }
        Model p_model = models[0];
        ForeignKey[] fkeys = null;
        IRNode f_node = f_action.getIdrefAsIRNode();
        if (f_node == null || !(f_node instanceof Model)) {
            return null;
        }
        fkeys = AppSchemaUtil.getForeignKey((Model)f_node);
        Model f_cp_model = AppSchemaUtil.getConditionPModel(this.project, f_action);
        ArrayList<String> notnullList = new ArrayList<String>();
        if (f_cp_model == null) {
            return null;
        }
        for (IModelChoice iModelChoice : f_cp_model.getContent()) {
            if (!(iModelChoice instanceof Modelitem)) continue;
            Modelitem cmitem = (Modelitem)iModelChoice;
            for (IModelitemChoice iModelitemChoice : cmitem.getContent()) {
                if (!(iModelitemChoice instanceof Notnull)) continue;
                notnullList.add(cmitem.getName());
            }
        }
        for (IModelChoice iModelChoice : pkeys) {
            String fkey_name = null;
            if (fkeys != null && fkeys.length > 0) {
                for (IRNode iRNode : fkeys) {
                    if (iRNode == null) continue;
                    String ref_name = AppSchemaUtil.getForeignKeyTargetItemName(null, (ForeignKey)iRNode);
                    if (!((PrimaryKey)iModelChoice).getName().equals(ref_name)) continue;
                    fkey_name = ((ForeignKey)iRNode).getName();
                    break;
                }
            }
            if (StringUtils.isBlank(fkey_name)) {
                return null;
            }
            Condition condition = AppSchemaUtil.getCondition(f_clist, fkey_name);
            if (condition == null || !"EQ".equalsIgnoreCase(condition.getCond()) && !"BETWEEN".equalsIgnoreCase(condition.getCond())) {
                return null;
            }
            Modelitem smitem = AppSchemaUtil.getModelitem(((PrimaryKey)iModelChoice).getName(), smodel);
            if (smitem == null) {
                return null;
            }
            if ("BETWEEN".equalsIgnoreCase(condition.getCond())) {
                pkeyparam_list.add(this.createPkeyparam(smitem, fkey_name, condition.getStartPrefix(), f_cp_model, p_model));
                pkeyparam_list.add(this.createPkeyparam(smitem, fkey_name, condition.getEndPrefix(), f_cp_model, p_model));
                notnullList.remove(fkey_name + condition.getStartPrefix());
                notnullList.remove(fkey_name + condition.getEndPrefix());
                continue;
            }
            pkeyparam_list.add(this.createPkeyparam(smitem, fkey_name, null, f_cp_model, p_model));
            notnullList.remove(fkey_name);
        }
        if (notnullList.size() > 0) {
            return null;
        }
        String forward_url = null;
        forward_url = StringUtils.isNotBlank((CharSequence)this.displaytext.getForeignKeyForwardFilename()) ? this.displaytext.getForeignKeyForwardFilename() : this.displaytext.getForeignKeyForwardActionid();
        StringBuilder sb = new StringBuilder();
        sb.append(forward_url);
        sb.append(".do");
        sb.append("?");
        sb.append("action_Search_Condition=");
        for (String string : pkeyparam_list) {
            sb.append("&");
            sb.append(string);
        }
        return sb.toString();
    }

    public String createPkeyparam(Modelitem smitem, String fkey_name, String suffix, Model f_cp_model, Model p_model) {
        if (StringUtils.isBlank((CharSequence)suffix)) {
            suffix = "";
        }
        StringBuilder pkeyparam = new StringBuilder();
        boolean isStorerefOrMasterref = false;
        boolean isDualinputmethod = false;
        if ("masterref".equals(smitem.getType()) || "storeref".equals(smitem.getType())) {
            isStorerefOrMasterref = true;
        } else if (StringUtils.isNotBlank((CharSequence)smitem.getDualinputmethod())) {
            isDualinputmethod = true;
        }
        pkeyparam.append(AppSchemaUtil.createNameAttribute_th(this.project, fkey_name + suffix, f_cp_model));
        pkeyparam.append("=");
        pkeyparam.append("${#jfc.encodePrimaryKey(");
        pkeyparam.append(p_model.getId());
        pkeyparam.append(".");
        pkeyparam.append(SourceGenerator.convertELProperty(smitem.getName()));
        if (isStorerefOrMasterref) {
            pkeyparam.append("[0].id");
        } else if (isDualinputmethod) {
            pkeyparam.append("[0].content");
        } else {
            pkeyparam.append(".content");
        }
        pkeyparam.append(")}");
        return pkeyparam.toString();
    }
}

