/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.test.support.testmodel.GenerateTestCode;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestEnvironment {
    private static Logger LOGGER = LogManager.getLogger(TestEnvironment.class);
    private static TestEnvironment _instance;
    private static final String KEY_GROUP = "group";
    private static final String KEY_ID = "id";
    private static final String KEY_DEFINE = "define";
    private static final String KEY_INCLUDE = "include";
    private String group_ = null;
    private String id_ = null;
    private Map<String, String> replaceMap;

    private TestEnvironment() {
    }

    public static TestEnvironment getInstance() {
        if (_instance == null) {
            _instance = new TestEnvironment();
        }
        return _instance;
    }

    public static String getKeyFromInput(String line) {
        return line.substring(line.indexOf(":") + 1, line.indexOf(":", line.indexOf(":") + 1));
    }

    public static String getValueFromInput(String line) {
        String value = line.substring(line.indexOf(":", line.indexOf(":") + 1) + 1).trim();
        if (value.indexOf("\"") >= 0) {
            value = value.substring(value.indexOf("\"") + 1, value.lastIndexOf("\"")).trim();
        }
        return value;
    }

    public void addLine(String line) {
        if (line == null || line.trim().length() < 1 || !line.startsWith(":")) {
            return;
        }
        String key = TestEnvironment.getKeyFromInput(line);
        if (key == null || key.trim().length() < 1) {
            LOGGER.warn("Line [" + line + "] is not valid for header information. key is empty.");
            return;
        }
        String value = TestEnvironment.getValueFromInput(line);
        if (value == null || value.trim().length() < 1) {
            LOGGER.warn("Value for env key [" + key + "] is empty.");
            return;
        }
        if (KEY_GROUP.equals(key)) {
            this.group_ = value;
        } else if (KEY_ID.equals(key)) {
            this.id_ = value.substring(0, 1).toUpperCase() + value.substring(1);
        } else if (KEY_DEFINE.equals(key)) {
            if (this.replaceMap == null) {
                this.replaceMap = new HashMap<String, String>();
            }
            value = line.substring(line.indexOf(":", line.indexOf(":") + 1) + 1);
            int ptr = (value = StringUtil.removePrefix((String)value, (char)' ')).indexOf(" ");
            if (ptr > 0) {
                String ov = value.substring(0, ptr).trim();
                String nv = value.substring(ptr + 1);
                this.replaceMap.put(ov, nv);
            } else {
                LOGGER.warn("define operation failed, not match value expression, " + value);
            }
        } else if (KEY_INCLUDE.equals(key)) {
            value = line.substring(line.indexOf(":", line.indexOf(":") + 1) + 1);
            Path path = Paths.get(GenerateTestCode.PATH_SCENARIO_MACRO_DIR, value = StringUtil.removePrefix((String)value, (char)' ').replace("\"", ""));
            if (!Files.exists(path, new LinkOption[0])) {
                LOGGER.warn("File " + value + " does not exist.");
            } else {
                try {
                    List<String> lines = Files.readAllLines(path);
                    lines.stream().forEach(s -> this.addLine(StrUtil.deleteCommentouts(s)));
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOGGER.error("Unknown header information: key=" + key + ", value=" + value);
        }
    }

    public String getSubPackage() {
        return this.group_;
    }

    public String getClassName() {
        return this.id_;
    }

    public String getDefinedString(String key) {
        return this.replaceMap.get(key);
    }

    public String toString() {
        StringJoiner buf = new StringJoiner("\n");
        buf.add(this.getSubPackage() + this.getClassName());
        return buf.toString();
    }
}

