/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.StrUtil;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.TestStatement;
import org.apache.commons.lang3.StringUtils;

public class TestMethod {
    private int methodNumber_;
    private String name_;
    private List<TestStatement> statements_ = new ArrayList<TestStatement>();
    private boolean isOutputStatus_ = false;
    private boolean page_obj_initialized_store_ = false;
    private boolean page_obj_initialized_condition_ = false;
    private boolean page_obj_initialized_list_ = false;
    private boolean page_obj_initialized_updatelist_ = false;

    public TestMethod(int methodNumber, String methodJpName, boolean isOutputStatus) {
        this.methodNumber_ = methodNumber;
        this.name_ = methodJpName.trim();
        this.isOutputStatus_ = isOutputStatus;
    }

    public String getName() {
        return this.name_;
    }

    public String getMethodName() {
        DecimalFormat df = new DecimalFormat("00");
        return String.format("test%s_%s", df.format(this.methodNumber_), StrUtil.swapSpecialChars(this.name_, '_'));
    }

    public List<TestStatement> getStatements() {
        return this.statements_;
    }

    public void addStatement(TestStatement stmt) {
        if (stmt.requirePageObject() && !this.page_obj_initialized_store_ && stmt.addPageObjectStoreInitCode()) {
            this.page_obj_initialized_store_ = true;
        }
        if (stmt.requirePageObject() && !this.page_obj_initialized_condition_ && stmt.addPageObjectConditionInitCode()) {
            this.page_obj_initialized_condition_ = true;
        }
        if (stmt.requirePageObject() && !this.page_obj_initialized_list_ && stmt.addPageObjectListInitCode()) {
            this.page_obj_initialized_list_ = true;
        }
        if (stmt.requirePageObject() && !this.page_obj_initialized_updatelist_ && stmt.addPageObjectUpdateListInitCode()) {
            this.page_obj_initialized_updatelist_ = true;
        }
        this.statements_.add(stmt);
    }

    public void addJavaCode(String line) {
        if (!StringUtils.isEmpty((CharSequence)line)) {
            this.statements_.add(new TestStatement(line));
        }
    }

    public boolean getOutputStatus() {
        return this.isOutputStatus_;
    }

    public String toString() {
        StringJoiner buf = new StringJoiner("\n");
        buf.add("{");
        this.statements_.forEach(action -> buf.add(action.toString()));
        buf.add("}");
        return this.name_ + " = " + buf.toString();
    }
}

