/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.test.support.testmodel.scenario.action;

import java.util.ArrayList;
import java.util.Map;
import jp.jasminesoft.jfc.test.support.testmodel.model.Attribute;
import jp.jasminesoft.jfc.test.support.testmodel.model.ConditionTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.ListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.StoreTModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.TModel;
import jp.jasminesoft.jfc.test.support.testmodel.model.UpdateListTModel;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.InvalidTestConfigException;
import jp.jasminesoft.jfc.test.support.testmodel.scenario.action.Action;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ButtonAction
extends Action {
    protected Map<String, Map<String, TModel>> testModelMap_;
    private TModel targetModel_;

    public ButtonAction(Map<String, Map<String, TModel>> testModelMap) {
        this.testModelMap_ = testModelMap;
    }

    public void setTargetModel(TModel targetModel) {
        this.targetModel_ = targetModel;
    }

    @Override
    public ArrayList<String> toCode(String actionName, String[] variables) throws InvalidTestConfigException {
        if (variables == null || variables.length < 1) {
            throw new InvalidTestConfigException("Variables for '" + actionName + "' should have at least 1 variable.");
        }
        ArrayList<String> list = new ArrayList<String>();
        String line = "";
        String param = variables[0].trim();
        if (param.equals(this.command.get("BUTTON_SEARCH"))) {
            line = this.convNoErrors("search();", actionName);
        } else if (param.equals(this.command.get("BUTTON_RESET"))) {
            line = this.convNoErrors("resetSearch();", actionName);
        } else if (param.equals(this.command.get("BUTTON_DELETE")) && variables.length <= 1) {
            list.add("clickDeleteButton();");
            list.add("confirmIfExists();");
        } else if (param.equals(this.command.get("BUTTON_SAVE"))) {
            line = this.convNoErrors("save();", actionName);
        } else if (param.equals(this.command.get("BUTTON_CANCEL"))) {
            line = this.convNoErrors("cancel();", actionName);
        } else if (param.equals(this.command.get("BUTTON_WIZARD_NEXT"))) {
            line = this.convNoErrors("clickWizardNextButton();", actionName);
        } else if (param.equals(this.command.get("BUTTON_WIZARD_BACK"))) {
            line = this.convNoErrors("clickWizardPrevButton();", actionName);
        } else if (param.equals(this.command.get("BUTTON_ADD")) || param.equals(this.command.get("BUTTON_INSERT")) || param.equals(this.command.get("BUTTON_REMOVE"))) {
            if (variables.length <= 1) {
                throw new InvalidTestConfigException("Button action '" + param + "' has no target model.");
            }
            Action.TargetModel target = new Action.TargetModel(variables[1].trim(), this.testModelMap_);
            if (target.storeModel == null) {
                throw new InvalidTestConfigException("No target model " + target.modelJp);
            }
            if (param.equals(this.command.get("BUTTON_ADD"))) {
                if (!target.isMultiple && !target.isContainer) {
                    throw new InvalidTestConfigException(target.modelJp + "." + target.attrJp + " is not multiple/container type.");
                }
            } else if (!target.isContainer) {
                throw new InvalidTestConfigException(target.modelJp + "." + target.attrJp + " is not container type.");
            }
            String method = null;
            if (param.equals(this.command.get("BUTTON_ADD"))) {
                method = this.convNoErrors("add()", actionName);
            } else if (param.equals(this.command.get("BUTTON_INSERT"))) {
                method = this.convNoErrors("insert()", actionName);
            } else if (param.equals(this.command.get("BUTTON_REMOVE"))) {
                method = this.convNoErrors("remove()", actionName);
            }
            line = String.format("%s.%s.%s;", target.instanceName, target.attributeName, method);
        } else if ((param.equals(this.command.get("BUTTON_DETAIL")) || param.equals(this.command.get("BUTTON_COPY")) || param.equals(this.command.get("BUTTON_NEW")) || param.equals(this.command.get("BUTTON_UPDATE")) || param.equals(this.command.get("BUTTON_NEW2"))) && variables.length > 1) {
            String modelJp = variables[1].trim();
            String index = null;
            int ptr = modelJp.indexOf("[");
            if (ptr > 0) {
                String suffix = modelJp.substring(ptr + 1);
                modelJp = modelJp.substring(0, ptr);
                ptr = suffix.indexOf("]");
                if (ptr > 0) {
                    String cnt = suffix.substring(0, ptr);
                    int dummy = NumberUtils.toInt((String)cnt);
                    if (dummy <= 0) {
                        throw new InvalidTestConfigException("illegal index," + variables[1]);
                    }
                    index = cnt.trim();
                }
            }
            if (index == null) {
                throw new InvalidTestConfigException("Button action '" + param + "' has illegal target model, " + variables[1]);
            }
            Map<String, TModel> storeModelMap = this.testModelMap_.get("store");
            StoreTModel storeModel = (StoreTModel)storeModelMap.get(modelJp);
            if (storeModel == null) {
                throw new InvalidTestConfigException("No target model " + modelJp);
            }
            String method = null;
            if (param.equals(this.command.get("BUTTON_DETAIL"))) {
                method = this.convNoErrors("clickDetailButton()", actionName);
            } else if (param.equals(this.command.get("BUTTON_COPY"))) {
                method = this.convNoErrors("clickCopyButton()", actionName);
            } else if (param.equals(this.command.get("BUTTON_NEW")) || param.equals(this.command.get("BUTTON_NEW2"))) {
                method = this.convNoErrors("clickNewButton()", actionName);
            } else if (param.equals(this.command.get("BUTTON_UPDATE"))) {
                method = this.convNoErrors("clickEditButton()", actionName);
            }
            String instanceName = storeModel.getClassName().toLowerCase();
            if (this.targetModel_ instanceof ListTModel || this.targetModel_ instanceof ConditionTModel) {
                instanceName = "list";
            } else if (this.targetModel_ instanceof UpdateListTModel) {
                instanceName = "updateList";
            }
            line = String.format("%s.get(%s).%s;", instanceName, index, method);
        } else if (param.equals(this.command.get("BUTTON_DETAIL"))) {
            line = this.convNoErrors("clickDetailButton();", actionName);
        } else if (param.equals(this.command.get("BUTTON_COPY"))) {
            line = this.convNoErrors("clickCopyButton();", actionName);
        } else if (param.equals(this.command.get("BUTTON_NEW"))) {
            line = this.convNoErrors("clickNewButton();", actionName);
        } else if (param.equals(this.command.get("BUTTON_UPDATE"))) {
            line = this.convNoErrors("clickEditButton()", actionName);
        } else if (param.equals(this.command.get("BUTTON_CLEAR")) || param.equals(this.command.get("BUTTON_TOGGLE"))) {
            if (variables.length <= 1) {
                throw new InvalidTestConfigException("Button action '" + param + "' has no target model.");
            }
            Action.TargetModel target = new Action.TargetModel(variables[1].trim(), this.testModelMap_);
            if (target.storeModel == null) {
                throw new InvalidTestConfigException("No target model " + target.modelJp);
            }
            String instanceName = target.instanceName;
            String attributeName = null;
            if (this.targetModel_ instanceof ConditionTModel) {
                instanceName = "condition";
                String[] tokens = variables[1].trim().split("\\.");
                String modelJp = tokens[0];
                String attrJp = tokens[1];
                for (Attribute attr : this.targetModel_.getAttributes()) {
                    if (!attrJp.equals(attr.getLabel())) continue;
                    attributeName = attr.getName();
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)attributeName)) {
                    throw new InvalidTestConfigException("No target attribute " + attrJp + " in model " + modelJp);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)target.attributeName)) {
                    throw new InvalidTestConfigException("No target attribute " + variables[1] + " in model " + target.modelJp);
                }
                attributeName = target.attributeName;
            }
            String method = this.convNoErrors("clickClearButton()", actionName);
            if ("CheckBox".equals(target.attributeJavaType)) {
                method = this.convNoErrors("clickToggleButton()", actionName);
            }
            line = target.isContainer && target.index > 0 ? String.format("%s.%s.get(%s).%s.%s;", instanceName, target.containerName, String.valueOf(target.index), attributeName, method) : String.format("%s.%s.%s;", instanceName, attributeName, method);
        } else if (param.equals(this.command.get("BUTTON_OPEN")) || param.equals(this.command.get("BUTTON_CLOSE"))) {
            Object method;
            if (variables.length <= 1) {
                throw new InvalidTestConfigException("Button action '" + param + "' has no target model.");
            }
            Action.TargetModel target = new Action.TargetModel(variables[1].trim(), this.testModelMap_);
            if (target.storeModel == null) {
                throw new InvalidTestConfigException("No target model " + target.modelJp);
            }
            String instanceName = target.instanceName;
            String attrJp = null;
            String attributeName = null;
            String attributeJavaType = null;
            if (this.targetModel_ instanceof ConditionTModel) {
                instanceName = "condition";
                String[] tokens = variables[1].trim().split("\\.");
                String modelJp = tokens[0];
                attrJp = tokens[1];
                for (Attribute attr : this.targetModel_.getAttributes()) {
                    if (!attrJp.equals(attr.getLabel())) continue;
                    attributeName = attr.getName();
                    attributeJavaType = attr.getJavaDataType();
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)attributeName)) {
                    throw new InvalidTestConfigException("No target attribute " + attrJp + " in model " + modelJp);
                }
            } else {
                if (StringUtils.isBlank((CharSequence)target.attributeName)) {
                    throw new InvalidTestConfigException("No target attribute " + variables[1] + " in model " + target.modelJp);
                }
                attrJp = target.attrJp;
                attributeName = target.attributeName;
                attributeJavaType = target.attributeJavaType;
            }
            if (!"SearchList".equals(attributeJavaType)) {
                throw new InvalidTestConfigException("Type mismatch, SearchList type will be expected, but " + attrJp + "'s type is " + attributeJavaType);
            }
            Object object = method = param.equals(this.command.get("BUTTON_OPEN")) ? "subWindow().show()" : "subWindow().hide()";
            if (!this.useCheckNoErrors(actionName)) {
                method = ((String)method).substring(0, ((String)method).length() - "()".length()) + "(false)";
            }
            line = target.isContainer && target.index > 0 ? String.format("%s.%s.get(%s).%s.%s;", instanceName, target.containerName, String.valueOf(target.index), attributeName, method) : String.format("%s.%s.%s;", instanceName, attributeName, method);
        } else {
            line = param.equals("#OK") ? this.convNoErrors("confirmIfExists();", actionName) : (this.useCheckNoErrors(actionName) ? String.format("clickButton(\"%s\");", param) : String.format("clickButton(\"%s\", false);", param));
        }
        if (StringUtils.isNotBlank((CharSequence)line)) {
            list.add(line);
        }
        return list;
    }

    private String convNoErrors(String cmd, String actionName) {
        if (this.useCheckNoErrors(actionName)) {
            return cmd;
        }
        return cmd.replace("()", "(false)");
    }
}

