/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.CreateObjectHelper;
import jp.jasminesoft.util.AsciiFilenameUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttachmentFileMap {
    private static final Logger logger = LogManager.getLogger(AttachmentFileMap.class);
    private static final boolean SAVE_ATTACHMENTFILE_AT_USE = true;
    private AbstractDbUploadUpdateRunnableMonitor monitor;
    private boolean useTempFile = true;
    private boolean keepSuffix = false;
    private boolean overrideFilename = false;
    private boolean convertAsciiFilename = true;
    private String tempFilePrefix = "__multi";
    private Map<String, File> attachmentFileMap;
    private Set<NormalizedFilename> useattachmentSet;
    private Map<NormalizedFilename, String> normalizeFilenameMap;

    protected AttachmentFileMap(AbstractDbUploadUpdateRunnableMonitor monitor) {
        this.monitor = monitor;
    }

    public void setUseTempFile(boolean b) {
        this.useTempFile = b;
    }

    public void setKeepSuffix(boolean b) {
        this.keepSuffix = b;
    }

    public void setConvertAsciiFilename(boolean b) {
        this.convertAsciiFilename = b;
    }

    public void setTempFilePrefix(String s) {
        this.tempFilePrefix = s;
    }

    public void setOverrideFilename(boolean overrideFilename) {
        this.overrideFilename = overrideFilename;
    }

    public boolean isOverrideFilename() {
        return this.overrideFilename;
    }

    public boolean isSaveAttachmentfileAtUse() {
        return true;
    }

    public File getAttachmentFile(String filename) {
        NormalizedFilename normfilename = this.createNormalizedFilenameForRelativePath(filename);
        if (normfilename == null) {
            return null;
        }
        String _filename = this.normalizeFilenameMap.get(normfilename);
        if (_filename == null) {
            return null;
        }
        return this.attachmentFileMap.get(_filename);
    }

    public void addUseAttachment(String filename) {
        NormalizedFilename normfilename = this.createNormalizedFilenameForRelativePath(filename);
        if (normfilename == null) {
            return;
        }
        if (!this.useattachmentSet.contains(normfilename)) {
            this.useattachmentSet.add(normfilename);
            if (this.isSaveAttachmentfileAtUse()) {
                this.saveAttachmentFile(normfilename);
            }
        }
    }

    protected void processStart() {
        File dir;
        this.useattachmentSet = new HashSet<NormalizedFilename>();
        this.attachmentFileMap = new HashMap<String, File>();
        this.normalizeFilenameMap = new HashMap<NormalizedFilename, String>();
        File currdir = this.monitor.getCurrentDir();
        try {
            dir = this.monitor.getAttachmentFileParentDir();
        }
        catch (IOException e) {
            logger.error("failed to save attachment file", (Throwable)e);
            return;
        }
        if (dir == null) {
            logger.debug("parentdir is null");
            return;
        }
        File parentdir = this.getCurrentFile(currdir, dir);
        if (!parentdir.exists() && !parentdir.mkdirs()) {
            logger.error("failed to attachment parent dir " + parentdir);
        }
        Set<String> set = this.monitor.getAttachmentFilenameSet();
        for (String s : set) {
            this.normalizeFilenameMap.put(new NormalizedFilename(s), s);
            try {
                File file = this.createAttachmentFile(currdir, dir, s);
                if (file == null) continue;
                this.attachmentFileMap.put(s, file);
            }
            catch (IOException e) {
                logger.error("failed to save attachment file", (Throwable)e);
            }
        }
    }

    public boolean checkFile(ActionParameter p, String modelId) {
        String key = "";
        int len = this.attachmentFileMap.size();
        if (len == 0) {
            return false;
        }
        String[] fname = new String[len];
        Object[] file = new Object[len];
        Iterator<Map.Entry<String, File>> it = this.attachmentFileMap.entrySet().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Map.Entry<String, File> v = it.next();
            fname[cnt] = v.getKey();
            file[cnt] = v.getValue();
            ++cnt;
        }
        return CreateObjectHelper.checkFile(p, fname, file, modelId, key);
    }

    private File getCurrentFile(File currdir, File file) {
        File file1 = currdir == null || file.isAbsolute() ? file : new File(currdir, file.toString());
        return file1;
    }

    protected NormalizedFilename createNormalizedFilenameForRelativePath(String filename) {
        NormalizedFilename normfilename;
        if (NormalizedFilename.isAbsolute(filename)) {
            normfilename = new NormalizedFilename(filename);
        } else {
            NormalizedFilename parentfilename = null;
            if (this.monitor.getOpenFilename() != null) {
                NormalizedFilename openfilename = new NormalizedFilename(this.monitor.getOpenFilename());
                parentfilename = openfilename.getParent();
            }
            normfilename = parentfilename == null ? new NormalizedFilename(filename) : new NormalizedFilename(parentfilename, filename);
        }
        return normfilename;
    }

    protected void processEnd() {
        if (this.isSaveAttachmentfileAtUse()) {
            this.removeAttachmentFile();
        } else {
            this.saveAttachmentFile();
        }
    }

    protected File createAttachmentFile(File currdir, File dir, String filename) throws IOException {
        File file;
        if (this.useTempFile) {
            File parentdir = this.getCurrentFile(currdir, dir);
            String ext = null;
            if (this.keepSuffix) {
                ext = this.getSuffix(filename);
            }
            File file1 = File.createTempFile(this.tempFilePrefix, ext, parentdir);
            file = new File(dir, file1.getName());
        } else {
            String name = filename;
            int idx = filename.lastIndexOf(47);
            if (idx >= 0) {
                if (idx + 1 < filename.length()) {
                    name = filename.substring(idx + 1);
                } else {
                    return null;
                }
            }
            if (this.convertAsciiFilename) {
                name = AsciiFilenameUtilities.encodeString((String)name);
            }
            if ((file = new File(dir, name)).exists() && !this.isOverrideFilename()) {
                int count = 1;
                String suffix = this.getSuffix(name);
                String _filename = suffix != null ? name.substring(0, name.length() - suffix.length()) : name;
                do {
                    String _filename0 = _filename + "_" + count + (suffix != null ? suffix : "");
                    file = new File(dir, _filename0);
                    ++count;
                } while (file.exists());
                file.createNewFile();
            }
        }
        return file;
    }

    private String getSuffix(String filename) {
        int idx1 = filename.lastIndexOf(46);
        int idx2 = filename.lastIndexOf(47);
        if (idx1 >= 0 && idx1 > idx2) {
            return filename.substring(idx1);
        }
        return null;
    }

    protected void removeAttachmentFile() {
        if (this.attachmentFileMap == null) {
            return;
        }
        File currdir = this.monitor.getCurrentDir();
        for (Map.Entry<String, File> entry : this.attachmentFileMap.entrySet()) {
            String filename = entry.getKey();
            File file1 = entry.getValue();
            File file = this.getCurrentFile(currdir, file1);
            this.removeAttachmentFile(filename, file);
        }
    }

    protected boolean removeAttachmentFile(String filename, File file) {
        if (!this.useattachmentSet.contains(new NormalizedFilename(filename))) {
            logger.debug("No useattachmentSet " + filename);
            if (this.useTempFile) {
                logger.debug("Remove temporary file " + file.toString());
                if (!file.delete()) {
                    logger.debug("Failed to remove temporary file " + file.toString());
                }
            }
            return true;
        }
        return false;
    }

    protected void saveAttachmentFile() {
        if (this.attachmentFileMap == null) {
            return;
        }
        File currdir = this.monitor.getCurrentDir();
        for (Map.Entry<String, File> entry : this.attachmentFileMap.entrySet()) {
            File file1;
            File file;
            String filename = entry.getKey();
            if (this.removeAttachmentFile(filename, file = this.getCurrentFile(currdir, file1 = entry.getValue()))) continue;
            this.saveAttachmentFile(filename, file);
        }
    }

    protected void saveAttachmentFile(NormalizedFilename normfilename) {
        String _filename = this.normalizeFilenameMap.get(normfilename);
        if (_filename == null) {
            logger.debug("nothing normfilename in normalizeFilenameMap. " + normfilename);
            return;
        }
        File currdir = this.monitor.getCurrentDir();
        File file1 = this.attachmentFileMap.get(_filename);
        if (file1 == null) {
            logger.debug("nothing _filename in attachmentFileMap. " + _filename + ", " + normfilename);
            return;
        }
        File file = this.getCurrentFile(currdir, file1);
        this.saveAttachmentFile(_filename, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAttachmentFile(String filename, File file) {
        InputStream istream = null;
        OutputStream ostream = null;
        try {
            int i;
            byte[] buf = new byte[1024];
            istream = this.monitor.getAttachmentInputStream(filename);
            ostream = new FileOutputStream(file);
            while ((i = istream.read(buf)) >= 0) {
                ostream.write(buf, 0, i);
            }
            logger.debug("Success to write attachment file " + filename + " to " + file);
        }
        catch (IOException e) {
            logger.debug("Failed to write attachment file " + filename + " to " + file, (Throwable)e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close input stream", (Throwable)e);
                }
            }
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {
                    logger.error("Failed to close output stream", (Throwable)e);
                }
            }
        }
    }

    protected static class NormalizedFilename {
        List<String> filenames = new ArrayList<String>();
        boolean isAbsolute;

        public NormalizedFilename(String filename) {
            this.set(filename);
        }

        public NormalizedFilename(NormalizedFilename parent, String filename) {
            this.set(parent, filename);
        }

        NormalizedFilename(List<String> filenames, boolean isAbsolute) {
            this.filenames = filenames;
            this.isAbsolute = isAbsolute;
        }

        void set(String filename) {
            this.isAbsolute = NormalizedFilename._set(filename, this.filenames);
            this.filenames = NormalizedFilename.removeDotDotFolder(this.filenames);
        }

        /*
         * Unable to fully structure code
         */
        private static boolean _set(String filename, List<String> filenames) {
            isAbsolute = NormalizedFilename.isAbsolute(filename);
            filenames.clear();
            stk = new StringTokenizer(filename.trim(), "\\/");
            if (!stk.hasMoreTokens()) {
                return isAbsolute;
            }
            do lbl-1000:
            // 3 sources

            {
                if ((token = stk.nextToken()).equals("") || token.equals(".")) continue;
                filenames.add(token);
                if (stk.hasMoreTokens()) ** GOTO lbl-1000
                return isAbsolute;
            } while (stk.hasMoreTokens());
            return isAbsolute;
        }

        private static List<String> removeDotDotFolder(List<String> filenames) {
            ArrayList<String> newfilenames = new ArrayList<String>();
            for (String filename : filenames) {
                int size;
                if (filename.equals("..") && (size = newfilenames.size()) >= 1) {
                    newfilenames.remove(size - 1);
                    continue;
                }
                newfilenames.add(filename);
            }
            return newfilenames;
        }

        void set(NormalizedFilename parent, String filename) {
            this.isAbsolute = NormalizedFilename._set(filename, this.filenames);
            if (this.isAbsolute()) {
                return;
            }
            if (parent == null) {
                return;
            }
            this.filenames.addAll(0, parent.filenames);
            this.isAbsolute = parent.isAbsolute;
            this.filenames = NormalizedFilename.removeDotDotFolder(this.filenames);
        }

        static boolean isAbsolute(String filename) {
            if (filename == null) {
                return false;
            }
            if ((filename = filename.trim()).length() == 0) {
                return false;
            }
            char c = filename.charAt(0);
            if (c == '/' || c == '\\') {
                return true;
            }
            if (filename.length() < 2) {
                return false;
            }
            c = filename.charAt(1);
            return c == ':';
        }

        public NormalizedFilename getParent() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.filenames.size() > 1) {
                for (int i = 0; i < this.filenames.size() - 1; ++i) {
                    list.add(this.filenames.get(i));
                }
            }
            return new NormalizedFilename(list, this.isAbsolute());
        }

        public boolean isAbsolute() {
            return this.isAbsolute;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NormalizedFilename)) {
                return false;
            }
            NormalizedFilename f = (NormalizedFilename)obj;
            return this.isAbsolute == f.isAbsolute && this.filenames.equals(f.filenames);
        }

        public int hashCode() {
            return this.filenames.hashCode() + (this.isAbsolute ? 1 : 0);
        }
    }
}

