/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.User;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckPermissionImpl
implements CheckPermission {
    private boolean default_ignore_securitycheck = false;
    private static Logger logger = LogManager.getLogger((String)CheckPermissionImpl.class.getName());
    private URL default_security_url;
    private static final JFCAppPermission[] DEFAULT_PERMISSIONS = new JFCAppPermission[]{new JFCAppPermission("juser", "default"), new JFCAppPermission("juser", "pbean_show"), new JFCAppPermission("juser", "pbean_update"), new JFCAppPermission("jgroup", "pbean_showList")};

    @Override
    public void setDefaultIgnoreSecuritycheck(boolean b) {
        this.default_ignore_securitycheck = b;
    }

    @Override
    public boolean getDefaultIgnoreSecuritycheck() {
        return this.default_ignore_securitycheck;
    }

    @Override
    public URL getDefaultSecurityPolicyUrl() {
        return this.default_security_url;
    }

    @Override
    public void setDefaultSecurityPolicyUrl(URL default_security_url) {
        this.default_security_url = default_security_url;
    }

    @Override
    public boolean process(User user, Permission perm) {
        return this.process(user, perm, this.getDefaultSecurityPolicyUrl(), this.getDefaultIgnoreSecuritycheck());
    }

    @Override
    public boolean process(User user, Permission perm, URL security_url, boolean ignore_securitycheck) {
        if (ignore_securitycheck) {
            return true;
        }
        if (perm == null) {
            return true;
        }
        if (user == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("this process is defined for permission " + perm);
        }
        if (user.checkPasswdChangeFlag()) {
            boolean isDefaultPermission = false;
            for (int i = 0; i < DEFAULT_PERMISSIONS.length; ++i) {
                if (!DEFAULT_PERMISSIONS[i].implies(perm)) continue;
                isDefaultPermission = true;
                break;
            }
            if (!isDefaultPermission && !User.UNLOCK_PERMISSION.implies(perm)) {
                return false;
            }
        }
        PermissionCollection pcoll = user.getPermissionCollection(security_url);
        if (logger.isDebugEnabled()) {
            logger.debug("user's perm collection is " + pcoll);
        }
        return this.permissionCheck(perm, pcoll);
    }

    protected boolean permissionCheck(Permission perm, PermissionCollection pcoll) {
        Permission p;
        boolean checkFlag = false;
        Enumeration<Permission> e = pcoll.elements();
        while (e.hasMoreElements() && !(checkFlag = (p = e.nextElement()).implies(perm))) {
        }
        return checkFlag;
    }
}

