/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import jp.jasminesoft.jfc.ClusterManager;
import jp.jasminesoft.jfc.ClusterManagerImpl;
import jp.jasminesoft.jfc.PropertyManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterManagerFactory {
    private static final String ClusterManagerSystemPropertyName = "jp.jasminesoft.jfc.ClusterManagerFactory";
    private static ClusterManager instance;
    private static Logger logger;

    public static ClusterManager getClusterManager() {
        return instance;
    }

    private static ClusterManager createClusterManager(String clustermanClassname) {
        Class<?> clustermanClass;
        if (clustermanClassname == null) {
            return null;
        }
        try {
            clustermanClass = Class.forName(clustermanClassname);
        }
        catch (ClassNotFoundException e) {
            logger.warn("clusterman class " + clustermanClassname + " is not found", (Throwable)e);
            return null;
        }
        return ClusterManagerFactory.createClusterManager(clustermanClass);
    }

    private static ClusterManager createClusterManager(Class clustermanClass) {
        Object clustermanobj;
        if (clustermanClass == null) {
            return null;
        }
        try {
            clustermanobj = clustermanClass.newInstance();
        }
        catch (InstantiationException e1) {
            logger.warn("failed to create clusterman class " + clustermanClass, (Throwable)e1);
            return null;
        }
        catch (IllegalAccessException e2) {
            logger.warn("failed to create clusterman class " + clustermanClass, (Throwable)e2);
            return null;
        }
        catch (Exception e3) {
            logger.warn("failed to create clusterman class " + clustermanClass, (Throwable)e3);
            return null;
        }
        if (!(clustermanobj instanceof ClusterManager)) {
            logger.warn("Invalid instance of ClusterManager, class " + clustermanClass);
            return null;
        }
        return (ClusterManager)clustermanobj;
    }

    static {
        logger = LogManager.getLogger((String)ClusterManagerFactory.class.getName());
        String clustermanClassname = PropertyManager.getProperty(ClusterManagerSystemPropertyName);
        logger.debug("clusterman classname=" + clustermanClassname);
        ClusterManager clusterman = ClusterManagerFactory.createClusterManager(clustermanClassname);
        if (clusterman == null) {
            clusterman = new ClusterManagerImpl();
        }
        instance = clusterman;
    }
}

