/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import jp.jasminesoft.jfc.ClusterEvent;
import jp.jasminesoft.jfc.ClusterListener;
import jp.jasminesoft.jfc.ClusterManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.MBeanServerConnectionFactoryBeanWrapper;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterManagerImpl
implements Serializable,
ClusterManager {
    private static final String BundleBaseName = "jfccluster";
    private String UseClusterPropertyName = "use_cluster";
    private String ConnectSleeptime = "connect.sleeptime";
    private String ConnectRetry = "connect.retry";
    private String ClusterListMachinename = "cluster_list.machinename.";
    private String ClusterListJmxUrl = "cluster_list.jmx_url.";
    private String ClusterListJmxPort = "cluster_list.jmx_port.";
    private String ClusterListRmiPort = "cluster_list.rmi_port.";
    private String ClusterListIPAddr = "cluster_list.ipaddr.";
    private String ClusterListThismachine = "cluster_list.thismachine.";
    protected int retryCount = 2;
    protected int sleepTime = 3000;
    protected int jmx_port = 8999;
    protected int rmi_port = 8998;
    private String thismachinename = null;
    protected Map<String, MBeanServerConnectionFactoryBeanWrapper> clusterMap = Collections.synchronizedMap(new LinkedHashMap());
    private JMXConnectorServer connectorServer = null;
    public static final Logger logger = LogManager.getLogger((String)ClusterManagerImpl.class.getName());
    private ArrayList clusterListener = new ArrayList();

    public static String getProperty(String name) {
        String value = null;
        try {
            ResourceBundle res = ResourceBundle.getBundle(BundleBaseName);
            value = res.getString(name);
        }
        catch (MissingResourceException e) {
            logger.debug("No resource jfccluster", (Throwable)e);
        }
        return value;
    }

    public ClusterManagerImpl() {
        if (this.getUseCluster()) {
            this.init();
            logger.info("(admin@localhost) * enable use_cluster, this machiename is " + this.getThisMachinename());
        }
    }

    @Override
    public boolean getUseCluster() {
        String s = ClusterManagerImpl.getProperty(this.UseClusterPropertyName);
        if (s == null) {
            return false;
        }
        return Boolean.valueOf(s);
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public int getSleepTime() {
        return this.sleepTime;
    }

    protected void init() {
        if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ConnectRetry))) {
            this.retryCount = StringUtil.intValue((String)ClusterManagerImpl.getProperty(this.ConnectRetry));
        }
        if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ConnectSleeptime))) {
            this.sleepTime = StringUtil.intValue((String)ClusterManagerImpl.getProperty(this.ConnectSleeptime));
        }
        this.initClusterMap();
        this.registMBean();
    }

    protected void initClusterMap() {
        for (int i = 1; i <= 100; ++i) {
            String name = ClusterManagerImpl.getProperty(this.ClusterListMachinename + i);
            boolean isThismachine = Boolean.valueOf(ClusterManagerImpl.getProperty(this.ClusterListThismachine + i));
            if (isThismachine) {
                this.thismachinename = name;
                if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ClusterListJmxPort + i))) {
                    this.jmx_port = StringUtil.intValue((String)ClusterManagerImpl.getProperty(this.ClusterListJmxPort + i));
                }
                if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ClusterListRmiPort + i))) {
                    this.rmi_port = StringUtil.intValue((String)ClusterManagerImpl.getProperty(this.ClusterListRmiPort + i));
                }
            }
            if (StringUtils.isBlank((CharSequence)name) || isThismachine) continue;
            Object url = null;
            if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ClusterListJmxUrl + i))) {
                url = ClusterManagerImpl.getProperty(this.ClusterListJmxUrl + i);
            } else {
                if (StringUtils.isBlank((CharSequence)ClusterManagerImpl.getProperty(this.ClusterListIPAddr + i))) continue;
                int cluster_jmx_port = 8999;
                if (StringUtils.isNotBlank((CharSequence)ClusterManagerImpl.getProperty(this.ClusterListJmxPort + i))) {
                    cluster_jmx_port = StringUtil.intValue((String)ClusterManagerImpl.getProperty(this.ClusterListJmxPort + i));
                }
                String ipaddr = ClusterManagerImpl.getProperty(this.ClusterListIPAddr + i);
                url = "service:jmx:rmi:///jndi/rmi://" + ipaddr + ":" + cluster_jmx_port + "/jmxrmi";
            }
            this.clusterMap.put(name, new MBeanServerConnectionFactoryBeanWrapper(name, (String)url, this.retryCount, this.sleepTime));
            logger.info("(admin@localhost) * register '" + name + "' as a cluster machine.");
        }
    }

    protected void registMBean() {
        ObjectName objname = null;
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            System.setProperty("java.rmi.server.randomIDs", "true");
            LocateRegistry.createRegistry(this.jmx_port);
            HashMap map = new HashMap();
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://locahost:" + this.rmi_port + "/jndi/rmi://localhost:" + this.jmx_port + "/jmxrmi");
            this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, map, server);
            this.connectorServer.start();
            objname = new ObjectName("jp.jasminesoft.jfc:type=LogonStatusManager");
            if (!server.isRegistered(objname)) {
                server.registerMBean(LogonStatusManager.getInstance(), objname);
            }
        }
        catch (NotCompliantMBeanException ncmbe) {
            logger.error("(admin@localhost) " + ncmbe.getMessage());
        }
        catch (Exception e) {
            logger.error("(admin@localhost) Failed to regist MBean. " + objname, (Throwable)e);
        }
    }

    @Override
    public String getThisMachinename() {
        return this.thismachinename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClusterListener(ClusterListener listener) {
        ArrayList arrayList = this.clusterListener;
        synchronized (arrayList) {
            this.clusterListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterListener(ClusterListener listener) {
        ArrayList arrayList = this.clusterListener;
        synchronized (arrayList) {
            this.clusterListener.remove(listener);
        }
    }

    @Override
    public void addResponseMachine(String machinename) {
        this.fireAddResponseMachineEvent(machinename);
    }

    @Override
    public void removeResponseMachine(String machinename) {
        this.fireRemoveResponseMachineEvent(machinename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddResponseMachineEvent(String machinename) {
        ClusterListener[] listeners;
        if (machinename == null) {
            return;
        }
        logger.info("(admin@localhost) * add '" + machinename + "' to active cluster list.");
        MBeanServerConnectionFactoryBeanWrapper bean = this.clusterMap.get(machinename);
        if (bean == null) {
            return;
        }
        bean.setActive(true);
        ArrayList arrayList = this.clusterListener;
        synchronized (arrayList) {
            listeners = this.clusterListener.toArray(new ClusterListener[0]);
        }
        ClusterEvent event = new ClusterEvent("addResponseMachine", machinename);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].addResponseMachine(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveResponseMachineEvent(String machinename) {
        ClusterListener[] listeners;
        if (machinename == null) {
            return;
        }
        logger.info("(admin@localhost) * remove '" + machinename + "' from active cluster list.");
        MBeanServerConnectionFactoryBeanWrapper bean = this.clusterMap.get(machinename);
        if (bean == null) {
            return;
        }
        bean.setActive(false);
        ArrayList arrayList = this.clusterListener;
        synchronized (arrayList) {
            listeners = this.clusterListener.toArray(new ClusterListener[0]);
        }
        ClusterEvent event = new ClusterEvent("removeResponseMachine", machinename);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].removeResponseMachine(event);
        }
    }

    @Override
    public MBeanServerConnectionFactoryBeanWrapper[] getMBeanServerConnectionFactoryBeanWrapperList() {
        if (!this.getUseCluster()) {
            return new MBeanServerConnectionFactoryBeanWrapper[0];
        }
        return this.clusterMap.values().toArray(new MBeanServerConnectionFactoryBeanWrapper[0]);
    }

    public String[] getActiveMachineList() {
        MBeanServerConnectionFactoryBeanWrapper[] beans = this.getMBeanServerConnectionFactoryBeanWrapperList();
        ArrayList<String> list = new ArrayList<String>();
        for (MBeanServerConnectionFactoryBeanWrapper bean : beans) {
            if (!bean.isActive()) continue;
            list.add(bean.getMachineName());
        }
        return list.toArray(new String[0]);
    }

    @Override
    public void checkActive(String machinename) {
        MBeanServerConnectionFactoryBeanWrapper bean = this.clusterMap.get(machinename);
        if (bean != null && !bean.isActive()) {
            this.addResponseMachine(machinename);
        }
    }

    @Override
    public void close() {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (IOException ioe) {
                logger.error("(admin@localhost) Failed to close JMXConnectorServer. " + ioe.getMessage());
            }
        }
    }
}

