/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbDownloadProcessor;
import jp.jasminesoft.jfc.JFCClientAbortException;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.util.CSVUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbDownloadProcessorImpl_Csv
implements DbDownloadProcessor {
    private static final Logger logger = LogManager.getLogger(DbDownloadProcessorImpl_Csv.class);
    private ActionParameter p;
    private String modelId;
    private String csvencoding;
    private char sepChar;
    private char repChar;
    private BufferedOutputStream ostream;
    private BufferedWriter writer;

    public DbDownloadProcessorImpl_Csv(ActionParameter p, String modelId, OutputStream ostream, String enc) throws UnsupportedEncodingException {
        this(p, modelId, ostream, enc, ',', '\"');
    }

    public DbDownloadProcessorImpl_Csv(ActionParameter p, String modelId, OutputStream ostream, String enc, char sep) throws UnsupportedEncodingException {
        this(p, modelId, ostream, enc, sep, '\"');
    }

    public DbDownloadProcessorImpl_Csv(ActionParameter p, String modelId, OutputStream ostream, String enc, char sep, char rep) throws UnsupportedEncodingException {
        this.p = p;
        this.modelId = modelId;
        this.csvencoding = enc;
        this.sepChar = sep;
        this.repChar = rep;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("csvencoding", this.csvencoding);
        params.put("sepChar", Character.valueOf(this.sepChar));
        params.put("repChar", Character.valueOf(this.repChar));
        String writetype = new ScriptCodeRunner(modelId).process("Download" + StringUtil.capFirst((String)modelId), "outputCsv", "getWriteType", params, p);
        if (writetype != null && writetype.equals("OutputStream")) {
            this.ostream = new BufferedOutputStream(ostream);
        } else {
            this.writer = new BufferedWriter(new OutputStreamWriter(ostream, enc));
        }
    }

    @Override
    public boolean isEnableObjectWrite() {
        return false;
    }

    @Override
    public void write(String[] _data) throws IOException {
        try {
            this.outputCsv(_data);
        }
        catch (IOException e) {
            JFCClientAbortException cae = JFCClientAbortException.create(e);
            if (cae != null) {
                throw cae;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputCsv(String[] _data) throws IOException {
        String ALREADYOUTPUT_KEY = "DbDownloadProcessor_alreadyoutput";
        this.p.request.removeAttribute("DbDownloadProcessor_alreadyoutput");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("data", _data);
            if (this.ostream != null) {
                params.put("ostream", this.ostream);
            }
            if (this.writer != null) {
                params.put("writer", this.writer);
            }
            params.put("csvencoding", this.csvencoding);
            params.put("sepChar", Character.valueOf(this.sepChar));
            params.put("repChar", Character.valueOf(this.repChar));
            Object alreadyOutput = this.p.request.getAttribute("DbDownloadProcessor_alreadyoutput");
            String status = new ScriptCodeRunner(this.modelId).process("Download" + StringUtil.capFirst((String)this.modelId), "outputCsv", params, this.p);
            if (StringUtils.isNotBlank((CharSequence)status)) {
                logger.warn(status);
            }
            if (alreadyOutput != null) {
                return;
            }
        }
        finally {
            this.p.request.removeAttribute("DbDownloadProcessor_alreadyoutput");
        }
        if (this.writer == null) {
            String scriptfilename = this.modelId + "/Download" + StringUtil.capFirst((String)this.modelId) + "_outputCsv";
            logger.debug("Can't use writer, because script file " + scriptfilename + " writetype is OutputStream.");
            return;
        }
        this.writer.write(CSVUtil.makeCSVLine((String[])_data, (char)this.repChar, (char)this.sepChar));
        this.writer.write("\r\n");
    }

    @Override
    public void write(List<Serializable> _data) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                JFCClientAbortException cae = JFCClientAbortException.create(e);
                if (cae != null) {
                    throw cae;
                }
                throw e;
            }
            finally {
                this.writer = null;
            }
        }
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException e) {
                JFCClientAbortException cae = JFCClientAbortException.create(e);
                if (cae != null) {
                    throw cae;
                }
                throw e;
            }
            finally {
                this.ostream = null;
            }
        }
    }
}

