/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitor;
import jp.jasminesoft.jfc.AbstractDbUploadUpdateRunnableMonitorFileProcessorImpl;
import jp.jasminesoft.jfc.ActionParameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv
extends AbstractDbUploadUpdateRunnableMonitorFileProcessorImpl {
    private static final Logger logger = LogManager.getLogger(DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.class);
    private static final String[] AcceptFilenameExtension = new String[]{".csv", ".tsv"};
    private static final char[] AcceptFilenameSeparator = new char[]{',', '\t'};
    private String uploadfilename;
    protected char DefaultSepChar = (char)44;

    DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv() {
    }

    public static boolean isProcessFile(String filename) {
        for (String ext : AcceptFilenameExtension) {
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static char getSeparator(String filename) {
        for (int i = 0; i < AcceptFilenameExtension.length; ++i) {
            String ext = AcceptFilenameExtension[i];
            if (!filename.toLowerCase().endsWith(ext)) continue;
            return AcceptFilenameSeparator[i];
        }
        return '\u0000';
    }

    @Override
    public void setBaseFile(File file, String uploadfilename) {
        this.file = file;
        this.uploadfilename = uploadfilename;
        char sep = DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.getSeparator(uploadfilename);
        this.SepChar = sep != '\u0000' ? sep : this.DefaultSepChar;
    }

    @Override
    public void setDbUploadUpdateRunnableMonitor(AbstractDbUploadUpdateRunnableMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void setActionParameter(ActionParameter p) {
        this.p = p;
    }

    @Override
    public void setSeparateCharacter(char c) {
        this.DefaultSepChar = c;
        if (this.uploadfilename == null || DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv.getSeparator(this.uploadfilename) == '\u0000') {
            this.SepChar = c;
        }
    }

    @Override
    public boolean isProcessMultiFiles() {
        return false;
    }

    @Override
    public String getOpenFilename() {
        return null;
    }

    @Override
    public List<String> getOpenFilenames() {
        return null;
    }

    @Override
    public boolean hasNextFile() {
        return this.filecnt == 0;
    }

    @Override
    public void openFile() throws IOException {
        if (this.isOpenFile()) {
            return;
        }
        this._openFile();
    }

    @Override
    protected void _openFile() throws IOException {
        this._openFile(this.file, this.encoding);
    }

    protected void _openFile(File file, String csvencoding) throws IOException {
        FileInputStream istream = new FileInputStream(file);
        try {
            this.setReader(istream, csvencoding);
        }
        catch (IOException e) {
            try {
                ((InputStream)istream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void processEnd() {
        try {
            this.closeFile();
        }
        catch (IOException e) {
            logger.warn("failed to close reader", (Throwable)e);
        }
    }

    @Override
    public void readHeader() throws IOException {
        super.readHeader();
        this.openFile();
        String[] header = this.readRowData();
        this.monitor.readHeader(header, true);
    }

    @Override
    public String[] readHeaderBeforeScript() throws IOException {
        this.openFile();
        this.p.request.setAttribute("DbUploadUpdateRunnableMonitorFileProcessor_readHeaderBeforeScript", (Object)Boolean.TRUE);
        String[] header = this.readRowData();
        this.p.request.removeAttribute("DbUploadUpdateRunnableMonitorFileProcessor_readHeaderBeforeScript");
        return header;
    }

    @Override
    public void setHeader(String[] header, boolean isUseHeaderRow) throws IOException {
        super.setHeader(header, isUseHeaderRow);
        this.openFile();
        this.monitor.readHeader(header, true);
        if (!isUseHeaderRow) {
            this.reopenFile();
        }
    }

    @Override
    public Set<String> getAttachmentFilenameSet() {
        return Collections.emptySet();
    }

    @Override
    public InputStream getAttachmentInputStream(String filename) throws IOException {
        return null;
    }
}

