/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.jasminesoft.csv2xml.CSVContentHandler;
import jp.jasminesoft.csv2xml.DefaultCSVHandler;
import jp.jasminesoft.csv2xml.XLSParser;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv;
import jp.jasminesoft.util.CSVUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;

public class DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls
extends DbUploadUpdateRunnableMonitorFileProcessorImpl_Csv {
    private static final Logger logger = LogManager.getLogger(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.class);
    private static final String CsvEncoding = "UTF-8";
    public static final String DefaultNumberFormatStr = "##0.###";
    private String numberFormatStr = "##0.###";
    private String ymdFormatStr = "yyyy-MM-dd";
    private String hmsFormatStr = "HH:mm:ss";
    private String ymdhmsFormatStr = "yyyy-MM-dd HH:mm:ss";
    protected File tempfile;

    public static boolean isProcessFile(String filename) {
        String fnlc = filename.toLowerCase();
        return fnlc.endsWith(".xls") || fnlc.endsWith(".xlsx");
    }

    @Override
    public boolean isUseScript() {
        return false;
    }

    @Override
    public void setSeparateCharacter(char c) {
    }

    @Override
    public void setEncoding(String s) {
    }

    @Override
    public String getNumberFormat() {
        return this.numberFormatStr;
    }

    @Override
    public void setNumberFormat(String numberFormatStr) {
        this.numberFormatStr = numberFormatStr;
    }

    @Override
    public String getYmdFormat() {
        return this.ymdFormatStr;
    }

    @Override
    public void setYmdFormat(String ymdFormatStr) {
        this.ymdFormatStr = ymdFormatStr;
    }

    @Override
    public String getHmsFormat() {
        return this.hmsFormatStr;
    }

    @Override
    public void setHmsFormat(String hmsFormatStr) {
        this.hmsFormatStr = hmsFormatStr;
    }

    @Override
    public String getYmdhmsFormat() {
        return this.ymdhmsFormatStr;
    }

    @Override
    public void setYmdhmsFormat(String ymdhmsFormatStr) {
        this.ymdhmsFormatStr = ymdhmsFormatStr;
    }

    @Override
    public void openFile() throws IOException {
        this.openFile(false);
    }

    public void openFile(boolean processingReadHeader) throws IOException {
        if (this.isOpenFile()) {
            return;
        }
        this.tempfile = this.createTempFile(processingReadHeader);
        if (this.tempfile == null) {
            return;
        }
        this._openFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFile(boolean processingReadHeader) throws IOException, FileNotFoundException {
        File _tempfile;
        block11: {
            _tempfile = File.createTempFile("DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls", ".csv");
            FileOutputStream ostream = new FileOutputStream(_tempfile);
            PrintWriter writer = null;
            boolean iserror = false;
            try {
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)ostream, CsvEncoding));
                XlsCsvContentHandler handler = new XlsCsvContentHandler(writer, processingReadHeader);
                MyXLSParser parser = new MyXLSParser();
                parser.setCSVContentHandler((CSVContentHandler)handler);
                parser.parse(this.file);
            }
            catch (IOException e) {
                iserror = true;
                throw e;
            }
            catch (IllegalStateException e) {
                String type = e.getMessage();
                if (type.equals("XlsCsvContentHandler.ErrorReadHeader")) {
                    iserror = true;
                    break block11;
                }
                if (type.equals("XlsCsvContentHandler.EndSheet")) {
                    break block11;
                }
                iserror = true;
                throw e;
            }
            finally {
                if (writer != null) {
                    writer.close();
                    ostream = null;
                }
                if (ostream != null) {
                    ((OutputStream)ostream).close();
                }
                if (iserror) {
                    _tempfile.delete();
                    _tempfile = null;
                }
            }
        }
        return _tempfile;
    }

    @Override
    protected void _openFile() throws IOException {
        if (this.tempfile == null) {
            return;
        }
        this._openFile(this.tempfile, CsvEncoding);
    }

    @Override
    public void reopenFile() throws IOException {
        this._closeFile();
        this._openFile();
    }

    @Override
    public void closeFile() throws IOException {
        try {
            super.closeFile();
        }
        finally {
            if (this.tempfile != null) {
                this.tempfile.delete();
            }
        }
    }

    @Override
    public void readHeader() throws IOException {
        this.header = null;
        this.openFile(true);
    }

    @Override
    public String[] readRowData() throws IOException {
        String[] sa = super.readRowData();
        String[] ret = DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.removeCellType(sa);
        this.p.request.setAttribute("DbUploadUpdate_data", (Object)ret);
        return ret;
    }

    private static String[] removeCellType(String[] sa) {
        String[] ret = new String[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            ret[i] = sa[i].equals("") ? sa[i] : sa[i].substring(1);
        }
        return ret;
    }

    @Override
    public DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs readRowDataWithAttr() throws IOException {
        String[] sa = super.readRowData();
        String[] rets = new String[sa.length];
        DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] ret = new DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            String value;
            XlsCellType type;
            logger.debug("sa[" + i + "]=" + sa[i]);
            if (sa[i].equals("")) {
                type = XlsCellType.E;
                value = sa[i];
            } else {
                String typestr = sa[i].substring(0, 1);
                try {
                    type = XlsCellType.valueOf(typestr);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Unknown type " + typestr, (Throwable)e);
                    throw e;
                }
                value = sa[i].substring(1);
            }
            rets[i] = value;
            ret[i] = new MyCellAttr(type, value, this.getNumberFormat());
        }
        return new MyCellAttrs(rets, ret);
    }

    class XlsCsvContentHandler
    extends DefaultCSVHandler {
        private static final String ErrorReadHeader = "XlsCsvContentHandler.ErrorReadHeader";
        private static final String EndSheet = "XlsCsvContentHandler.EndSheet";
        private List<String> columns = new ArrayList<String>();
        private StringBuilder sb = new StringBuilder();
        private PrintWriter writer;
        private boolean processingReadHeader;

        XlsCsvContentHandler(PrintWriter writer, boolean processingReadHeader) {
            this.writer = writer;
            this.processingReadHeader = processingReadHeader;
        }

        public void beginColumn(int colcnt) throws IOException {
        }

        public void beginRow(int rowcnt) throws IOException {
        }

        public void beginSheet(int sheetnum, String name) throws IOException {
            if (sheetnum > 1) {
                throw new IllegalStateException(EndSheet);
            }
        }

        public void characters(char[] ch, int start, int length) throws IOException {
            this.sb.append(new String(ch, start, length));
        }

        public void endColumn(int colcnt) throws IOException {
            while (this.columns.size() < colcnt - 1) {
                this.columns.add("");
            }
            this.columns.add(this.sb.toString());
            this.sb = new StringBuilder();
        }

        public void endRow(int rowcnt) throws IOException {
            if (this.processingReadHeader) {
                this.endRowProcessingReadHeader(rowcnt);
            } else {
                String[] data = this.columns.toArray(new String[this.columns.size()]);
                String line = CSVUtil.makeCSVLine((String[])data, (char)'\"', (char)DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.SepChar);
                this.writer.println(line);
                logger.debug("line=" + line);
                this.columns.clear();
            }
        }

        private void endRowProcessingReadHeader(int rowcnt) throws IOException {
            String[] data = this.columns.toArray(new String[this.columns.size()]);
            if (rowcnt == 1 && DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.header == null) {
                String[] _data = DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.removeCellType(data);
                DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.monitor.readHeader(_data, true);
                if (DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.p.errors.sizeJfcerror() > 0) {
                    throw new IllegalStateException(ErrorReadHeader);
                }
            } else {
                if (rowcnt == 1 && DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.header != null) {
                    DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.monitor.readHeader(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.header, true);
                    if (DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.p.errors.sizeJfcerror() > 0) {
                        throw new IllegalStateException(ErrorReadHeader);
                    }
                }
                String line = CSVUtil.makeCSVLine((String[])data, (char)'\"', (char)DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.SepChar);
                this.writer.println(line);
                logger.debug("line=" + line);
            }
            this.columns.clear();
        }

        public void endSheet(int sheetnum, String name) throws IOException {
        }
    }

    class MyXLSParser
    extends XLSParser {
        private final SimpleDateFormat YMDFormat;
        private final SimpleDateFormat HMSFormat;
        private final SimpleDateFormat YMDHMSFormat;
        private final DecimalFormat NumberFormat;
        private final HashMap<Short, Format> DataFormatMap;

        MyXLSParser() {
            this.YMDFormat = new SimpleDateFormat(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.ymdFormatStr);
            this.HMSFormat = new SimpleDateFormat(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.hmsFormatStr);
            this.YMDHMSFormat = new SimpleDateFormat(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.ymdhmsFormatStr);
            this.NumberFormat = DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.numberFormatStr != null ? new DecimalFormat(DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.this.numberFormatStr) : null;
            this.DataFormatMap = new HashMap();
            this.DataFormatMap.put((short)31, this.YMDFormat);
            this.DataFormatMap.put((short)58, this.YMDFormat);
        }

        protected Format getNumberFormat(DataFormat dataformat, Cell cell, int rowcnt, int colcnt) {
            String dataformatstr;
            CellStyle cellstyle = cell.getCellStyle();
            short dataformatnum = cellstyle.getDataFormat();
            if (this.DataFormatMap.containsKey(dataformatnum)) {
                return this.DataFormatMap.get(dataformatnum);
            }
            try {
                dataformatstr = dataformat.getFormat(dataformatnum);
            }
            catch (Exception e) {
                logger.debug("Failed to getFormat. use DefaultDateFormat " + this.YMDHMSFormat + ". row:" + rowcnt + " col:" + colcnt + " formatnum:" + dataformatnum, (Throwable)e);
                return this.YMDHMSFormat;
            }
            boolean isDateFormat = DateUtil.isCellDateFormatted((Cell)cell);
            if (!isDateFormat) {
                return this.NumberFormat;
            }
            if (dataformatnum == 0) {
                return this.YMDHMSFormat;
            }
            String s = dataformatstr.toLowerCase();
            boolean isYMDFormat = false;
            if (s.indexOf(121) >= 0 || s.indexOf(100) >= 0) {
                isYMDFormat = true;
            }
            boolean isHMSFormat = false;
            if (s.indexOf(104) >= 0 || s.indexOf(115) >= 0) {
                isHMSFormat = true;
            }
            if (isYMDFormat && isHMSFormat) {
                return this.YMDHMSFormat;
            }
            if (isYMDFormat) {
                return this.YMDFormat;
            }
            if (isHMSFormat) {
                return this.HMSFormat;
            }
            return this.YMDHMSFormat;
        }

        protected String formatNumber(Format format, Cell cell) {
            if (format == null) {
                double d = cell.getNumericCellValue();
                return Double.toString(d);
            }
            return super.formatNumber(format, cell);
        }

        protected String getValue(DataFormat dataformat, Cell cell, int rowcnt, int colcnt, CellType celltype) {
            String s = super.getValue(dataformat, cell, rowcnt, colcnt, celltype);
            if (s == null) {
                return null;
            }
            XlsCellType ct = this.getCellTypeStr(dataformat, cell, rowcnt, colcnt, celltype);
            return ct.toString() + s;
        }

        private XlsCellType getCellTypeStr(DataFormat dataformat, Cell cell, int rowcnt, int colcnt, CellType celltype) {
            switch (celltype) {
                case NUMERIC: {
                    Format format = this.getNumberFormat(dataformat, cell, rowcnt, colcnt);
                    logger.debug("rowcnt=" + rowcnt + " colcnt=" + colcnt + " format=" + format);
                    if (format == null || format instanceof DecimalFormat) {
                        return XlsCellType.N;
                    }
                    if (format instanceof SimpleDateFormat) {
                        return XlsCellType.D;
                    }
                    return XlsCellType.E;
                }
                case STRING: {
                    return XlsCellType.S;
                }
                case FORMULA: {
                    CellType resulttype = cell.getCachedFormulaResultType();
                    assert (resulttype != CellType.FORMULA);
                    return this.getCellTypeStr(dataformat, cell, rowcnt, colcnt, resulttype);
                }
                case BLANK: {
                    return XlsCellType.S;
                }
                case BOOLEAN: {
                    return XlsCellType.S;
                }
                case ERROR: {
                    return XlsCellType.S;
                }
            }
            return XlsCellType.E;
        }
    }

    public static enum XlsCellType {
        N,
        D,
        S,
        E;

    }

    public final class MyCellAttr
    implements DbUploadUpdateRunnableMonitorFileProcessor.CellAttr {
        private XlsCellType type;
        private String value;
        private String numberFormat;

        MyCellAttr(XlsCellType type, String value, String numberFormat) {
            this.type = type;
            this.value = value;
            this.numberFormat = numberFormat;
        }

        public String getValue() {
            return this.value;
        }

        public XlsCellType getType() {
            return this.type;
        }

        public String getNumberFormat() {
            return this.numberFormat;
        }

        public String toString() {
            return "value=" + this.value + " type=" + this.type + " numberFormat=" + this.numberFormat;
        }
    }

    public final class MyCellAttrs
    implements DbUploadUpdateRunnableMonitorFileProcessor.CellAttrs {
        private String[] values;
        private DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] cwa;

        MyCellAttrs(String[] values, DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] cwa) {
            this.values = values;
            this.cwa = cwa;
        }

        @Override
        public String[] getValues() {
            return this.values;
        }

        @Override
        public DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] getCellAttr() {
            return this.cwa;
        }
    }
}

