/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jp.jasminesoft.jfc.JFCAppPrincipal;
import jp.jasminesoft.jfc.JFCUserPrincipal;
import jp.jasminesoft.jfc.NoSuchPrincipalException;
import jp.jasminesoft.jfc.NoSuchUserException;
import jp.jasminesoft.jfc.PreferenceInfo;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.preference.Preference;
import jp.jasminesoft.util.JaxbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUserInfo
implements Serializable,
UserInfo {
    static final long serialVersionUID = 2665687634033746253L;
    private static final Logger logger = LogManager.getLogger((String)FileUserInfo.class.getName());
    private Map<String, String> users;
    private Vector<String> principals;
    private Map<String, Vector<String>> user_principal;
    private String default_principal;

    @Override
    public IJuser getJuser(String username) {
        throw new UnsupportedOperationException(username);
    }

    public IJuser getJuserByEMail(String email) {
        throw new UnsupportedOperationException(email);
    }

    @Override
    public void updateJuser(IJuser juser) {
        throw new UnsupportedOperationException(juser.getUserid());
    }

    @Override
    public IJuser getValidJuser(String username) {
        throw new UnsupportedOperationException(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileUserInfo create(String filename) {
        FileUserInfo userinfo = null;
        File f = new File(filename);
        ObjectInputStream p = null;
        try {
            if (f.isFile() && f.canRead()) {
                p = new ObjectInputStream(new FileInputStream(f));
                userinfo = (FileUserInfo)p.readObject();
            }
        }
        catch (IOException e) {
            logger.warn("File " + f + " read error. ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.warn("File " + f + " read error. ", (Throwable)e);
        }
        finally {
            try {
                if (p != null) {
                    p.close();
                }
            }
            catch (IOException e) {}
        }
        if (userinfo == null) {
            userinfo = new FileUserInfo();
            userinfo.init();
            userinfo.setDefaultPrincipal("default");
        }
        return userinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) {
        ObjectOutputStream p = null;
        try {
            p = new ObjectOutputStream(new FileOutputStream(filename));
            p.writeObject(this);
            p.flush();
        }
        catch (IOException e) {
            logger.warn("File " + filename + " write error.");
        }
        finally {
            try {
                if (p != null) {
                    p.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected FileUserInfo() {
    }

    public void init() {
        this.users = new Hashtable<String, String>();
        this.principals = new Vector();
        this.user_principal = new Hashtable<String, Vector<String>>();
    }

    public void setDefaultPrincipal(String principal) {
        this.default_principal = principal;
        this.addPrincipal(principal);
    }

    public String getDefaultPrincipal() {
        return this.default_principal;
    }

    public void addUser(String username, String password) {
        if (username == null || password == null) {
            return;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] input = password.getBytes();
            byte[] result = md.digest(input);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                sb.append(result[i] + 128);
            }
            String md5pass = sb.toString();
            this.users.put(username, md5pass);
            if (this.default_principal != null) {
                this.assignPrincipal(username, this.default_principal);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void removeUser(String username) {
        if (username == null) {
            return;
        }
        this.removeAllPrincipal(username);
        this.users.remove(username);
        this.user_principal.remove(username);
    }

    @Override
    public boolean verifyUser(String username, char[] password) {
        if (username == null || password == null) {
            return false;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String _pass = new String(password);
            byte[] input = _pass.getBytes();
            byte[] result = md.digest(input);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < result.length; ++i) {
                sb.append(result[i] + 128);
            }
            String md5pass = sb.toString();
            if (this.users.containsKey(username) && md5pass.equals(this.users.get(username))) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public void addPrincipal(String principal) {
        if (principal == null) {
            return;
        }
        this.principals.add(principal);
    }

    public void removePrincipal(String principal) {
        if (principal == null) {
            return;
        }
        this.principals.remove(principal);
    }

    public void assignPrincipal(String username, String principal) throws NoSuchPrincipalException {
        if (username == null || principal == null) {
            return;
        }
        boolean matchFlag = false;
        String _principal = null;
        Enumeration<String> e = this.principals.elements();
        while (e.hasMoreElements()) {
            _principal = e.nextElement();
            if (!_principal.equals(principal)) continue;
            matchFlag = true;
            break;
        }
        if (!matchFlag) {
            throw new NoSuchPrincipalException(principal);
        }
        Vector<String> v = this.user_principal.get(username);
        if (v == null) {
            v = new Vector();
            this.user_principal.put(username, v);
        }
        v.add(principal);
    }

    public void removePrincipal(String username, String principal) throws NoSuchUserException {
        if (username == null || principal == null) {
            return;
        }
        if (!this.users.containsKey(username)) {
            throw new NoSuchUserException(username);
        }
        Vector<String> v = this.user_principal.get(username);
        v.removeElement(principal);
    }

    public void removeAllPrincipal(String username) throws NoSuchUserException {
        if (username == null) {
            return;
        }
        if (!this.users.containsKey(username)) {
            throw new NoSuchUserException(username);
        }
        Vector<String> v = this.user_principal.get(username);
        v.removeAllElements();
    }

    public String[] getPrincipalNames(String username) {
        if (username == null) {
            return new String[0];
        }
        if (!this.users.containsKey(username)) {
            throw new NoSuchUserException(username);
        }
        Vector<String> v = this.user_principal.get(username);
        if (v == null) {
            return new String[0];
        }
        String[] ret = v.toArray(new String[0]);
        return ret;
    }

    @Override
    public Principal[] getPrincipals(String username) {
        String[] ret = this.getPrincipalNames(username);
        Principal[] principals = new Principal[ret.length + 1];
        for (int i = 0; i < ret.length; ++i) {
            principals[i] = new JFCAppPrincipal(ret[i]);
        }
        principals[i++] = new JFCUserPrincipal(username);
        return principals;
    }

    @Override
    public String[] getAllUsername() {
        Set<String> keySet = this.users.keySet();
        String[] ret = keySet.toArray(new String[0]);
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FileUserInfo[");
        sb.append("password: ");
        sb.append(this.users);
        sb.append(" principal: ");
        sb.append(this.principals);
        sb.append(" username and principal: ");
        sb.append(this.user_principal);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void close() {
    }

    @Override
    public Preference loadPreference(String username) {
        File file = new File(this.createPreferenceFilename(username));
        Preference preference = null;
        try {
            preference = (Preference)JaxbUtil.unmarshal((File)file, Preference.class);
        }
        catch (Exception e) {
            logger.warn("Preference information load error. username is " + username, (Throwable)e);
        }
        if (preference == null) {
            preference = new Preference();
        }
        preference.setId(username);
        return preference;
    }

    @Override
    public Preference loadPreference(IJuser juser) {
        return this.loadPreference(juser.getUserid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePreference(String username, PreferenceInfo preferenceInfo) {
        Preference preference = preferenceInfo.preference();
        String filename = this.createPreferenceFilename(username);
        String encoding = System.getProperty("file.encoding");
        FileOutputStream ostream = null;
        PrintWriter writer = null;
        try {
            ostream = new FileOutputStream(filename, false);
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)ostream, encoding), true);
            preference.makeTextElement(writer);
        }
        catch (IOException e) {
            logger.error("Failed to output text element", (Throwable)e);
            logger.error((Object)preference);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                } else if (ostream != null) {
                    ostream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void deletePreference(String username) {
    }

    private String createPreferenceFilename(String username) {
        StringBuffer sb = new StringBuffer();
        sb.append(".." + File.separator + "conf" + File.separator);
        sb.append(username);
        sb.append("_pref.xml");
        return sb.toString();
    }

    @Override
    public Permission[] getPermissions(Principal principal) {
        return new Permission[0];
    }

    @Override
    public boolean isSupportLastAccessTime() {
        return false;
    }

    @Override
    public long getLastAccessTime(String username) {
        throw new UnsupportedOperationException(username);
    }

    @Override
    public void setLastAccessTime(String username, long lastaccesstime) {
        throw new UnsupportedOperationException(username);
    }

    @Override
    public void updatePasswdChangeFlag(IJuser juser) {
    }
}

