/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.FilenameListDeleteMode;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.jfc.app.CreateObjectHelper;
import jp.jasminesoft.util.MultiPartForm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilenameList
implements Releasable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(FilenameList.class);
    private static FilenameListDeleteMode DEFAULT_DELETE_TARGET_MODE = FilenameListDeleteMode.SendFileOnly;
    public static final String JFCFILESTATUS_HEADER = "jfcfilestatus:";
    private FilenameListDeleteMode delete_target_mode;
    private String id;
    private List<String> srcfilenamelist = new ArrayList<String>();
    private List<File> sendfilenamelist = new ArrayList<File>();
    private Map<String, Object[]> srcfilenamemap = new LinkedHashMap<String, Object[]>();
    private Map<String, Object[]> contentsmap = new HashMap<String, Object[]>();

    public static FilenameList create(String id) {
        return FilenameList.create(id, null);
    }

    public static FilenameList create(String id, FilenameListDeleteMode delete_target_mode) {
        return new FilenameList(id, delete_target_mode);
    }

    private FilenameList(String id, FilenameListDeleteMode delete_target_mode) {
        this.id = id;
        if (delete_target_mode == null) {
            delete_target_mode = DEFAULT_DELETE_TARGET_MODE;
        }
        this.delete_target_mode = delete_target_mode;
    }

    public static void setDefaultDeleteTargetMode(FilenameListDeleteMode delete_target_mode) {
        DEFAULT_DELETE_TARGET_MODE = delete_target_mode;
    }

    public static FilenameListDeleteMode getDefaultDeleteTargetMode() {
        return DEFAULT_DELETE_TARGET_MODE;
    }

    public synchronized void addSrcFilenameList(List<String> srcfilenamelist) {
        this.srcfilenamelist.addAll(srcfilenamelist);
    }

    public synchronized void addSendFilenameList(List<File> sendfilenamelist) {
        this.sendfilenamelist.addAll(sendfilenamelist);
    }

    public synchronized Map<String, Object[]> addSendFilename(ActionParameter p, MultiPartForm multi) {
        this.addSendFilenameList(multi.getFileList());
        Iterator it = multi.getParameterList().iterator();
        LinkedHashMap<String, Object[]> map = new LinkedHashMap<String, Object[]>();
        HashMap<String, Object[]> map_jshfilename = new HashMap<String, Object[]>();
        HashSet<String> processedkeys = new HashSet<String>();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.startsWith("action_")) continue;
            if (key.equals("uploadType")) {
                Object[] contentsList = multi.getContentsList(key);
                if (contentsList == null || contentsList.length <= 0) continue;
                logger.debug("uploadType: " + contentsList[0]);
                continue;
            }
            String key1 = key;
            if (key.endsWith("s[]")) {
                key1 = key.substring(0, key.length() - 3);
            }
            if (processedkeys.contains(key1)) continue;
            processedkeys.add(key1);
            String[] filenamelist = multi.getSrcFilenameList(key);
            if (filenamelist != null) {
                Object[] files = multi.getContentsList(key);
                if (filenamelist.length == 0 || files.length == 0 || !(files[0] instanceof File) || !map.containsKey(key1) && this.checkFile(p, filenamelist, files, key1)) continue;
                map.put(key1, filenamelist);
                map_jshfilename.put(key1, files);
                continue;
            }
            map.put(key1, multi.getContentsList(key));
        }
        this.srcfilenamemap.putAll(map);
        this.contentsmap.putAll(map_jshfilename);
        return map;
    }

    public boolean checkFile(ActionParameter p, String[] fname, Object[] file, String key) {
        return CreateObjectHelper.checkFile(p, fname, file, this.id, key);
    }

    public synchronized List<Map<String, Object>> getSrcFilenameJsonObj(Set<String> keyset) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (keyset == null) {
            keyset = this.srcfilenamemap.keySet();
        }
        for (String k : keyset) {
            Object[] va = this.srcfilenamemap.get(k);
            if (va == null) continue;
            Object[] va2 = this.contentsmap.get(k);
            for (int i = 0; i < va.length; ++i) {
                Object v = va[i];
                Object v2 = null;
                if (va2 != null && i < va2.length) {
                    v2 = va2[i];
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("file", v);
                map.put("name", v);
                map.put("size", this.getFileSize(v, v2));
                list.add(map);
            }
        }
        return list;
    }

    public synchronized String getSrcFilenameJson(Set<String> keyset) {
        if (keyset == null) {
            keyset = this.srcfilenamemap.keySet();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isfirst = true;
        for (String k : keyset) {
            Object[] va = this.srcfilenamemap.get(k);
            if (va == null) continue;
            Object[] va2 = this.contentsmap.get(k);
            for (int i = 0; i < va.length; ++i) {
                Object v = va[i];
                Object v2 = null;
                if (va2 != null && i < va2.length) {
                    v2 = va2[i];
                }
                if (!isfirst) {
                    sb.append(",");
                } else {
                    isfirst = false;
                }
                String fn = v.toString().replace("\"", "\\\"");
                sb.append("{\"file\":\"");
                sb.append(fn);
                sb.append("\",\"name\":\"");
                sb.append(fn);
                sb.append("\",\"size\":");
                sb.append(this.getFileSize(v, v2));
                sb.append("}");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private long getFileSize(Object filename, Object jshfilename) {
        File file;
        if (jshfilename instanceof String) {
            file = new File((String)jshfilename);
        } else if (jshfilename instanceof File) {
            file = (File)jshfilename;
        } else {
            return 0L;
        }
        return file.length();
    }

    public synchronized Object[] getSrcFilename() {
        return this.srcfilenamelist.toArray(new Object[0]);
    }

    public synchronized Object[] getSendFilename() {
        return this.sendfilenamelist.toArray(new Object[0]);
    }

    public synchronized Map<String, Object[]> getSrcFilenameMap() {
        return this.srcfilenamemap;
    }

    public synchronized Map<String, Object[]> getContentsMap() {
        return this.contentsmap;
    }

    public synchronized void removeParameter(String key) {
        this.srcfilenamemap.remove(key);
        this.contentsmap.remove(key);
    }

    public synchronized void deleteSendFilenameList() {
        if (logger.isDebugEnabled()) {
            logger.debug("deleteSendFilenameList");
            logger.debug("srcfilenamelist=" + this.srcfilenamelist);
            logger.debug("sendfilenamelist=" + this.sendfilenamelist);
        }
        List<File> sendfilenamelist = this.sendfilenamelist;
        this.sendfilenamelist = new ArrayList<File>();
        FilenameList._deleteFilenameList(sendfilenamelist);
    }

    public synchronized void deleteUnsavedFilenameList(List<String> savefilenamelist) {
        if (logger.isDebugEnabled()) {
            logger.debug("deleteUnsavedFilenameList " + savefilenamelist);
            logger.debug("srcfilenamelist=" + this.srcfilenamelist);
            logger.debug("sendfilenamelist=" + this.sendfilenamelist);
        }
        List<String> srcfilenamelist = this.srcfilenamelist;
        this.srcfilenamelist = new ArrayList<String>();
        List<File> sendfilenamelist = this.sendfilenamelist;
        this.sendfilenamelist = new ArrayList<File>();
        this.srcfilenamemap = new HashMap<String, Object[]>();
        this.contentsmap = new HashMap<String, Object[]>();
        HashSet<File> deletefilenamelist = new HashSet<File>();
        if (this.delete_target_mode == FilenameListDeleteMode.SendFileOnly) {
            deletefilenamelist.addAll(sendfilenamelist);
        } else if (this.delete_target_mode == FilenameListDeleteMode.UnsavedFile) {
            deletefilenamelist.addAll(srcfilenamelist.stream().filter(fn -> !fn.startsWith(JFCFILESTATUS_HEADER)).map(fn -> new File((String)fn)).collect(Collectors.toList()));
            deletefilenamelist.addAll(sendfilenamelist);
        }
        deletefilenamelist.removeAll(savefilenamelist.stream().filter(fn -> !fn.startsWith(JFCFILESTATUS_HEADER)).map(fn -> new File((String)fn)).collect(Collectors.toList()));
        FilenameList._deleteFilenameList(deletefilenamelist);
    }

    public void deleteFilenameList(Collection<String> srcfilenamelist) {
        if (this.delete_target_mode == FilenameListDeleteMode.UnsavedFile) {
            List<File> list = srcfilenamelist.stream().filter(fn -> !fn.startsWith(JFCFILESTATUS_HEADER)).map(fn -> new File((String)fn)).collect(Collectors.toList());
            FilenameList._deleteFilenameList(list);
        }
    }

    private static void _deleteFilenameList(Collection<File> col) {
        for (File f : col) {
            logger.info("file " + f);
            if (!f.delete()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("failed delete " + f);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("delete " + f);
        }
    }

    @Override
    public void release() {
        this.deleteSendFilenameList();
    }
}

