/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.PropertyManager;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.core.util.LineSeparator;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.util.ScriptStringFilter;
import jp.jasminesoft.util.StringEmptyFilter;
import jp.jasminesoft.util.StringFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class FilterManager {
    private static final Logger logger = LogManager.getLogger((String)FilterManager.class.getName());
    private static final String SCRIPTFILENAME = "__filter.js";
    private ScriptEngine engine;
    private Boolean useFilterScript;
    private Long o_lastmodified;
    private static String engineName = null;
    protected Map<String, StringFilter> filterlistMap = new HashMap<String, StringFilter>();

    public FilterManager() {
        this.init();
    }

    public ActionParameterContainer getActionParameterContainer() {
        return null;
    }

    protected synchronized void initScript() {
        if (this.useFilterScript != null && !this.useFilterScript.booleanValue()) {
            return;
        }
        ActionParameter p = this.getActionParameterContainer().get();
        if (p == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("action parameter is null.");
            }
            return;
        }
        ResourceLoader resloader = (ResourceLoader)p.request.getAttribute("__jfc_script_fileresloader");
        Resource res = null;
        if (resloader != null) {
            res = resloader.getResource("WEB-INF/script/__filter.js");
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("resouce loader is null. use fix path.");
            }
            res = new FileSystemResourceLoader().getResource("../webapps/wagby/WEB-INF/script/__filter.js");
        }
        if (res == null || !res.isFile() || !res.isReadable()) {
            this.useFilterScript = false;
            return;
        }
        long lastmodified = 0L;
        try {
            lastmodified = res.lastModified();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.o_lastmodified != null && lastmodified == this.o_lastmodified) {
            return;
        }
        this.o_lastmodified = lastmodified;
        String code = this.readSourceCode(res);
        if (StringUtils.isEmpty((CharSequence)code)) {
            this.useFilterScript = false;
            return;
        }
        if (this.engine == null) {
            ScriptEngineManager manager = new ScriptEngineManager();
            if ("nashorn".equals(engineName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Use Nashorn as JavaScript engine.");
                }
                this.engine = manager.getEngineByName("JavaScript");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Use " + engineName + " as JavaScript engine.");
                }
                this.engine = manager.getEngineByName(engineName);
                try {
                    this.engine.eval("load('nashorn:mozilla_compat.js')");
                }
                catch (ScriptException e) {
                    logger.warn("mozilla_compat.js is not loaded.", (Throwable)e);
                }
            }
            this.engine.put("__jfc_script_engine_filename", SCRIPTFILENAME);
            this.engine.put("filterlistMap", this.filterlistMap);
        }
        try {
            this.engine.eval(code);
        }
        catch (ScriptException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.filterlistMap.put("scriptfilter1", (StringFilter)new ScriptStringFilter(null, "filter1", this.engine));
        this.filterlistMap.put("scriptfilter2", (StringFilter)new ScriptStringFilter(null, "filter2", this.engine));
        this.filterlistMap.put("scriptfilter3", (StringFilter)new ScriptStringFilter(null, "filter3", this.engine));
        this.filterlistMap.put("scriptfilter4", (StringFilter)new ScriptStringFilter(null, "filter4", this.engine));
        this.filterlistMap.put("scriptfilter5", (StringFilter)new ScriptStringFilter(null, "filter5", this.engine));
        this.filterlistMap.put("scriptfilter6", (StringFilter)new ScriptStringFilter(null, "filter6", this.engine));
        this.filterlistMap.put("scriptfilter7", (StringFilter)new ScriptStringFilter(null, "filter7", this.engine));
        this.filterlistMap.put("scriptfilter8", (StringFilter)new ScriptStringFilter(null, "filter8", this.engine));
        this.filterlistMap.put("scriptfilter9", (StringFilter)new ScriptStringFilter(null, "filter9", this.engine));
        this.filterlistMap.put("scriptfilter10", (StringFilter)new ScriptStringFilter(null, "filter10", this.engine));
        this.useFilterScript = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSourceCode(Resource file) {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(file.getInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append((Object)LineSeparator.SYSTEM);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    protected void init() {
    }

    public StringFilter getFilter(String name) {
        StringFilter filter;
        if (this.useFilterScript == null || this.useFilterScript.booleanValue() && ScriptCodeRunner.isReloadable()) {
            this.initScript();
        }
        if ((filter = this.filterlistMap.get(name)) == null) {
            filter = new StringEmptyFilter();
        }
        return filter;
    }

    public String filter(PropertyMetaBase<?> meta, String value) {
        return this.getFilter(meta).filter(value);
    }

    protected StringFilter getFilter(PropertyMetaBase<?> meta) {
        return this.getFilter(meta.filterName());
    }

    public Collection<String> filter(MultiPropertyMeta<?> meta, Collection<String> values) {
        StringFilter filter = this.getFilter(meta);
        return values.stream().map(value -> filter.filter(value)).collect(Collectors.toList());
    }

    static {
        String EngineName = PropertyManager.getProperty("jp.jasminesoft.jfc.ScriptCodeRunner.engineName");
        if (EngineName != null && EngineName.length() > 0) {
            engineName = EngineName;
        }
        if (engineName == null) {
            engineName = "nashorn";
        }
    }
}

