/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizeitem;
import jp.jasminesoft.jfc.model.fontsizelist.Fontsizelist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class FontsizeFileManager {
    private Map<String, Fontsizelist> fontsizeMap;
    private Logger logger = LogManager.getLogger((String)FontsizeFileManager.class.getName());
    public static final String DEFAULT_FONTSIZEFILENAME = "fontsize_m";
    final String LARGE = "LARGE";
    final String MEDIUM = "MEDIUM";
    final String SMALL = "SMALL";

    public FontsizeFileManager() {
        this.fontsizeMap = new HashMap<String, Fontsizelist>();
    }

    @PostConstruct
    public void init() {
    }

    private Fontsizelist init(ActionParameter p) {
        this.init0(p);
        return this.fontsizeMap.get(p.locale);
    }

    private synchronized void init0(ActionParameter p) {
        ResourceBundle rb = JFCUtils.getResourceBundleInLocaleStrings(p.locale);
        if (rb == null) {
            this.logger.log(LogCodeManager.getPriority(LogCode.JFC00201), LogCodeManager.getMessage(LogCode.JFC00201, "resource '" + p.locale + "'"));
            return;
        }
        String small = null;
        String medium = null;
        String large = null;
        try {
            small = rb.getString("__jfc_common.preference.select.fontsize.small");
        }
        catch (MissingResourceException e) {
            small = "SMALL";
        }
        try {
            medium = rb.getString("__jfc_common.preference.select.fontsize.medium");
        }
        catch (MissingResourceException e) {
            medium = "MEDIUM";
        }
        try {
            large = rb.getString("__jfc_common.preference.select.fontsize.large");
        }
        catch (MissingResourceException e) {
            large = "LARGE";
        }
        Fontsizelist fontsizelist = new Fontsizelist();
        Fontsizeitem f_large = new Fontsizeitem();
        f_large.setName(large);
        f_large.setContent("fontsize_l");
        fontsizelist.addFontsizeitem(f_large);
        Fontsizeitem f_medium = new Fontsizeitem();
        f_medium.setName(medium);
        f_medium.setContent(DEFAULT_FONTSIZEFILENAME);
        f_medium.setStandard(true);
        fontsizelist.addFontsizeitem(f_medium);
        Fontsizeitem f_small = new Fontsizeitem();
        f_small.setName(small);
        f_small.setContent("fontsize_s");
        fontsizelist.addFontsizeitem(f_small);
        this.fontsizeMap.put(p.locale, fontsizelist);
    }

    public Fontsizelist getFontsizelist(ActionParameter p) {
        Fontsizelist fontsizelist = this.fontsizeMap.get(p.locale);
        if (fontsizelist == null) {
            fontsizelist = this.init(p);
        }
        return fontsizelist;
    }

    public String getStandardFontsizeFilename(ActionParameter p) {
        Fontsizeitem[] items;
        String ret = null;
        Fontsizelist fontsizelist = this.fontsizeMap.get(p.locale);
        if (fontsizelist == null) {
            fontsizelist = this.init(p);
        }
        Fontsizeitem[] fontsizeitemArray = items = fontsizelist != null ? fontsizelist.getFontsizeitem() : null;
        if (items != null) {
            for (Fontsizeitem item : items) {
                if (!item.getStandard()) continue;
                ret = item.getContent();
                break;
            }
        }
        if (ret == null) {
            ret = DEFAULT_FONTSIZEFILENAME;
        }
        return ret;
    }

    public boolean exists(String fontsizefilename, ActionParameter p) {
        Fontsizeitem[] items;
        Fontsizelist fontsizelist = this.fontsizeMap.get(p.locale);
        if (fontsizelist == null) {
            fontsizelist = this.init(p);
        }
        Fontsizeitem[] fontsizeitemArray = items = fontsizelist != null ? fontsizelist.getFontsizeitem() : null;
        if (items == null || fontsizefilename == null) {
            return false;
        }
        boolean ret = false;
        for (Fontsizeitem item : items) {
            if (!fontsizefilename.equals(item.getContent())) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

