/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;

public class JFCJobTriggerListener
implements TriggerListener {
    private static final Logger logger = LogManager.getLogger((String)JFCJobTriggerListener.class.getName());
    private Map<String, Boolean> runningJobSet = new ConcurrentHashMap<String, Boolean>();

    public String getName() {
        return "JFCJobTriggerListener";
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction instruction) {
        Object status;
        String name = context.getJobDetail().getKey().getName();
        this.runningJobSet.remove(name);
        if (logger.isDebugEnabled()) {
            TriggerKey key = trigger.getKey();
            logger.debug("complete  jobdetail:" + name + " trigger:" + key.getName() + ":" + key.getGroup());
        }
        if ((status = context.get((Object)"jobComplete")) != null && status instanceof Boolean) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00900), LogCodeManager.getMessage(LogCode.JFC00900, name));
        } else {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00901), LogCodeManager.getMessage(LogCode.JFC00901, name));
        }
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        String name = context.getJobDetail().getKey().getName();
        logger.log(LogCodeManager.getPriority(LogCode.JFC00902), LogCodeManager.getMessage(LogCode.JFC00902, name));
        if (logger.isDebugEnabled()) {
            TriggerKey key = trigger.getKey();
            logger.debug("fired  jobdetail:" + name + " trigger:" + key.getName() + ":" + key.getGroup());
        }
    }

    public void triggerMisfired(Trigger trigger) {
        if (logger.isDebugEnabled()) {
            TriggerKey key = trigger.getKey();
            logger.debug("misfired  trigger:" + key.getName() + ":" + key.getGroup());
        }
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        String name = context.getJobDetail().getKey().getName();
        if (logger.isDebugEnabled()) {
            TriggerKey key = trigger.getKey();
            logger.debug("vetoJobExecution " + this.runningJobSet.containsKey(name) + " jobdetail:" + name + " trigger:" + key.getName() + ":" + key.getGroup());
        }
        if (this.runningJobSet.putIfAbsent(name, Boolean.TRUE) != null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00903), LogCodeManager.getMessage(LogCode.JFC00903, name));
            return true;
        }
        return false;
    }
}

