/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCQuartzJobManagerBase;
import jp.jasminesoft.jfc.model.jfcjobschedule.IJfcjobschedule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsTemplate;

public class JFCQuartzJobManagerBaseV1
extends JFCQuartzJobManagerBase {
    protected static final String NOT_SEND_KEY = JFCQuartzJobManagerBase.class.getName() + "_notsend";
    private static final Logger logger = LogManager.getLogger((String)JFCQuartzJobManagerBaseV1.class.getName());
    @Autowired(required=false)
    @Qualifier(value="topicJmsTemplate")
    protected JmsTemplate topicJmsTemplate;
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler sched;
    @Autowired(required=false)
    @Qualifier(value="schedulerRAM")
    private Scheduler schedRAM;
    private String scheduleRAMJobTopicName;
    private String scheduleJobNowTopicName;

    public void setScheduleRAMJobTopicName(String topicName) {
        this.scheduleRAMJobTopicName = topicName;
    }

    public String getScheduleRAMJobTopicName() {
        return this.scheduleRAMJobTopicName;
    }

    public void setScheduleJobNowTopicName(String topicName) {
        this.scheduleJobNowTopicName = topicName;
    }

    public String getScheduleJobNowTopicName() {
        return this.scheduleJobNowTopicName;
    }

    @Override
    public void scheduleAllJob() {
        List<IJfcjobschedule> list = this.getAllJob();
        this.unscheduleJob(this.sched);
        if (this.schedRAM != null) {
            this.unscheduleJob(this.schedRAM);
        }
        this.scheduleJob(list);
    }

    @Override
    public void updateJobAll() {
        if (this.schedRAM == null) {
            this.scheduleAllJob();
            return;
        }
        this.scheduleJDBCJob();
        this.sendScheduleRAMJobMessage();
    }

    private void scheduleJDBCJob() {
        List<IJfcjobschedule> list = this.getJDBCJob();
        this.unscheduleJob(this.sched);
        this.scheduleJob(list);
    }

    @Override
    public void scheduleRAMJob() {
        if (this.schedRAM == null) {
            return;
        }
        List<IJfcjobschedule> list = this.getRAMJob();
        this.unscheduleJob(this.schedRAM);
        this.scheduleJob(list);
    }

    protected Scheduler getSchedulerForJobschedule(IJfcjobschedule schedule) {
        String exectype = schedule.getExectype();
        if (exectype == null) {
            return this.sched;
        }
        if (this.schedRAM == null) {
            return this.sched;
        }
        if (exectype.equals("all")) {
            return this.schedRAM;
        }
        if (exectype.equals("one") || exectype.equals("domain")) {
            return this.sched;
        }
        logger.error("Unknown jfcjobschedule exec type. " + schedule);
        throw new IllegalStateException();
    }

    @Override
    public void initializeScheduler() {
        this.addJFCJobTriggerListener(this.sched);
        this.fireInitializeScheduler(this.sched, 1);
        if (this.schedRAM != null) {
            this.addJFCJobTriggerListener(this.schedRAM);
            this.fireInitializeScheduler(this.schedRAM, 2);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("jobmanager.process");
        }
        try {
            this.scheduleAllJob();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void scheduleJob(Collection<IJfcjobschedule> jfcjobschedule_ary) {
        Map<String, IJfcjobschedule> jmap = this.createJobscheduleMap(jfcjobschedule_ary);
        this.scheduleJobs(jmap);
    }

    protected void scheduleJobs(Map<String, IJfcjobschedule> jmap) {
        HashMap<JobDetail, Set<? extends Trigger>> map_sched = new HashMap<JobDetail, Set<? extends Trigger>>();
        HashMap<JobDetail, Set<? extends Trigger>> map_schedRAM = new HashMap<JobDetail, Set<? extends Trigger>>();
        for (String jobName : jmap.keySet()) {
            IJfcjobschedule schedule = jmap.get(jobName);
            if (this.schedRAM == null) {
                this.addJobDetail(map_sched, jobName, schedule);
                continue;
            }
            String exectype = schedule.getExectype();
            if (exectype == null) {
                exectype = "one";
            }
            if (exectype.equals("all")) {
                this.addJobDetail(map_schedRAM, jobName, schedule);
                continue;
            }
            if (!exectype.equals("one") && !exectype.equals("domain")) continue;
            this.addJobDetail(map_sched, jobName, schedule);
        }
        try {
            if (map_sched.size() > 0) {
                this.sched.scheduleJobs(map_sched, true);
            }
            if (this.schedRAM != null && map_schedRAM.size() > 0) {
                this.schedRAM.scheduleJobs(map_schedRAM, true);
            }
            logger.info("Jobs is successfully registerd.");
        }
        catch (Exception e) {
            logger.error("Jobs cannot be registered. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void scheduleJobNow(ActionParameter p, IJfcjobschedule schedule) {
        String exectype = schedule.getExectype();
        if (exectype == null) {
            exectype = "one";
        }
        if (exectype.equals("all") && this.getJobparam(schedule, NOT_SEND_KEY) == null) {
            IJfcjobschedule newjfcjobschedule = (IJfcjobschedule)schedule.clone();
            this.addJobparam(newjfcjobschedule, NOT_SEND_KEY, Boolean.TRUE.toString());
            this.sendScheduleJobNowMessage(newjfcjobschedule);
            return;
        }
        Scheduler sched = this.getSchedulerForJobschedule(schedule);
        if (sched == null) {
            return;
        }
        this.scheduleJobNow(p, schedule, sched);
    }

    @Override
    public void scheduleDomainJob() {
    }

    public void sendScheduleRAMJobMessage() {
        if (logger.isDebugEnabled()) {
            logger.debug("send message");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("cmd", "scheduleRAMJob");
        this.topicJmsTemplate.convertAndSend(this.getScheduleRAMJobTopicName(), param);
    }

    public void sendScheduleJobNowMessage(IJfcjobschedule schedule) {
        if (logger.isDebugEnabled()) {
            logger.debug("send message");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("cmd", "scheduleJobNow");
        param.put("msg", schedule);
        this.topicJmsTemplate.convertAndSend(this.getScheduleJobNowTopicName(), param);
    }

    @Override
    protected void shutdownScheduler() {
        if (this.sched != null) {
            try {
                this.sched.shutdown(true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.schedRAM != null) {
            try {
                this.schedRAM.shutdown(true);
            }
            catch (SchedulerException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

