/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCQuartzJobManagerBase;
import jp.jasminesoft.jfc.model.jfcjobschedule.IJfcjobschedule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class JFCQuartzJobManagerBaseV2RAM
extends JFCQuartzJobManagerBase {
    private static final Logger logger = LogManager.getLogger((String)JFCQuartzJobManagerBaseV2RAM.class.getName());
    @Autowired(required=false)
    @Qualifier(value="scheduler")
    private Scheduler sched;

    @Override
    public void scheduleAllJob() {
        List<IJfcjobschedule> list = this.getAllJob();
        this.unscheduleJob(this.sched);
        this.scheduleJob(list);
    }

    @Override
    public void updateJobAll() {
        this.scheduleAllJob();
    }

    @Override
    public void scheduleRAMJob() {
    }

    @Override
    public void initializeScheduler() {
        this.addJFCJobTriggerListener(this.sched);
        this.fireInitializeScheduler(this.sched, 1);
        logger.info("jobmanager.process");
        try {
            this.scheduleAllJob();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void scheduleJob(Collection<IJfcjobschedule> jfcjobschedule_ary) {
        Map<String, IJfcjobschedule> jmap = this.createJobscheduleMap(jfcjobschedule_ary);
        this.scheduleJobs(jmap);
    }

    protected void scheduleJobs(Map<String, IJfcjobschedule> jmap) {
        HashMap<JobDetail, Set<? extends Trigger>> map1 = new HashMap<JobDetail, Set<? extends Trigger>>();
        for (String jobName : jmap.keySet()) {
            IJfcjobschedule schedule = jmap.get(jobName);
            this.addJobDetail(map1, jobName, schedule);
        }
        try {
            this.sched.scheduleJobs(map1, true);
            logger.info("Jobs is successfully registerd.");
        }
        catch (Exception e) {
            logger.error("Jobs cannot be registered. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void scheduleJobNow(ActionParameter p, IJfcjobschedule schedule) {
        this.scheduleJobNow(p, schedule, this.sched);
    }

    @Override
    public void scheduleDomainJob() {
    }

    @Override
    protected void shutdownScheduler() {
        if (this.sched == null) {
            return;
        }
        try {
            this.sched.shutdown(true);
        }
        catch (SchedulerException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

