/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockObject;
import jp.jasminesoft.jfc.LockObjectItem;
import jp.jasminesoft.jfc.User;

public class LockObjectImpl
implements LockObject,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String modelname;
    protected Object pkey;
    protected String username;
    protected String sessionid;
    protected boolean lockForAll;
    protected LockObjectItem[] items;

    public LockObjectImpl(String modelname, Object pkey, String sessionid, User user, boolean lockForAll, LockObjectItem[] items) {
        this.modelname = modelname;
        this.pkey = pkey instanceof String ? JFCUtils.decodePrimaryKey((String)pkey) : pkey;
        this.sessionid = sessionid;
        this.lockForAll = lockForAll;
        this.items = items;
        this.username = user != null ? user.getUsername() : "(unknown)";
    }

    public LockObjectImpl(String modelname, Object pkey, String sessionid, String username, boolean lockForAll, LockObjectItem[] items) {
        this.modelname = modelname;
        this.pkey = pkey instanceof String ? JFCUtils.decodePrimaryKey((String)pkey) : pkey;
        this.sessionid = sessionid;
        this.lockForAll = lockForAll;
        this.items = items;
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getSessionId() {
        return this.sessionid;
    }

    @Override
    public String getModelname() {
        return this.modelname;
    }

    @Override
    public Object getPrimaryKey() {
        return this.pkey;
    }

    @Override
    public boolean isLockForAll() {
        return this.lockForAll;
    }

    @Override
    public LockObjectItem[] getItems() {
        return this.items;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LockObject)) {
            return false;
        }
        LockObject ao = (LockObject)o;
        if (!this.getSessionId().equals(ao.getSessionId())) {
            return false;
        }
        HashSet<LockObjectItem> set = new HashSet<LockObjectItem>();
        set.addAll(Arrays.asList(ao.getItems()));
        for (LockObjectItem item1 : this.getItems()) {
            if (set.contains(item1)) continue;
            return false;
        }
        return true;
    }
}

