/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManagerImpl;
import jp.jasminesoft.jfc.LockSingleObject;
import jp.jasminesoft.jfc.User;

public class LockSingleObjectImpl
implements Serializable,
LockSingleObject {
    private static final long serialVersionUID = 1L;
    protected String lockname;
    protected Object lockdatakey;
    protected String username;
    protected String sessionid;
    protected boolean lockForAll;

    public LockSingleObjectImpl(String lockname, Object lockdatakey, String sessionid, User user, boolean lockForAll) {
        this.lockname = lockname;
        this.lockdatakey = lockdatakey instanceof String ? JFCUtils.decodePrimaryKey((String)lockdatakey) : lockdatakey;
        this.sessionid = sessionid;
        this.lockForAll = lockForAll;
        this.username = user != null ? user.getUsername() : "(unknown)";
    }

    public LockSingleObjectImpl(String lockname, Object lockdatakey, String sessionid, String username, boolean lockForAll) {
        this.lockname = lockname;
        this.lockdatakey = lockdatakey instanceof String ? JFCUtils.decodePrimaryKey((String)lockdatakey) : lockdatakey;
        this.sessionid = sessionid;
        this.lockForAll = lockForAll;
        this.username = username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getSessionId() {
        return this.sessionid;
    }

    @Override
    public String getKey() {
        StringBuffer buf = new StringBuffer(this.lockname);
        Object pkey = this.getLockDataKey();
        if (pkey == null) {
            return buf.toString();
        }
        if (pkey instanceof Object[]) {
            Object[] pkeys = (Object[])pkey;
            for (int i = 0; i < pkeys.length; ++i) {
                buf.append(pkeys[i]);
                if (i + 1 >= pkeys.length) continue;
                buf.append("$");
            }
        } else {
            buf.append(pkey);
        }
        return buf.toString();
    }

    @Override
    public String getLockName() {
        return this.lockname;
    }

    @Override
    public Object getLockDataKey() {
        return this.lockdatakey;
    }

    @Override
    public boolean isLockForAll() {
        return this.lockForAll;
    }

    @Override
    public String getFullKey() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getKey());
        sb.append("@");
        sb.append(this.getSessionId());
        return sb.toString();
    }

    public String getFullKey0() {
        return this.getKey();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LockSingleObjectImpl)) {
            return false;
        }
        LockSingleObjectImpl ao = (LockSingleObjectImpl)o;
        if (!this.getLockName().equals(ao.getLockName())) {
            return false;
        }
        if (!this.getSessionId().equals(ao.getSessionId())) {
            return false;
        }
        if (this.isLockForAll() != ao.isLockForAll()) {
            return false;
        }
        return LockManagerImpl.equalsPrimaryKey(this.getLockDataKey(), ao.getLockDataKey());
    }

    public int hashCode() {
        int sum = 0;
        sum += this.getLockName().hashCode();
        sum += this.getSessionId().hashCode();
        sum += this.isLockForAll() ? 1 : 0;
        return sum += LockManagerImpl.hashCodePrimaryKey(this.getLockDataKey());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[");
        sb.append(this.getFullKey());
        sb.append(":");
        sb.append(this.getUsername());
        if (this.isLockForAll()) {
            sb.append(":lockForAll");
        }
        sb.append("]");
        return sb.toString();
    }
}

