/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.model.pankuzu.Item;
import jp.jasminesoft.jfc.model.pankuzu.Pankuzu;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class PankuzuManager
implements Serializable {
    private static final boolean debug = false;
    private List<PankuzuNode> list;
    private static final String LOGON_URL = "/logon.do";
    private static final String LOGOFF_URL = "/logoff.do";
    private static final String AUTO_LOGOFF_URL = "/autoLogoff.do";
    private static final String MENU_URL = "mainMenu.do";
    private static final String NO_DATA = "noData.do";
    private static final String SHOWLIST_URL = "/showList";
    private static final String UPDATE_URL = "/update";
    private static final String INSERT_URL = "/insert";
    Set<String> ignore_pankuzu_set = new HashSet<String>();
    private String jspEncoding;
    private static final String[] DELETE_URL_HEADERS = new String[]{"delete", "myDelete", "physicalDelete"};

    @Autowired
    public void setJfcConfig(JfcConfig jfcConfig1) {
        this.jspEncoding = jfcConfig1.getJspEncoding();
        String[] ignore_pankuzu = jfcConfig1.getIgnorePankuzu();
        if (ignore_pankuzu != null) {
            for (int i = 0; i < ignore_pankuzu.length; ++i) {
                this.ignore_pankuzu_set.add(ignore_pankuzu[i]);
            }
        }
    }

    public String getJspEncoding() {
        return this.jspEncoding;
    }

    public PankuzuManager() {
        this.init();
    }

    private void init() {
        this.list = new LinkedList<PankuzuNode>();
    }

    public boolean isIgnorePankuzu(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        String last_token_url = StringUtil.lastToken((String)url, (String)"/");
        return this.ignore_pankuzu_set.contains(last_token_url);
    }

    private String getDeleteUrlHeader(String url) {
        if (url == null) {
            return null;
        }
        for (String h : DELETE_URL_HEADERS) {
            if (!url.startsWith(h)) continue;
            return h;
        }
        return null;
    }

    public void addPankuzuNode(PankuzuNode pnode) {
        if (pnode == null || pnode.getTitle() == null && pnode.getUrl() == null) {
            return;
        }
        if (pnode.isResetPankuzu()) {
            this.init();
            this.list.add(pnode);
            return;
        }
        LinkedList<PankuzuNode> n_list = new LinkedList<PankuzuNode>(this.list);
        int size = n_list.size();
        PankuzuNode node = null;
        int pos = -1;
        String title = pnode.getTitle();
        String url = pnode.getUrl();
        String deleteUrlHeader = this.getDeleteUrlHeader(url);
        for (int i = size - 1; i >= 0; --i) {
            node = (PankuzuNode)n_list.get(i);
            if (deleteUrlHeader != null) {
                String repurl = "show" + url.substring(deleteUrlHeader.length());
                if (node.getUrl() == null || !node.getUrl().startsWith(repurl)) continue;
                pos = i;
                break;
            }
            String titled = node.getTitle();
            if (title == null || titled == null || !title.equals(titled)) continue;
            pos = i;
            break;
        }
        if (pos >= 0) {
            if (deleteUrlHeader != null) {
                --size;
                while (size >= pos) {
                    n_list.remove(size);
                    --size;
                }
            } else {
                n_list.remove(pos);
            }
        }
        ArrayList<Integer> removeIndex = new ArrayList<Integer>();
        for (int i = 0; i < n_list.size(); ++i) {
            PankuzuNode pn = (PankuzuNode)n_list.get(i);
            if (pn.getUrl() != null) continue;
            removeIndex.add(i);
        }
        if (removeIndex.size() > 0) {
            Collections.reverse(removeIndex);
            for (Integer idx : removeIndex) {
                n_list.remove(idx);
            }
        }
        if (url == null || deleteUrlHeader == null && !url.equals("userPreference") && !this.isIgnorePankuzu(url)) {
            if (url != null && (url.startsWith("insert") || url.startsWith("copy") || url.startsWith("update") || url.startsWith("updateList") || url.startsWith("myInsert") || url.startsWith("myCopy") || url.startsWith("myUpdate") || url.startsWith("myUpdateList"))) {
                pnode.clearUrl();
                n_list.add(pnode);
            } else {
                n_list.add(pnode);
            }
        }
        this.list = n_list;
    }

    public void setLinkinfo(String title, HttpServletRequest request) {
        Object url = null;
        String _cp = request.getContextPath();
        url = _cp.equals("/") ? request.getServletPath() : _cp + request.getServletPath();
        if (((String)url).indexOf(LOGOFF_URL) >= 0 || ((String)url).indexOf(AUTO_LOGOFF_URL) >= 0 || ((String)url).indexOf(LOGON_URL) >= 0) {
            this.init();
            return;
        }
        HashMap<String, String> paramMap = null;
        boolean ignoreFlag = false;
        if (this.isIgnorePankuzu((String)url)) {
            ignoreFlag = true;
        } else if (((String)url).indexOf(UPDATE_URL) >= 0 || ((String)url).indexOf(INSERT_URL) >= 0 || ((String)url).indexOf(NO_DATA) >= 0) {
            url = null;
        } else if (((String)url).indexOf(SHOWLIST_URL) >= 0) {
            paramMap = new HashMap<String, String>();
            String name = null;
            String value = null;
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (name.equals("user") || name.equals("pass")) continue;
                if (name.startsWith("action_Show")) {
                    ignoreFlag = true;
                    break;
                }
                value = StringUtil.getEncodeString((String)request.getParameter(name), (String)this.getJspEncoding());
                name = StringUtil.getEncodeString((String)name, (String)this.getJspEncoding());
                paramMap.put(name, value);
            }
        } else {
            boolean isRedirect = false;
            paramMap = new HashMap();
            String name = null;
            String value = null;
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (name.equals("redirectId")) {
                    isRedirect = true;
                    continue;
                }
                if (name.equals("user") || name.equals("pass")) continue;
                value = StringUtil.getEncodeString((String)request.getParameter(name), (String)this.getJspEncoding());
                name = StringUtil.getEncodeString((String)name, (String)this.getJspEncoding());
                paramMap.put(name, value);
            }
            if (isRedirect) {
                e = request.getAttributeNames();
                while (e.hasMoreElements()) {
                    name = (String)e.nextElement();
                    if (name.equals("user") || name.equals("pass")) continue;
                    value = StringUtil.getEncodeString((String)((String)request.getAttribute(name)), (String)this.getJspEncoding());
                    name = StringUtil.getEncodeString((String)name, (String)this.getJspEncoding());
                    paramMap.put(name, value);
                }
            }
        }
        if (ignoreFlag) {
            return;
        }
        PankuzuNode node = null;
        int size = this.list.size();
        boolean updateFlag = false;
        int pos = -1;
        for (int i = size - 1; i >= 0; --i) {
            node = this.list.get(i);
            String titled = node.getTitle();
            if (title == null || titled == null || !title.equals(titled)) continue;
            pos = i;
            break;
        }
        if (pos >= 0) {
            if (pos == 0 && MENU_URL.equals(StringUtil.lastToken((String)url, (String)"/"))) {
                if (paramMap.size() == 0) {
                    --size;
                    while (size > 0) {
                        this.list.remove(size);
                        --size;
                    }
                }
            } else {
                --size;
                while (size > pos) {
                    this.list.remove(size);
                    --size;
                }
            }
        } else {
            updateFlag = true;
        }
        if (updateFlag) {
            this.list.add(new PankuzuNode(title, (String)url, paramMap));
        }
    }

    public Pankuzu getPankuzu() {
        Pankuzu fp = new Pankuzu();
        PankuzuNode node = null;
        Item item = null;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            node = this.list.get(i);
            item = new Item();
            item.setTitle(node.getTitle());
            Object url = node.getUrl();
            if (url != null && !((String)url).endsWith(".do")) {
                url = (String)url + ".do";
            }
            item.setUrl((String)url);
            item.setQuerystring(node.getQuerystring());
            fp.addItem(item);
        }
        return fp;
    }

    public int size() {
        return this.list.size();
    }

    public String get(int i) {
        if (i < 0 || i > this.list.size()) {
            return "";
        }
        return this.list.get(i).toString();
    }

    public String last() {
        return this.list.get(this.list.size() - 1).toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        PankuzuNode node = null;
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            node = this.list.get(i);
            sb.append("[");
            sb.append(node.getTitle());
            sb.append("]");
            sb.append(node);
            if (i >= size - 1) continue;
            sb.append(" > ");
        }
        return sb.toString();
    }
}

