/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.jasminesoft.jfc.ProcessBean;
import jp.jasminesoft.jfc.Releasable;
import jp.jasminesoft.util.RangeCompareUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultBeanCacheInfo<T>
implements Releasable {
    private static final Logger logger = LogManager.getLogger(ResultBeanCacheInfo.class);
    private ArrayList<T> cacheList;
    private int cacheBeginCnt;
    private ProcessBean pbean;

    public ResultBeanCacheInfo(int cachesize) {
        this.cacheList = new ArrayList(cachesize);
    }

    public boolean isValid() {
        return this.pbean != null;
    }

    public void clear() {
        this.cacheList.clear();
        this.cacheBeginCnt = 0;
        this.pbean = null;
    }

    public int getCompareRange(int start, int end) {
        int cacheEndCnt = this.getCacheEndCount();
        if (this.cacheBeginCnt > cacheEndCnt) {
            throw new IllegalArgumentException("Illegal value is detected, cacheBeginCnt(" + this.cacheBeginCnt + ") > cacheEndCnt(" + cacheEndCnt + ")");
        }
        if (start > end) {
            logger.debug("Illegal value is detected, start(" + start + ") > end(" + end + "). Swap the two values.");
            int i = start;
            start = end;
            end = i;
        }
        return RangeCompareUtilities.getCompareRange((int)this.cacheBeginCnt, (int)cacheEndCnt, (int)start, (int)end);
    }

    public List<T> getCacheList() {
        return Collections.unmodifiableList(this.cacheList);
    }

    public int getCacheBeginCount() {
        return this.cacheBeginCnt;
    }

    public void setCacheBeginCount(int cacheBeginCount) {
        this.cacheBeginCnt = cacheBeginCount;
    }

    public int getCacheEndCount() {
        return this.cacheBeginCnt + this.cacheList.size();
    }

    public List<T> getCacheSubList(int start, int end) {
        return Collections.unmodifiableList(this._getCacheSubList(start, end));
    }

    private List<T> _getCacheSubList(int start, int end) {
        return this.cacheList.subList(start -= this.getCacheBeginCount(), end -= this.getCacheBeginCount());
    }

    public ProcessBean getProcessBean() {
        return this.pbean;
    }

    public void setProcessBean(ProcessBean pbean) {
        this.pbean = pbean;
    }

    public String toString() {
        return "begin:" + this.getCacheBeginCount() + " end:" + this.getCacheEndCount() + " size:" + this.getCacheList().size();
    }

    @Override
    public void release() {
        this.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearCacheSubList(int start, int end) {
        if (this.cacheList.size() == 0) {
            return;
        }
        int cmpmode = this.getCompareRange(start, end);
        if (cmpmode == 0) return;
        if (cmpmode == 1) {
            List<T> removelist = this._getCacheSubList(this.getCacheBeginCount(), end);
            removelist.clear();
            this.setCacheBeginCount(end);
            return;
        } else if (cmpmode == 2) {
            if (start == this.getCacheBeginCount()) {
                List<T> removelist = this._getCacheSubList(this.getCacheBeginCount(), end);
                removelist.clear();
                this.setCacheBeginCount(end);
                return;
            } else {
                if (end != this.getCacheEndCount()) throw new IllegalStateException("Can not clear cache middle area");
                List<T> removelist = this._getCacheSubList(start, this.getCacheEndCount());
                removelist.clear();
            }
            return;
        } else if (cmpmode == 3) {
            List<T> removelist = this._getCacheSubList(start, this.getCacheEndCount());
            removelist.clear();
            return;
        } else {
            if (cmpmode == 4) return;
            if (cmpmode == 6) {
                this.cacheList.clear();
                return;
            } else {
                if (cmpmode != 5) return;
                this.cacheList.clear();
            }
        }
    }

    public void clearCacheList() {
        this.cacheList.clear();
    }

    public void addCacheList(int begincnt, List<T> col) {
        if (this.cacheList.size() == 0) {
            this.cacheBeginCnt = begincnt;
            this.cacheList.addAll(col);
            return;
        }
        int endcnt = begincnt + col.size();
        int cmpmode = this.getCompareRange(begincnt, endcnt);
        if (cmpmode == 0) {
            if (this.getCacheBeginCount() == endcnt) {
                this.cacheBeginCnt = begincnt;
                this.cacheList.addAll(0, col);
            } else {
                this.cacheList.clear();
                this.cacheBeginCnt = begincnt;
                this.cacheList.addAll(col);
            }
        } else if (cmpmode == 1) {
            List<T> removelist = this._getCacheSubList(this.getCacheBeginCount(), endcnt);
            removelist.clear();
            this.cacheBeginCnt = begincnt;
            this.cacheList.addAll(0, col);
        } else if (cmpmode == 2) {
            List<T> replacelist = this._getCacheSubList(begincnt, endcnt);
            int size = replacelist.size();
            for (int i = 0; i < size; ++i) {
                replacelist.set(i, col.get(i));
            }
        } else if (cmpmode == 3) {
            List<T> removelist = this._getCacheSubList(begincnt, this.getCacheEndCount());
            removelist.clear();
            this.cacheList.addAll(col);
        } else if (cmpmode == 4) {
            if (this.getCacheEndCount() == begincnt) {
                this.cacheList.addAll(col);
            } else {
                this.cacheList.clear();
                this.cacheBeginCnt = begincnt;
                this.cacheList.addAll(col);
            }
        } else if (cmpmode == 6) {
            this.cacheList.clear();
            this.cacheBeginCnt = begincnt;
            this.cacheList.addAll(col);
        } else if (cmpmode == 5) {
            this.cacheList.clear();
            this.cacheBeginCnt = begincnt;
            this.cacheList.addAll(col);
        }
    }

    public boolean isIncludeResult(int start, int end) {
        if (!this.isValid()) {
            return false;
        }
        int cmpmode = this.getCompareRange(start, end);
        return cmpmode == 2 || cmpmode == 6;
    }
}

