/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class TransformerManager {
    private static TransformerManager _instance = null;
    private Map transformerMap = new HashMap();
    private static final Logger logger = LogManager.getLogger((String)TransformerManager.class.getName());
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private Map entityMap;

    private TransformerManager() {
    }

    public static synchronized TransformerManager getInstance() {
        if (_instance == null) {
            _instance = new TransformerManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transformer getTransformer(String path) {
        File file = new File(path);
        long now = file.lastModified();
        XTransformer xtransformer = (XTransformer)this.transformerMap.get(path);
        if (xtransformer != null && xtransformer.time >= now) {
            return xtransformer.transformer;
        }
        xtransformer = new XTransformer();
        StreamSource xsltSrc = new StreamSource(file);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            xtransformer.transformer = transformerFactory.newTransformer(xsltSrc);
            xtransformer.time = now;
        }
        catch (TransformerConfigurationException e) {
            logger.debug(e.getMessage());
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        Map map = this.transformerMap;
        synchronized (map) {
            this.transformerMap.put(path, xtransformer);
        }
        return xtransformer.transformer;
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler();
        }
        return this.errorHandler;
    }

    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new DefaultEntityResolver();
        }
        return this.entityResolver;
    }

    String adjustURI(String uri) {
        try {
            URL url = this.makeURL(uri);
            return url.toExternalForm();
        }
        catch (MalformedURLException e) {
            return uri;
        }
    }

    URL makeURL(String uri) throws MalformedURLException {
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            return new File(uri).toURL();
        }
    }

    boolean isURL(String uri) {
        try {
            new URL(uri);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    boolean canAccess(String uri) {
        try {
            URL url = this.makeURL(uri);
            if ("file".equals(url.getProtocol())) {
                String fileName = url.getFile();
                return new File(fileName).exists();
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setEntityResource(String systemId, URL resource) {
        if (this.entityMap == null) {
            this.entityMap = new HashMap();
        }
        this.entityMap.put(systemId, resource);
    }

    public URL getEntityResource(String systemId) {
        if (this.entityMap == null) {
            return null;
        }
        String filename = this._getFilename(systemId);
        return (URL)this.entityMap.get(filename);
    }

    private String _getFilename(String pathname) {
        int index = pathname.lastIndexOf("/");
        if (index == -1) {
            return pathname;
        }
        return pathname.substring(index + 1);
    }

    static class XTransformer {
        long time;
        Transformer transformer;

        XTransformer() {
        }
    }

    static class DefaultErrorHandler
    implements ErrorHandler {
        DefaultErrorHandler() {
        }

        @Override
        public void error(SAXParseException e) {
            System.err.print("error : ");
            System.err.println(e.getMessage());
        }

        @Override
        public void fatalError(SAXParseException e) {
            System.err.print("fatal error : ");
            System.err.println(e.getMessage());
        }

        @Override
        public void warning(SAXParseException e) {
            System.err.print("warning : ");
            System.err.println(e.getMessage());
        }
    }

    class DefaultEntityResolver
    implements EntityResolver {
        DefaultEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (!systemId.endsWith(".dtd")) {
                URL url = TransformerManager.this.getEntityResource(systemId);
                if (url != null) {
                    return new InputSource(url.toExternalForm());
                }
                return null;
            }
            if (TransformerManager.this.canAccess(systemId)) {
                return new InputSource(systemId);
            }
            URL url = TransformerManager.this.getEntityResource(systemId);
            if (url != null) {
                return new InputSource(url.toExternalForm());
            }
            StringReader reader = new StringReader("");
            return new InputSource(reader);
        }
    }
}

