/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.Serializable;
import java.net.URL;
import java.security.PermissionCollection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCAppPolicyFile;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LockSingleManager;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PreferenceInfo;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.core.group.GroupNodeManager;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.model.preference.Item;
import jp.jasminesoft.jfc.model.preference.Preference;
import jp.jasminesoft.jfc.service.JfcConfig;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class User
implements Serializable,
HttpSessionBindingListener {
    private IJuser juser;
    private String username = null;
    private transient LoginContext lc = null;
    private PermissionCollection permission_collection = null;
    private transient PreferenceInfo preferenceInfo;
    private boolean save_lastaccesstime_at_logoff = false;
    private boolean clear_permission_at_logoff = true;
    private transient HttpSession session_ = null;
    private String sessionId_ = null;
    private transient ApplicationContext appctx;
    private static int count = 0;
    private static final Logger logger = LogManager.getLogger((String)User.class.getName());
    public static final JFCAppPermission UNLOCK_PERMISSION = new JFCAppPermission("juser", "unlock");
    private static JfcConfig jfcConfig;
    private Subject subject;
    private String logonModuleName;

    public static void setJfcConfig(JfcConfig jfcConfig1) {
        jfcConfig = jfcConfig1;
    }

    public static JfcConfig getJfcConfig() {
        return jfcConfig;
    }

    public User(String username, LoginContext lc, String logonModuleName, ApplicationContext appctx) {
        this.username = username;
        this.lc = lc;
        this.logonModuleName = logonModuleName;
        if (lc.getSubject() == null) {
            throw new NullPointerException("subject must not be null.");
        }
        this.subject = lc.getSubject();
        this.appctx = appctx;
    }

    public ApplicationContext getApplicationContext() {
        return this.appctx;
    }

    public void setApplicationContext(ApplicationContext appctx) {
        this.appctx = appctx;
    }

    public void setJuser(IJuser juser) {
        juser.getJgroupid();
        this.juser = juser;
    }

    public IJuser getJuser() {
        return this.juser;
    }

    public void clearJuser() {
        this.juser = null;
    }

    public int[] getGroupId() {
        if (this.juser == null) {
            return null;
        }
        return this.juser.getJgroupid();
    }

    public int[] getSubGroupIds() {
        return ArrayUtils.toPrimitive((Integer[])((GroupNodeManager)this.appctx.getBean("GroupNodeManager", GroupNodeManager.class)).descendants(this.getGroupId()));
    }

    public String getPasswdChangeFlag() {
        if (this.juser == null) {
            return null;
        }
        return this.juser.getPasswdChangeFlag();
    }

    public boolean checkPasswdChangeFlag() {
        if (JFCUtils.hasPrincipalRestrictively(this, "jobAccount")) {
            return false;
        }
        if (this.isInternetAccount()) {
            return false;
        }
        boolean initialize = true;
        String passwdChangeFlag = this.getPasswdChangeFlag();
        if (passwdChangeFlag == null || passwdChangeFlag != null && passwdChangeFlag.equals("off")) {
            initialize = false;
        } else {
            logger.debug("user " + this.getUsername() + "'s password change flag is on.");
            initialize = true;
        }
        return initialize;
    }

    public Timestamp getPasswdChangeDate() {
        if (this.juser == null) {
            return null;
        }
        return this.juser.getPasswdChangeDate();
    }

    public HttpSession getSession() {
        return this.session_;
    }

    public void setSession(HttpSession s) {
        this.session_ = s;
    }

    public String getSessionId() {
        return this.sessionId_;
    }

    public void setSessionId(String s) {
        this.sessionId_ = s;
    }

    public String getUsername() {
        return this.username;
    }

    public LoginContext getLoginContext() {
        if (this.lc != null) {
            return this.lc;
        }
        try {
            this.lc = new LoginContext(this.logonModuleName, this.subject);
            return this.lc;
        }
        catch (LoginException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public PermissionCollection getPermissionCollection(URL security_url) {
        if (this.permission_collection != null) {
            return this.permission_collection;
        }
        Subject subject = this.getLoginContext().getSubject();
        JFCAppPolicyFile policyfile = JFCAppPolicyFile.getInstance();
        if (policyfile == null) {
            throw new IllegalStateException("Failed get policyfile");
        }
        PermissionCollection pcoll = policyfile.getPermissions(subject);
        if (this.isInternetAccount()) {
            pcoll.add(UNLOCK_PERMISSION);
        }
        this.permission_collection = pcoll;
        return pcoll;
    }

    private synchronized PreferenceInfo loadPreference() {
        if (this.preferenceInfo != null) {
            return this.preferenceInfo;
        }
        this.preferenceInfo = new PreferenceInfo(this.username);
        return this.preferenceInfo;
    }

    public synchronized void savePreference() {
        if (this.preferenceInfo == null) {
            return;
        }
        this.preferenceInfo.save();
    }

    public Preference getPreference() {
        return this.loadPreference().preference();
    }

    public Item getPreferenceItem(String key) {
        return this.loadPreference().get(key);
    }

    public void setPreferenceItem(String key, String value) {
        this.loadPreference().set(key, value);
    }

    public void setPreferenceItem(String key, String value, String type) {
        this.loadPreference().set(key, value, type);
    }

    public void removePreferenceItem(Item _item) {
        this.loadPreference().delete(_item.getKey());
    }

    public boolean isSaveLastAccessTimeAtLogoff() {
        return this.save_lastaccesstime_at_logoff;
    }

    public void setSaveLastAccessTimeAtLogoff(boolean save_lastaccesstime_at_logoff) {
        this.save_lastaccesstime_at_logoff = save_lastaccesstime_at_logoff;
    }

    public boolean isClearPermissionCacheAtLogoff() {
        return this.clear_permission_at_logoff;
    }

    public void setClearPermissionCacheAtLogoff(boolean clear_permission_at_logoff) {
        this.clear_permission_at_logoff = clear_permission_at_logoff;
    }

    public static int getCount() {
        return count;
    }

    public static boolean isValidPasswd(long lastModified) {
        if (lastModified < 0L) {
            return true;
        }
        int edays = jfcConfig.getUserinfoPasswdExpirePeriod();
        if (edays < 0) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        Calendar edate = Calendar.getInstance();
        edate.setTimeInMillis(lastModified);
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        edate.set(11, 0);
        edate.set(12, 0);
        edate.set(13, 0);
        edate.set(14, 0);
        edate.add(6, edays);
        if (now.after(edate)) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00024), LogCodeManager.getMessage(LogCode.JFC00024, new String[0]));
            return false;
        }
        return true;
    }

    public boolean nearPasswdTTL() {
        if (!((SecurityProperties)this.appctx.getBean(SecurityProperties.class)).isValidJdbcAuthentication()) {
            return false;
        }
        if (this.isInternetAccount()) {
            return false;
        }
        if (this.juser == null || this.juser.getPasswd() == null) {
            return false;
        }
        Timestamp passwdChangeDate = this.getPasswdChangeDate();
        if (passwdChangeDate == null || passwdChangeDate.getTime() < 0L) {
            return false;
        }
        long lastModified = passwdChangeDate.getTime();
        JfcConfig jfcConfig = (JfcConfig)this.appctx.getBean(JfcConfig.class);
        int edays = jfcConfig.getUserinfoPasswdExpirePeriod();
        if (edays < 0) {
            return false;
        }
        int wdays = jfcConfig.getUserinfoPasswdChangeWarnPeriod();
        if (wdays < 0 || wdays > edays) {
            return false;
        }
        Calendar now = Calendar.getInstance();
        Calendar wdate = Calendar.getInstance();
        wdate.setTimeInMillis(lastModified);
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        now.set(14, 0);
        wdate.set(11, 0);
        wdate.set(12, 0);
        wdate.set(13, 0);
        wdate.set(14, 0);
        wdate.add(6, edays - wdays);
        if (now.after(wdate)) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00025), LogCodeManager.getMessage(LogCode.JFC00025, new String[0]));
            return true;
        }
        return false;
    }

    public static Date getPasswdTTL(long lastModified) throws Exception {
        if (lastModified < 0L) {
            throw new Exception("lastModified is invalid:" + lastModified);
        }
        int edays = jfcConfig.getUserinfoPasswdExpirePeriod();
        if (edays < 0) {
            throw new Exception("UserinfoPasswdExprePeriod is invalid:" + edays);
        }
        Calendar wdate = Calendar.getInstance();
        wdate.setTimeInMillis(lastModified);
        wdate.set(11, 0);
        wdate.set(12, 0);
        wdate.set(13, 0);
        wdate.set(14, 0);
        wdate.add(6, edays);
        return wdate.getTime();
    }

    public void valueBound(HttpSessionBindingEvent event) {
        this.session_ = event.getSession();
        if (this.session_ != null) {
            this.sessionId_ = this.session_.getId();
        } else {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00026), LogCodeManager.getMessage(LogCode.JFC00026, this.username));
        }
    }

    public boolean isInternetAccount() {
        return this.getUsername().equals(User.getIgnoreLogoncheckUsername());
    }

    public static boolean isIgnoreLogoncheck() {
        return jfcConfig.isIgnoreLogoncheck();
    }

    public static String getIgnoreLogoncheckPassword() {
        if (!User.isIgnoreLogoncheck()) {
            return null;
        }
        return jfcConfig.getIgnoreLogoncheckPassword();
    }

    public static String getIgnoreLogoncheckUsername() {
        if (!User.isIgnoreLogoncheck()) {
            return null;
        }
        return jfcConfig.getIgnoreLogoncheckUsername();
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        long lastaccesstime = 0L;
        if (this.isSaveLastAccessTimeAtLogoff()) {
            try {
                lastaccesstime = event.getSession().getLastAccessedTime();
            }
            catch (Exception e) {
                lastaccesstime = System.currentTimeMillis();
            }
        }
        if (this.appctx == null) {
            logger.info("get applicationcontext");
            ServletContext servletContext = event.getSession().getServletContext();
            WebApplicationContext _appctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
            this.appctx = _appctx;
            if (this.appctx == null) {
                logger.error("failed get application context, applicationcontext is null");
            }
        }
        this.logoff(lastaccesstime);
    }

    public void logoff() {
        this.logoff(Long.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoff(long lastaccesstime) {
        UserInfo userinfo;
        block11: {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00028), LogCodeManager.getMessage(LogCode.JFC00028, this.username));
            try {
                this.getLoginContext().logout();
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00029), LogCodeManager.getMessage(LogCode.JFC00029, new String[0]));
                logger.debug((Object)e);
                if (!logger.isDebugEnabled()) break block11;
                e.printStackTrace();
            }
        }
        if (this.isSaveLastAccessTimeAtLogoff() && (userinfo = UserInfoFactory.getUserInfo()) != null) {
            try {
                if (this.isSaveLastAccessTimeAtLogoff()) {
                    userinfo.setLastAccessTime(this.username, lastaccesstime);
                }
            }
            finally {
                userinfo.close();
            }
        }
        String sessionid = this.sessionId_;
        LogonStatusManager lsman = LogonStatusManager.getInstance();
        lsman.releaseUserObject(this.username, sessionid);
        if (this.appctx != null) {
            LockSingleManager lockman = LockManagerFactory.getLockSingleManager(this.appctx);
            lockman.remove(sessionid);
            if (this.sessionId_ != null) {
                ActionParameter p = JFCUtils.createActionParameter(this, this.appctx);
                ActionParameterContainer pcon = (ActionParameterContainer)this.appctx.getBean(ActionParameterContainer.class);
                pcon.set(p);
                String ret = new ScriptCodeRunner("__sys").process("", "logoff", "process", p);
                if (StringUtils.isNotEmpty((CharSequence)ret)) {
                    logger.error("Failed to run logoff script for user " + this.getUsername() + ". " + ret);
                }
            }
        } else {
            logger.error("application context is null. Locks not released, logoff script not executed");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("User[");
        sb.append(this.username);
        sb.append(" ");
        sb.append(this.loadPreference().preference());
        sb.append(" total:");
        sb.append(count);
        sb.append(" ]");
        return sb.toString();
    }
}

