/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import jp.jasminesoft.jfc.FileUserInfo;
import jp.jasminesoft.jfc.NoSuchPrincipalException;

@Deprecated
public class UserMan {
    private static final String DEFAULT_FILENAME = "userinfo.ser";
    private String filename;
    private FileUserInfo userinfo;

    public UserMan(String filename) {
        if (filename != null) {
            this.filename = filename;
        }
        this.load();
    }

    private void load() {
        this.userinfo = FileUserInfo.create(this.filename);
    }

    private void save() {
        this.userinfo.save(this.filename);
    }

    protected void process_add() {
        String username = null;
        String password = null;
        try {
            System.out.print("Username: ");
            System.out.flush();
            username = new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.out.print("Password: ");
            System.out.flush();
            char[] ch = this.readPassword(System.in);
            System.out.print("Password (again): ");
            System.out.flush();
            char[] ch2 = this.readPassword(System.in);
            boolean invalidFlag = false;
            if (ch.length != ch2.length) {
                invalidFlag = true;
            } else {
                for (int i = 0; i < ch.length; ++i) {
                    if (ch[i] == ch2[i]) continue;
                    invalidFlag = true;
                    break;
                }
            }
            if (invalidFlag) {
                System.err.println("invalid password.");
                return;
            }
            password = new String(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userinfo.addUser(username, password);
        this.save();
    }

    protected void process_remove() {
        System.out.print("Username: ");
        System.out.flush();
        String username = null;
        try {
            username = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userinfo.removeUser(username);
        this.save();
    }

    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    protected void process_show() {
        if (this.userinfo != null) {
            System.out.println(this.userinfo);
        }
    }

    protected void process_add_principal() {
        String principal = null;
        try {
            System.out.print("Principal: ");
            System.out.flush();
            principal = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userinfo.addPrincipal(principal);
        this.save();
    }

    protected void process_remove_principal() {
        String principal = null;
        try {
            System.out.print("Principal: ");
            System.out.flush();
            principal = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.userinfo.removePrincipal(principal);
        this.save();
    }

    protected void process_assign() {
        String username = null;
        String principal = null;
        try {
            System.out.print("Username: ");
            System.out.flush();
            username = new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.out.print("Principal: ");
            System.out.flush();
            principal = new BufferedReader(new InputStreamReader(System.in)).readLine();
            this.userinfo.assignPrincipal(username, principal);
        }
        catch (IOException iOException) {
        }
        catch (NoSuchPrincipalException e) {
            System.err.println(e);
        }
        this.save();
    }

    public void process(String action) {
        if (action == null) {
            return;
        }
        if ("add".equals(action = action.toLowerCase())) {
            this.process_add();
        } else if ("remove".equals(action)) {
            this.process_remove();
        } else if ("show".equals(action)) {
            this.process_show();
        } else if ("addp".equals(action)) {
            this.process_add_principal();
        } else if ("removep".equals(action)) {
            this.process_remove_principal();
        } else if ("assign".equals(action)) {
            this.process_assign();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -jar UserMan.jar [action] [filename]");
            System.out.println("  action ... show, add, remove, addp, removep, assign");
            System.exit(0);
        }
        String action = args[0];
        String filename = DEFAULT_FILENAME;
        if (args.length > 1) {
            filename = args[1];
        }
        UserMan userman = new UserMan(filename);
        userman.process(action);
    }
}

