/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.AttachmentFileMap;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessor;
import jp.jasminesoft.jfc.DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls;
import jp.jasminesoft.jfc.FilterManager;
import jp.jasminesoft.jfc.JFCControlUtil;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemMultiString;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefBase;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemStorerefInt;
import jp.jasminesoft.jfc.model.JFCPresentationModelitemString;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringFilter;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CSVHelperBase<S extends ContainerBase<S>, P> {
    private static final Logger logger = LogManager.getLogger(CSVHelperBase.class);
    protected PresentationPHelper<S, P> pHelper;
    protected static final Pattern MultipleHeaderPattern = Pattern.compile("\\[(-?[0-9]+)\\]");
    protected static final Pattern ContainerHeaderPattern = Pattern.compile("\\[(-?[0-9]+)\\]\\/(.*)");

    public void setPresentationHelper(PresentationPHelper<S, P> pHelper) {
        this.pHelper = pHelper;
    }

    public String[] toCsvData(ActionParameter p) {
        return this.toCsvData((ContainerBase)null, p);
    }

    public String[] toCsvData(S entity, ActionParameter p) {
        return this.toCsvData(entity, this.pHelper.s2p(entity, p, 3), Collections.EMPTY_MAP, p);
    }

    public String[] toCsvData(Map colMap, ActionParameter p) {
        return this.toCsvData((P)null, colMap, p);
    }

    public String[] toCsvData(S entity, Map colMap, ActionParameter p) {
        return this.toCsvData(entity, this.pHelper.s2p(entity, p, 3), colMap, p);
    }

    public String[] toCsvData(P pr, Map colMap, ActionParameter p) {
        return this.toCsvData((ContainerBase)null, pr, colMap, p);
    }

    public String[] toCsvData(S entity, P pr, Map colMap, ActionParameter p) {
        return this.toCsvData(entity, pr, colMap, p, false);
    }

    public String[] toCsvData(P pr, Map colMap, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvData(null, pr, colMap, p, getallmodelitem);
    }

    public String[] toCsvData(S entity, P pr, Map colMap, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvData(entity, pr, colMap, p, getallmodelitem, null);
    }

    public String[] toCsvData(S entity, P pr, Map colMap, ActionParameter p, boolean getallmodelitem, List<Serializable> storedata) {
        return this.toCsvData(entity, pr, colMap, p, getallmodelitem, storedata, null);
    }

    public String[] toCsvData(S entity, P pr, Map colMap, ActionParameter p, boolean getallmodelitem, List<Serializable> storedata, Collection<String> targetitems) {
        return new String[0];
    }

    public String[] toCsvDataMain(P pr, ActionParameter p) {
        return this.toCsvDataMain((ContainerBase)null, pr, p);
    }

    public String[] toCsvDataMain(S entity, P pr, ActionParameter p) {
        return this.toCsvDataMain(entity, pr, p, false);
    }

    public String[] toCsvDataMain(P pr, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataMain(null, pr, p, getallmodelitem);
    }

    public String[] toCsvDataMain(S entity, P pr, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataMain(entity, pr, p, getallmodelitem, null);
    }

    public String[] toCsvDataMain(S entity, P pr, ActionParameter p, boolean getallmodelitem, List<Serializable> storedata) {
        return this.toCsvDataMain(entity, pr, p, getallmodelitem, storedata, null);
    }

    public String[] toCsvDataMain(S entity, P pr, ActionParameter p, boolean getallmodelitem, List<Serializable> storedata, Collection<String> targetitems) {
        return new String[0];
    }

    public String[][] toCsvDataModelitem(String modelitemname, P pr, ActionParameter p) {
        return this.toCsvDataModelitem(modelitemname, null, pr, p, false);
    }

    public String[][] toCsvDataModelitem(String modelitemname, S entity, P pr, ActionParameter p) {
        return this.toCsvDataModelitem(modelitemname, entity, pr, p, false);
    }

    public String[][] toCsvDataModelitem(String modelitemname, P pr, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataModelitem(modelitemname, null, pr, p, getallmodelitem);
    }

    public String[][] toCsvDataModelitem(String modelitemname, S entity, P pr, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataModelitem(modelitemname, entity, pr, p, getallmodelitem, null);
    }

    public String[][] toCsvDataModelitem(String modelitemname, S entity, P pr, ActionParameter p, boolean getallmodelitem, List<List<Serializable>> storedata2) {
        return this.toCsvDataModelitem(modelitemname, entity, pr, p, getallmodelitem, storedata2, null);
    }

    public String[][] toCsvDataModelitem(String modelitemname, S entity, P pr, ActionParameter p, boolean getallmodelitem, List<List<Serializable>> storedata2, Collection<String> targetitems) {
        return new String[0][0];
    }

    public String[] toCsvDataHeader(ActionParameter p) {
        return this.toCsvDataHeader((ContainerBase)null, Collections.EMPTY_MAP, p);
    }

    public String[] toCsvDataHeader(S entity, ActionParameter p) {
        return this.toCsvDataHeader(entity, Collections.EMPTY_MAP, p);
    }

    public String[] toCsvDataHeader(Map colMap, ActionParameter p) {
        return this.toCsvDataHeader(null, colMap, p, false);
    }

    public String[] toCsvDataHeader(S entity, Map colMap, ActionParameter p) {
        return this.toCsvDataHeader(entity, colMap, p, false);
    }

    public String[] toCsvDataHeader(Map colMap, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeader(null, colMap, p, getallmodelitem);
    }

    public String[] toCsvDataHeader(S entity, Map colMap, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeader(null, colMap, p, getallmodelitem, null);
    }

    public String[] toCsvDataHeader(S entity, Map colMap, ActionParameter p, boolean getallmodelitem, Collection<String> targetitems) {
        return new String[0];
    }

    public String[] toCsvDataHeaderMain(ActionParameter p) {
        return this.toCsvDataHeaderMain(null, p, false);
    }

    public String[] toCsvDataHeaderMain(S entity, ActionParameter p) {
        return this.toCsvDataHeaderMain(entity, p, false);
    }

    public String[] toCsvDataHeaderMain(ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeaderMain(null, p, getallmodelitem);
    }

    public String[] toCsvDataHeaderMain(S entity, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeaderMain(null, p, getallmodelitem, null);
    }

    public String[] toCsvDataHeaderMain(S entity, ActionParameter p, boolean getallmodelitem, Collection<String> targetitems) {
        return new String[0];
    }

    public String[] toCsvDataHeaderModelitem(String modelitemname, ActionParameter p) {
        return this.toCsvDataHeaderModelitem(modelitemname, null, p, false);
    }

    public String[] toCsvDataHeaderModelitem(String modelitemname, S entity, ActionParameter p) {
        return this.toCsvDataHeaderModelitem(modelitemname, entity, p, false);
    }

    public String[] toCsvDataHeaderModelitem(String modelitemname, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeaderModelitem(modelitemname, null, p, getallmodelitem);
    }

    public String[] toCsvDataHeaderModelitem(String modelitemname, S entity, ActionParameter p, boolean getallmodelitem) {
        return this.toCsvDataHeaderModelitem(modelitemname, null, p, getallmodelitem, null);
    }

    public String[] toCsvDataHeaderModelitem(String modelitemname, S entity, ActionParameter p, boolean getallmodelitem, Collection<String> targetitems) {
        return new String[0];
    }

    public void checkCsvHeader(String[] _header, ActionParameter p, JFCErrorManager _manager) {
        this.checkCsvHeader(_header, p, _manager, true);
    }

    public void checkCsvHeader(String[] _header, ActionParameter p, JFCErrorManager _manager, boolean _checkpkey) {
    }

    public boolean parseCsvData(String[] _data, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvData(_data, _header, entity, pr, p, _manager, null);
    }

    public boolean parseCsvData(String[] _data, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet) {
        return this.parseCsvData(_data, _header, entity, pr, p, _manager, _targetSet, 0);
    }

    public boolean parseCsvData(String[] _data, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet, int _cnt) {
        return this.parseCsvData(_data, _header, entity, pr, p, _manager, _targetSet, 0, null);
    }

    public boolean parseCsvData(String[] _data, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet, int _cnt, S src_TemplateModel) {
        return this.parseCsvData(_data, _header, entity, pr, p, _manager, _targetSet, 0, null, null);
    }

    public boolean parseCsvData(String[] _data, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet, int _cnt, S src_S, AttachmentFileMap _attachmentFileMap) {
        return this.parseCsvData(_data, null, _header, entity, pr, p, _manager, _targetSet, _cnt, src_S, _attachmentFileMap);
    }

    public boolean parseCsvData(String[] _data, DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] cwa, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet) {
        return this.parseCsvData(_data, cwa, _header, entity, pr, p, _manager, _targetSet, 0, null, null);
    }

    public boolean parseCsvData(String[] _data, DbUploadUpdateRunnableMonitorFileProcessor.CellAttr[] cwa, String[] _header, S entity, P pr, ActionParameter p, JFCErrorManager _manager, Set<String> _targetSet, int _cnt, S src_S, AttachmentFileMap _attachmentFileMap) {
        return false;
    }

    public boolean[] getValidCsvHeader(String[] _header, ActionParameter p) {
        HashSet<String> _headerSet = new HashSet<String>(Arrays.asList(_header));
        int _len = _header.length;
        boolean[] _valids = new boolean[_len];
        for (int i = 0; i < _len; ++i) {
            String _key = _header[i].trim();
            if (_key.length() == 0) continue;
            _valids[i] = this.getValidCsvHeader(_key, p, _headerSet);
        }
        return _valids;
    }

    public boolean getValidCsvHeader(String _key, ActionParameter p, Set<String> _headerSet) {
        return false;
    }

    public boolean[] getValidModelitemCsvHeader(String[] header, ActionParameter p) {
        HashSet<String> headerSet = new HashSet<String>(Arrays.asList(header));
        int len = header.length;
        boolean[] valids = new boolean[len];
        for (int i = 0; i < len; ++i) {
            String key = header[i].trim();
            if (key.length() == 0) continue;
            valids[i] = this.getValidModelitemCsvHeader(key, p, headerSet);
        }
        return valids;
    }

    public boolean getValidModelitemCsvHeader(String key, ActionParameter p, Set<String> headerSet) {
        return false;
    }

    protected void toCsvDataNormal(S entity, P pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentNormal((ContainerBase)entity, (Object)pr, itemname, value, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected void toCsvDataNormalCheckTargetSet(S entity, P pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata, boolean getallmodelitem, Set<String> targetSet, ActionParameter p) {
        if ((getallmodelitem || targetSet != null && targetSet.contains(itemname)) && this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentNormal((ContainerBase)entity, (Object)pr, itemname, value, list, storedata);
        } else if ((getallmodelitem || targetSet != null && targetSet.contains(itemname)) && this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataNormal(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (parent_control != JFCControlUtil.ControlType.Hidden && this.pHelper.getControlType(p.user, cont, contitemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentNormal(cont, cont_p, itemname, value, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected void toCsvDataDualInput(S entity, P pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentDualInput((ContainerBase)entity, (Object)pr, itemname, value, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataDualInput(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, cont, contitemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentDualInput(cont, cont_p, itemname, value, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected void toCsvDataModelref(S entity, P pr, String itemname, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentModelref((ContainerBase)entity, (Object)pr, itemname, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataModelref(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, cont, contitemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentModelref(cont, cont_p, itemname, list, storedata);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected void toCsvDataModelCheckSingleInt(S entity, P pr, String itemname, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentModelCheckMultiSingleInt((ContainerBase)entity, (Object)pr, itemname, list, storedata, p);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addCheckMultipleEmpty(list, storedata, itemname, p);
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataModelCheckSingleInt(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, List<String> list, List<Serializable> storedata, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, cont, contitemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentModelCheckMultiSingleInt(cont, cont_p, itemname, list, storedata, p);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addCheckMultipleEmpty(list, storedata, itemname, p);
        }
    }

    protected <SItem extends Serializable> void toCsvDataMultiple(S entity, P pr, String itemname, Class<SItem> sItemClazz, List<String> list, List<Serializable> storedata, Map colMap, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentNormalMultiple((ContainerBase)entity, (Object)pr, itemname, sItemClazz, list, storedata, colMap, p);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addMultipleEmpty(list, storedata, itemname, colMap);
        }
    }

    protected <C extends ContainerBase<C>, CP, SItem extends Serializable> void toCsvDataMultiple(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Class<SItem> sItemClazz, List<String> list, List<Serializable> storedata, Map colMap, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, cont, contitemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.setContentNormalMultiple(cont, cont_p, itemname, sItemClazz, list, storedata, colMap, p);
        } else if (this.pHelper.getControlType(p.user, null, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            this.addMultipleEmpty(list, storedata, itemname, colMap);
        }
    }

    private <E extends ContainerBase<E>, EP> void setContentNormal(E entity, EP pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            Object pitem = MethodUtils.invokeMethod(pr, (String)getterm, null);
            if (pitem != null) {
                String s = (String)MethodUtils.invokeMethod((Object)pitem, (String)"getContent", null);
                s = s == null ? "" : s;
                list.add(s);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (storedata != null) {
            storedata.add(value);
        }
    }

    private <E extends ContainerBase<E>, EP, PItem extends JFCPresentationModelitemStorerefBase> void setContentDualInput(E entity, EP pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            JFCPresentationModelitemStorerefBase[] values = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            String s = "";
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getChoose()) continue;
                s = values[i].getContent();
                break;
            }
            list.add(s);
            if (storedata != null) {
                storedata.add(value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <E extends ContainerBase<E>, EP, PItem extends JFCPresentationModelitemStorerefBase> void setContentModelref(E entity, EP pr, String itemname, List<String> list, List<Serializable> storedata) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            JFCPresentationModelitemStorerefBase[] values = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            boolean isChoose = false;
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getChoose()) continue;
                list.add(values[i].getContent());
                if (storedata != null) {
                    storedata.add((Serializable)((Object)values[i].getContent()));
                }
                isChoose = true;
                break;
            }
            if (!isChoose) {
                this.addSingleEmpty(list, storedata);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <E extends ContainerBase<E>, EP, PItem extends JFCPresentationModelitemStorerefInt> void setContentModelCheckMultiSingleInt(E entity, EP pr, String itemname, List<String> list, List<Serializable> storedata, ActionParameter p) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            JFCPresentationModelitemStorerefInt[] values = (JFCPresentationModelitemStorerefInt[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            JFCPresentationModelitemStorerefInt[] code_m = (JFCPresentationModelitemStorerefInt[])MethodUtils.invokeMethod(this.pHelper, (String)(getterm + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            if (code_m != null && code_m.length > 0) {
                for (int i = 0; i < code_m.length; ++i) {
                    boolean outputFlag = false;
                    for (int j = 0; values != null && j < values.length; ++j) {
                        if (code_m[i].getId() != values[j].getId()) continue;
                        if (values[j].getChoose()) {
                            list.add("1");
                            if (storedata != null) {
                                storedata.add(Integer.valueOf(1));
                            }
                        } else {
                            list.add("0");
                            if (storedata != null) {
                                storedata.add(Integer.valueOf(0));
                            }
                        }
                        outputFlag = true;
                        break;
                    }
                    if (outputFlag) continue;
                    list.add(" ");
                    if (storedata == null) continue;
                    storedata.add((Serializable)((Object)" "));
                }
            } else {
                this.addSingleEmpty(list, storedata);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <E extends ContainerBase<E>, EP, PItem extends JFCPresentationModelitemMultiString, SItem> void setContentNormalMultiple(E entity, EP pr, String itemname, Class<SItem> sItemClazz, List<String> list, List<Serializable> storedata, Map colMap, ActionParameter p) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            int diff;
            JFCPresentationModelitemMultiString[] p_values = (JFCPresentationModelitemMultiString[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            Object[] s_values = null;
            if (entity != null) {
                if (SourceGeneratorUtil.isWrapperClass(sItemClazz)) {
                    Object ary = MethodUtils.invokeMethod(entity, (String)getterm, null);
                    int len = Array.getLength(ary);
                    ArrayList<Object> tmplist = new ArrayList<Object>();
                    for (int i = 0; i < len; ++i) {
                        tmplist.add(Array.get(ary, i));
                    }
                    s_values = tmplist.toArray((Object[])Array.newInstance(sItemClazz, list.size()));
                } else {
                    s_values = (Object[])MethodUtils.invokeMethod(entity, (String)getterm, null);
                }
            }
            for (int k = 0; k < p_values.length; ++k) {
                String s = p_values[k].getContent();
                s = s == null ? "" : s;
                list.add(s);
                if (storedata == null) continue;
                if (s_values != null && s_values.length > k) {
                    storedata.add((Serializable)s_values[k]);
                    continue;
                }
                storedata.add(null);
            }
            Integer _count = (Integer)colMap.get(itemname);
            if (_count == null) {
                _count = 1;
            }
            if ((diff = _count - p_values.length) > 0) {
                for (int k = 0; k < diff; ++k) {
                    this.addSingleEmpty(list, storedata);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addSingleEmpty(List<String> list, List<Serializable> storedata) {
        list.add("");
        if (storedata != null) {
            storedata.add(null);
        }
    }

    protected void addMultipleEmpty(List<String> list, List<Serializable> storedata, int size) {
        int i;
        for (i = 0; i < size; ++i) {
            list.add("");
        }
        if (storedata != null) {
            for (i = 0; i < size; ++i) {
                storedata.add(null);
            }
        }
    }

    protected void addMultipleEmpty(List<String> list, List<Serializable> storedata, String itemname, Map colMap) {
        Integer _count = (Integer)colMap.get(itemname);
        if (_count == null) {
            _count = 1;
        }
        for (int k = 0; k < _count; ++k) {
            this.addSingleEmpty(list, storedata);
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void addCheckMultipleEmpty(List<String> list, List<Serializable> storedata, String itemname, ActionParameter p) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            JFCPresentationModelitemStorerefBase[] code_m = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)(getterm + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            if (code_m != null && code_m.length > 0) {
                for (int i = 0; i < code_m.length; ++i) {
                    list.add(" ");
                    if (storedata == null) continue;
                    storedata.add((Serializable)((Object)" "));
                }
            } else {
                this.addSingleEmpty(list, storedata);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void toCsvDataHeaderNormal(S entity, String modelId, String itemname, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            list.add(this.getCSVHeaderRValue(entity, modelId, itemname, p));
        }
    }

    protected int toCsvDataHeaderNormal(S entity, String modelId, String itemname, int k, List<String> list, ActionParameter p, Map colMap) {
        if (this.pHelper.getControlType(p.user, entity, itemname.replace("/", "$"), p) != JFCControlUtil.ControlType.Hidden) {
            int ptr = itemname.indexOf("/");
            String pname = itemname.substring(0, ptr);
            String cname = itemname.substring(ptr + 1);
            StringBuilder sb = new StringBuilder();
            sb = new StringBuilder();
            sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
            sb.append("[" + (k + 1) + "]/");
            sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
            list.add(sb.toString());
            if (k == 0) {
                logger.info("itemname:" + itemname + " cname:" + cname);
                colMap.put(cname + ":rownum", 1);
                return 1;
            }
        }
        return 0;
    }

    protected void toCsvDataHeaderMultiple(S entity, String modelId, String itemname, Map colMap, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            int count = 1;
            Integer _count = (Integer)colMap.get(itemname);
            if (_count != null) {
                count = Math.max(1, _count);
            }
            for (int i = 0; i < count; ++i) {
                list.add(this.getCSVHeaderRValue(entity, modelId, itemname, p) + "[" + (i + 1) + "]");
            }
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void toCsvDataHeaderCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden) {
            JFCPresentationModelitemStorerefBase[] _check = null;
            try {
                _check = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            String header = this.getCSVHeaderRValue(entity, modelId, itemname, p);
            if (_check != null && _check.length > 0) {
                for (int i = 0; i < _check.length; ++i) {
                    list.add(header + (_check[i].getContent() != null ? _check[i].getContent() : ""));
                }
            } else {
                list.add(header);
            }
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> int toCsvDataHeaderCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, int k, List<String> list, ActionParameter p, Map colMap) {
        int ret = 0;
        if (this.pHelper.getControlType(p.user, entity, itemname.replace("/", "$"), p) != JFCControlUtil.ControlType.Hidden) {
            int ptr = itemname.indexOf("/");
            String pname = itemname.substring(0, ptr);
            String cname = itemname.substring(ptr + 1);
            JFCPresentationModelitemStorerefBase[] _check = null;
            try {
                _check = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            StringBuilder sb = null;
            if (_check != null && _check.length > 0) {
                for (int i = 0; i < _check.length; ++i) {
                    sb = new StringBuilder();
                    sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
                    sb.append("[" + (k + 1) + "]/");
                    sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
                    sb.append(_check[i].getContent() != null ? _check[i].getContent() : "");
                    list.add(sb.toString());
                }
                if (k == 0) {
                    ret = _check.length;
                    colMap.put(cname + ":rownum", ret);
                    logger.info("itemname:" + itemname + " cname:" + cname);
                }
            } else {
                sb = new StringBuilder();
                sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
                sb.append("[" + (k + 1) + "]/");
                sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
                list.add(sb.toString());
                if (k == 0) {
                    ret = 1;
                    colMap.put(cname + ":rownum", ret);
                    logger.info("itemname:" + itemname + " cname:" + cname);
                }
            }
        }
        return ret;
    }

    protected void toCsvDataHeaderModelitemNormal(S entity, String modelId, String itemname, List<String> list, ActionParameter p) {
        this.toCsvDataHeaderNormal(entity, modelId, itemname, list, p);
    }

    protected void toCsvDataHeaderModelitemMultiple(S entity, String modelId, String modelitemname, String itemname, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname, p) != JFCControlUtil.ControlType.Hidden && modelitemname.equals(itemname)) {
            list.add(JFCUtils.getRValue("__jfc_common.csvHeader.multiple_count", p.locale));
            list.add(this.getCSVHeaderRValue(entity, modelId, itemname, p));
        }
    }

    protected String getCSVHeaderRValue(S entity, String modelId, String itemname, ActionParameter p) {
        StringBuilder key = new StringBuilder("__jfc_helper.csvHeader.");
        key.append(modelId).append(".").append(itemname);
        return JFCUtils.getRValue(key.toString(), p.locale);
    }

    protected void toCsvDataHeaderModelitemContainer(S entity, String modelId, String itemname, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname.replace("/", "$"), p) != JFCControlUtil.ControlType.Hidden) {
            int ptr = itemname.indexOf("/");
            String pname = itemname.substring(0, ptr);
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
            sb.append("/");
            sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
            list.add(sb.toString());
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void toCsvDataHeaderModelitemContainerCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, List<String> list, ActionParameter p) {
        if (this.pHelper.getControlType(p.user, entity, itemname.replace("/", "$"), p) != JFCControlUtil.ControlType.Hidden) {
            int ptr = itemname.indexOf("/");
            String pname = itemname.substring(0, ptr);
            JFCPresentationModelitemStorerefBase[] _check = null;
            try {
                _check = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            StringBuilder sb = null;
            if (_check != null && _check.length > 0) {
                for (int i = 0; i < _check.length; ++i) {
                    sb = new StringBuilder();
                    sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
                    sb.append("/");
                    sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
                    sb.append(_check[i].getContent() != null ? _check[i].getContent() : "");
                    list.add(sb.toString());
                }
            } else {
                sb = new StringBuilder();
                sb.append(this.getCSVHeaderRValue(entity, modelId, pname, p));
                sb.append("/");
                sb.append(this.getCSVHeaderRValue(entity, modelId, itemname, p));
                list.add(sb.toString());
            }
        }
    }

    protected static <S extends ContainerBase<S>, SItem> void toCsvDataHeaderCount(S entity, String itemname, Class<SItem> sItemClazz, Map colMap) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            Object[] s_values = (Object[])MethodUtils.invokeMethod(entity, (String)getterm, null);
            if (s_values != null) {
                Integer _count = (Integer)colMap.get(itemname);
                if (_count == null) {
                    _count = s_values.length;
                    colMap.put(itemname, _count);
                } else {
                    _count = Math.max(s_values.length, _count);
                    colMap.put(itemname, _count);
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void checkCsvHeader_checkbox(String modelId, String itemname, Class<PItem> pItemClazz, String _key, ActionParameter p, JFCErrorManager _manager) {
        String _header = this.getCSVHeaderRValue(null, modelId, itemname, p);
        String _value = _key.substring(_header.length());
        JFCPresentationModelitemStorerefBase _item = null;
        JFCPresentationModelitemStorerefBase[] _items = null;
        try {
            _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        for (int j = 0; _items != null && j < _items.length; ++j) {
            if (!_value.equals(_items[j].getContentAsString())) continue;
            if (_item != null) {
                Object[] o = new Object[]{_key, _value};
                Jfcerror _error = _manager.getJfcerror("error.parseCsvData.tooManySameContent", o, p.locale);
                p.errors.addJfcerror(_error);
                return;
            }
            _item = _items[j];
        }
        if (_item == null) {
            if (_value.equals("")) {
                return;
            }
            Object[] o = new Object[]{_key, _value};
            Jfcerror _error = _manager.getJfcerror("error.parseCsvData.nothingContent", o, p.locale);
            p.errors.addJfcerror(_error);
            return;
        }
    }

    protected <EP, PItem extends Serializable> void parseCsvDataNormal(EP pr, String itemname, Class<PItem> pItemClazz, String _key, String _content, boolean needsTrim, Set<String> _targetSet, ActionParameter p) {
        String getterm = SourceGeneratorUtil.getterMethod((String)this.getChildPart(itemname));
        String setterm = SourceGeneratorUtil.setterMethod((String)this.getChildPart(itemname));
        try {
            Serializable _src_item = (Serializable)MethodUtils.invokeMethod(pr, (String)getterm, null);
            Serializable __item = null;
            if (needsTrim) {
                _content = _content.trim();
            }
            if (_content.length() == 0) {
                if (_src_item != null) {
                    __item = null;
                    Method method = pr.getClass().getMethod(setterm, pItemClazz);
                    method.invoke(pr, __item);
                }
            } else if (_src_item == null || !_content.equals((String)MethodUtils.invokeMethod((Object)_src_item, (String)"getContent", null))) {
                __item = (Serializable)ClassUtils.newInstance(pItemClazz);
                MethodUtils.invokeMethod((Object)__item, (String)"setContent", (Object[])new Object[]{_content}, (Class[])new Class[]{String.class});
                MethodUtils.invokeMethod(pr, (String)setterm, (Object[])new Object[]{__item});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <EP, PItem extends JFCPresentationModelitemStorerefBase> void removeUnchooseItem(EP pr, String itemname, Class<PItem> pItemClazz) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        String removem = SourceGeneratorUtil.removeMethod((String)itemname);
        try {
            JFCPresentationModelitemStorerefBase[] _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            for (int j = 0; j < _items.length; ++j) {
                if (_items[j].getChoose()) continue;
                MethodUtils.invokeMethod(pr, (String)removem, (Object[])new Object[]{_items[j]});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <EP, FItem extends JFCPresentationModelitemString, FJshFileItem extends JFCPresentationModelitemString> void removeFileItem(EP pr, String itemname, Class<FItem> fItemClazz, String jshitemname, Class<FJshFileItem> jshItemClazz, String __file_f_file, String __file_f_file_jfcattachment, AttachmentFileMap _attachmentFileMap, JFCErrorManager _manager, String rkey, ActionParameter p) {
        try {
            if (__file_f_file_jfcattachment != null && __file_f_file_jfcattachment.length() > 0) {
                File _file = null;
                if (_attachmentFileMap != null) {
                    _file = _attachmentFileMap.getAttachmentFile(__file_f_file_jfcattachment);
                }
                if (_file == null) {
                    Object[] o = new Object[]{JFCUtils.getRValue(rkey, p.locale), __file_f_file_jfcattachment};
                    Jfcerror _error = _manager.getJfcerror("error.input.nothing_attachmentfile_in_csv", o, p.locale);
                    p.errors.addJfcerror(_error);
                } else {
                    JFCPresentationModelitemString __f_file = (JFCPresentationModelitemString)ClassUtils.newInstance(fItemClazz);
                    if (__file_f_file != null && __file_f_file.length() > 0) {
                        __f_file.setContent(__file_f_file);
                    } else {
                        __f_file.setContent(__file_f_file_jfcattachment);
                    }
                    String setter = SourceGeneratorUtil.setterMethod((String)itemname);
                    MethodUtils.invokeMethod(pr, (String)setter, (Object[])new Object[]{__f_file});
                    JFCPresentationModelitemString __f_file_jshfilename = (JFCPresentationModelitemString)ClassUtils.newInstance(jshItemClazz);
                    __f_file_jshfilename.setContent(_file.toString());
                    setter = SourceGeneratorUtil.setterMethod((String)jshitemname);
                    MethodUtils.invokeMethod(pr, (String)setter, (Object[])new Object[]{__f_file_jshfilename});
                    _attachmentFileMap.addUseAttachment(__file_f_file_jfcattachment);
                }
            } else if (__file_f_file != null) {
                JFCPresentationModelitemString _src_f_file = (JFCPresentationModelitemString)MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.getterMethod((String)itemname), null);
                JFCPresentationModelitemString _src_f_file_jshfilename = (JFCPresentationModelitemString)MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.getterMethod((String)jshitemname), null);
                if (__file_f_file.length() == 0) {
                    if (_src_f_file != null) {
                        Object __f_file = null;
                        String setter = SourceGeneratorUtil.setterMethod((String)itemname);
                        MethodUtils.invokeMethod(pr, (String)setter, (Object[])new Object[]{__f_file});
                        setter = SourceGeneratorUtil.setterMethod((String)jshitemname);
                        MethodUtils.invokeMethod(pr, (String)setter, (Object[])new Object[]{null});
                    }
                } else if (!(_src_f_file != null && __file_f_file.equals(_src_f_file.getContent()) || _src_f_file_jshfilename == null)) {
                    JFCPresentationModelitemString __f_file = (JFCPresentationModelitemString)ClassUtils.newInstance(fItemClazz);
                    __f_file.setContent(__file_f_file);
                    String setter = SourceGeneratorUtil.setterMethod((String)itemname);
                    MethodUtils.invokeMethod(pr, (String)setter, (Object[])new Object[]{__f_file});
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <EP, PItem extends Serializable> void clearNullContent(EP pr, Class<PItem> pItemClazz, String itemname) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            Object v;
            Serializable content = (Serializable)MethodUtils.invokeMethod(pr, (String)getterm, null);
            if (content != null && (v = MethodUtils.invokeMethod((Object)content, (String)"getContent", null)) == null) {
                String setterm = SourceGeneratorUtil.setterMethod((String)itemname);
                Method method = pr.getClass().getMethod(setterm, pItemClazz);
                method.invoke(pr, new Object[]{null});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <EP, PItem extends Serializable> void clearNullContentMulti(EP pr, Class<PItem> pItemClazz, String itemname) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            Serializable[] contents = (Serializable[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            if (contents != null) {
                ArrayList<Serializable> contents1 = new ArrayList<Serializable>();
                for (Serializable content : contents) {
                    Object v = MethodUtils.invokeMethod((Object)content, (String)"getContent", null);
                    if (v == null) continue;
                    contents1.add(content);
                }
                Serializable[] n_contents = contents1.toArray((Serializable[])Array.newInstance(pItemClazz, contents1.size()));
                String setterm = SourceGeneratorUtil.setterMethod((String)itemname);
                MethodUtils.invokeMethod(pr, (String)setterm, (Object[])new Object[]{n_contents});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <E, EP, PItem extends JFCPresentationModelitemMultiString> boolean parseCsvDataMultiple(E entity, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager, SortedMap<Integer, String> datas_map, AttachmentFileMap _attachmentFileMap) {
        String getterm = SourceGeneratorUtil.getterMethod((String)itemname);
        try {
            JFCPresentationModelitemMultiString[] _pitems = (JFCPresentationModelitemMultiString[])MethodUtils.invokeMethod(pr, (String)getterm, null);
            for (int j = 0; j < _pitems.length; ++j) {
                JFCPresentationModelitemMultiString _pitem = _pitems[j];
                Integer _num = j + 1;
                String _data = (String)datas_map.remove(_num);
                if (_data == null) continue;
                if (_data.equals("")) {
                    MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.removeMethod((String)itemname), (Object[])new Object[]{_pitem});
                    continue;
                }
                _pitem.setContent(_data);
            }
            int _fcnt = 0;
            Iterator<Map.Entry<Integer, String>> _entryit = datas_map.entrySet().iterator();
            while (_entryit.hasNext()) {
                Map.Entry<Integer, String> _entry = _entryit.next();
                _entryit.remove();
                Integer _key = _entry.getKey();
                String _data = _entry.getValue();
                if (_data.equals("")) continue;
                JFCPresentationModelitemMultiString _pitem = (JFCPresentationModelitemMultiString)ClassUtils.newInstance(pItemClazz);
                _pitem.setContent(_data);
                if (_key <= 0) {
                    MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.adderMethod((String)itemname), (Object[])new Object[]{_fcnt++, _pitem}, (Class[])new Class[]{Integer.TYPE, pItemClazz});
                    continue;
                }
                MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.adderMethod((String)itemname), (Object[])new Object[]{_pitem}, (Class[])new Class[]{pItemClazz});
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataComboRadio(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataComboRadio0(_content, _key, entity, pr, pItemClazz, itemname, false, null, null, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataComboRadioId(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataComboRadio0(_content, _key, entity, pr, pItemClazz, itemname, true, null, null, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataComboRadio(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataComboRadio0(_content, _key, entity, pr, pItemClazz, itemname, false, filterHelperClassname, filtername, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataComboRadioId(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataComboRadio0(_content, _key, entity, pr, pItemClazz, itemname, true, filterHelperClassname, filtername, p, _manager);
    }

    private <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataComboRadio0(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, boolean mode_id, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        itemname = this.getChildPart(itemname);
        try {
            Method[] methods;
            StringFilter filter;
            FilterManager filterManager;
            if (_content.length() == 0) {
                int size = (Integer)MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.sizeMethod((String)itemname), (Object[])new Object[0]);
                if (size > 0) {
                    MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.clearMethod((String)itemname), (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
            if (filtername != null && (filterManager = (FilterManager)p.appctx.getBean("filterManager")) != null && (filter = filterManager.getFilter(filtername)) != null) {
                _content = filter.filter(_content);
            }
            JFCPresentationModelitemStorerefBase[] _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName())), (Object[])new Object[0]);
            for (int j = 0; j < _items.length; ++j) {
                if (_items[j].getNoId() || !_items[j].getChoose()) continue;
                String value = null;
                value = mode_id ? (String)MethodUtils.invokeMethod((Object)_items[j], (String)"getIdAsString", (Object[])new Object[0]) : _items[j].getContentAsString();
                if (!_content.equals(value)) break;
                return false;
            }
            JFCPresentationModelitemStorerefBase _item = null;
            String getterum = "get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_update";
            for (Method method : methods = this.pHelper.getClass().getMethods()) {
                if (!method.getName().equals(getterum)) continue;
                method.invoke(this.pHelper, null, p);
                break;
            }
            for (int j = 0; j < _items.length; ++j) {
                if (_items[j].getNoId() || !_content.equals(_items[j].getContentAsString())) continue;
                if (_item != null) {
                    Object[] o = new Object[]{_key, _content};
                    Jfcerror _error = _manager.getJfcerror("error.parseCsvData.tooManySameContent", o, p.locale);
                    p.errors.addJfcerror(_error);
                    return false;
                }
                _item = _items[j];
            }
            if (_item == null) {
                Object[] o = new Object[]{_key, _content};
                Jfcerror _error = _manager.getJfcerror("error.parseCsvData.nothingContent", o, p.locale);
                p.errors.addJfcerror(_error);
                return false;
            }
            _item.setChoose(true);
            MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.setterMethod((String)itemname), (Object[])new Object[]{_item}, (Class[])new Class[]{pItemClazz});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataDualinput(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataSameIdContent(_content, _key, entity, pr, pItemClazz, itemname, null, null, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataSearch(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataSameIdContent(_content, _key, entity, pr, pItemClazz, itemname, null, null, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataDualinput(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataSameIdContent(_content, _key, entity, pr, pItemClazz, itemname, filterHelperClassname, filtername, p, _manager);
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataSearch(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        return this.parseCsvDataSameIdContent(_content, _key, entity, pr, pItemClazz, itemname, filterHelperClassname, filtername, p, _manager);
    }

    private <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataSameIdContent(String _content, String _key, E entity, EP pr, Class<PItem> pItemClazz, String itemname, String filterHelperClassname, String filtername, ActionParameter p, JFCErrorManager _manager) {
        itemname = this.getChildPart(itemname);
        try {
            StringFilter filter;
            FilterManager filterManager;
            if (_content.length() == 0) {
                int size = (Integer)MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.sizeMethod((String)itemname), (Object[])new Object[0]);
                if (size > 0) {
                    MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.clearMethod((String)itemname), (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
            if (filtername != null && (filterManager = (FilterManager)p.appctx.getBean("filterManager")) != null && (filter = filterManager.getFilter(filtername)) != null) {
                _content = filter.filter(_content);
            }
            JFCPresentationModelitemStorerefBase[] _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName())), (Object[])new Object[0]);
            for (int j = 0; j < _items.length; ++j) {
                if (_items[j].getNoId() || !_items[j].getChoose()) continue;
                if (!_content.equals(_items[j].getContentAsString())) break;
                return false;
            }
            JFCPresentationModelitemStorerefBase __item = (JFCPresentationModelitemStorerefBase)ClassUtils.newInstance(pItemClazz);
            __item.setChoose(true);
            MethodUtils.invokeMethod((Object)__item, (String)"setIdByString", (Object[])new Object[]{_content});
            __item.setContentByString(_content);
            MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.setterMethod((String)itemname), (Object[])new Object[]{__item}, (Class[])new Class[]{pItemClazz});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected <E, EP, PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataCheck(String _content, String _key, String modelId, EP pr, Class<PItem> pItemClazz, String itemname, ActionParameter p, JFCErrorManager _manager) {
        String _header = this.getCSVHeaderRValue(null, modelId, itemname, p);
        String _value = _key.substring(_header.length());
        itemname = this.getChildPart(itemname);
        try {
            Method[] methods;
            if (_content.equals("0") || _content.length() == 0) {
                JFCPresentationModelitemStorerefBase[] _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName())), (Object[])new Object[0]);
                for (int j = 0; j < _items.length; ++j) {
                    if (!_value.equals(_items[j].getContentAsString())) continue;
                    MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.removeMethod((String)itemname), (Object[])new Object[]{_items[j]});
                    return _items[j].getChoose();
                }
                return false;
            }
            if (_content.trim().length() == 0) {
                return false;
            }
            if (!_content.equals("1")) {
                Object[] o = new Object[]{_key, _content};
                Jfcerror _error = _manager.getJfcerror("error.parseCsvData.illegalCheckValue", o, p.locale);
                p.errors.addJfcerror(_error);
                return false;
            }
            JFCPresentationModelitemStorerefBase[] _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(pr, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName())), (Object[])new Object[0]);
            for (int j = 0; j < _items.length; ++j) {
                if (!_value.equals(_items[j].getContentAsString())) continue;
                if (!_items[j].getChoose()) {
                    _items[j].setChoose(true);
                    return true;
                }
                return false;
            }
            JFCPresentationModelitemStorerefBase _item = null;
            String getterum = "get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_update";
            for (Method method : methods = this.pHelper.getClass().getMethods()) {
                if (!method.getName().equals(getterum)) continue;
                method.invoke(this.pHelper, null, p);
                break;
            }
            for (int j = 0; j < _items.length; ++j) {
                if (!_value.equals(_items[j].getContentAsString())) continue;
                if (_item != null) {
                    Object[] o = new Object[]{_key, _value};
                    Jfcerror _error = _manager.getJfcerror("error.parseCsvData.tooManySameContent", o, p.locale);
                    p.errors.addJfcerror(_error);
                    return false;
                }
                _item = _items[j];
            }
            if (_item == null) {
                if (_value.equals("")) {
                    return false;
                }
                Object[] o = new Object[]{_key, _value};
                Jfcerror _error = _manager.getJfcerror("error.parseCsvData.nothingContent", o, p.locale);
                p.errors.addJfcerror(_error);
                return false;
            }
            _item.setChoose(true);
            MethodUtils.invokeMethod(pr, (String)SourceGeneratorUtil.adderMethod((String)itemname), (Object[])new Object[]{_item}, (Class[])new Class[]{pItemClazz});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected boolean checkCsvHeaderMultiple(String _key, String s, Logger logger) {
        Matcher _mat = MultipleHeaderPattern.matcher(s);
        if (_mat.matches()) {
            String con_numstr = _mat.group(1);
            try {
                Integer con_num = Integer.valueOf(con_numstr);
                return true;
            }
            catch (NumberFormatException e) {
                logger.debug("Illegal csv header key:" + _key + " 1:" + con_numstr);
            }
        } else {
            logger.debug("Illegal csv header key:" + _key + " s:" + s);
        }
        return false;
    }

    protected boolean checkCsvHeaderContainer(String _key, String s, String methodname, Set<String> _headerSet, ActionParameter p, Logger logger) {
        Matcher _mat = ContainerHeaderPattern.matcher(s);
        if (_mat.matches()) {
            String con_numstr = _mat.group(1);
            String con_header = _mat.group(2);
            try {
                Integer con_num = Integer.valueOf(con_numstr);
                Boolean ret = (Boolean)MethodUtils.invokeMethod((Object)this, (String)methodname, (Object[])new Object[]{con_header, p, _headerSet});
                return ret;
            }
            catch (NumberFormatException e) {
                logger.warn("Illegal csv header key:" + _key + " 1:" + con_numstr + " 2:" + con_header);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            logger.warn("Illegal csv header key:" + _key + " s:" + s);
        }
        return false;
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> boolean parseCsvDataCheckMulticolumn(String _key, String rkey, Class<PItem> pItemClazz, ActionParameter p) {
        String _header = JFCUtils.getRValue(rkey, p.locale);
        String _value = _key.substring(_header.length());
        JFCPresentationModelitemStorerefBase _item = null;
        JFCPresentationModelitemStorerefBase[] _items = null;
        try {
            _items = (JFCPresentationModelitemStorerefBase[])MethodUtils.invokeMethod(this.pHelper, (String)("get" + ClassUtils.getShortClassName((String)pItemClazz.getName()) + "_all"), (Object[])new Object[]{p}, (Class[])new Class[]{ActionParameter.class});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        for (int j = 0; j < _items.length; ++j) {
            if (!_value.equals(_items[j].getContentAsString())) continue;
            if (_item != null) {
                return false;
            }
            _item = _items[j];
        }
        return _item != null;
    }

    private final String getChildPart(String name) {
        if (name == null) {
            return null;
        }
        int ptr = name.indexOf("/");
        if (ptr < 0) {
            return name;
        }
        return name.substring(ptr + 1);
    }

    protected String getNumberFormat(String mitemname) {
        return null;
    }

    protected String formatValue(String mitemname, String value, DbUploadUpdateRunnableMonitorFileProcessor.CellAttr _cwa) {
        DecimalFormat f1;
        logger.debug("mitemname=" + mitemname + " value=" + value + " cwa=" + _cwa);
        if (value == null || _cwa == null) {
            return value;
        }
        if (!(_cwa instanceof DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.MyCellAttr)) {
            return value;
        }
        DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.MyCellAttr _cwa2 = (DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.MyCellAttr)_cwa;
        if (_cwa2.getType() != DbUploadUpdateRunnableMonitorFileProcessorImpl_Xls.XlsCellType.N) {
            return value;
        }
        if (_cwa2.getNumberFormat() != null) {
            return value;
        }
        String f = this.getNumberFormat(mitemname);
        logger.debug("f=" + f);
        if (f == null) {
            String format = "##0.###";
            f1 = new DecimalFormat(format);
        } else {
            if (f.equals("full")) {
                return value;
            }
            f1 = new DecimalFormat(f);
        }
        try {
            return f1.format(Double.valueOf(value));
        }
        catch (NumberFormatException e) {
            logger.debug("NumberFormatException mitemname:" + mitemname + ", value:" + value, (Throwable)e);
            return value;
        }
    }

    protected void addItemCountMap(Map<String, List<Integer>> itemBeginCntMap, String itemname, Integer cnt) {
        List<Integer> list = itemBeginCntMap.get(itemname);
        if (list == null) {
            list = new ArrayList<Integer>();
            itemBeginCntMap.put(itemname, list);
        }
        list.add(cnt);
    }

    protected void sortTargetitems(Collection<String> targetitems, Map<String, Integer[]> targetitemOrderMap, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap, List<String> list, List<String> newlist, List<Serializable> storedata, List<Serializable> newstoredata) {
        for (String targetitem : targetitems) {
            Integer[] order = null;
            if (targetitemOrderMap != null) {
                order = targetitemOrderMap.get(targetitem);
            }
            this.addTargetitem(targetitem, order, itemBeginCntMap, itemEndCntMap, list, newlist, storedata, newstoredata);
        }
    }

    protected void addTargetitem(String targetitem, Integer[] order, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap, List<String> list, List<String> newlist, List<Serializable> storedata, List<Serializable> newstoredata) {
        List<Integer> begincnts = itemBeginCntMap.get(targetitem);
        List<Integer> endcnts = itemEndCntMap.get(targetitem);
        if (begincnts == null || endcnts == null || begincnts.size() != endcnts.size()) {
            return;
        }
        int cnt = begincnts.size();
        for (int i = 0; i < cnt; ++i) {
            int endcnt;
            int begincnt = begincnts.get(i);
            if (begincnt > (endcnt = endcnts.get(i).intValue())) {
                return;
            }
            List<String> sublist = this.sortTargetitemList(list.subList(begincnt, endcnt), order);
            newlist.addAll(sublist);
            if (storedata == null || newstoredata == null) continue;
            List<Serializable> storesublist = this.sortTargetitemList(storedata.subList(begincnt, endcnt), order);
            newstoredata.addAll(storesublist);
        }
    }

    private <T> List<T> sortTargetitemList(List<T> list, Integer[] order) {
        int i;
        if (order == null) {
            return list;
        }
        int size = Math.min(list.size(), order.length);
        if (size <= 1) {
            return list;
        }
        TreeMap<Integer, T> sortedvalue = new TreeMap<Integer, T>();
        for (i = 0; i < size; ++i) {
            if (order[i] == null || order[i] < 0) continue;
            sortedvalue.put(order[i], list.get(i));
        }
        ArrayList list2 = new ArrayList(sortedvalue.values());
        while (i < list.size()) {
            list2.add(list.get(i));
            ++i;
        }
        return list2;
    }

    protected void toCsvDataNormal(S entity, P pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataNormal(entity, pr, itemname, value, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataNormal(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataNormal(parent_control, cont, cont_p, itemname, contitemname, value, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataDualInput(S entity, P pr, String itemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataDualInput(entity, pr, itemname, value, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataDualInput(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Serializable value, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataDualInput(parent_control, cont, cont_p, itemname, contitemname, value, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataModelref(S entity, P pr, String itemname, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataModelref(entity, pr, itemname, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataModelref(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataModelref(parent_control, cont, cont_p, itemname, contitemname, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataModelCheckSingleInt(S entity, P pr, String itemname, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataModelCheckSingleInt(entity, pr, itemname, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <C extends ContainerBase<C>, CP> void toCsvDataModelCheckSingleInt(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, List<String> list, List<Serializable> storedata, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataModelCheckSingleInt(parent_control, cont, cont_p, itemname, contitemname, list, storedata, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <SItem extends Serializable> void toCsvDataMultiple(S entity, P pr, String itemname, Class<SItem> sItemClazz, List<String> list, List<Serializable> storedata, Map colMap, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataMultiple(entity, pr, itemname, sItemClazz, list, storedata, colMap, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <C extends ContainerBase<C>, CP, SItem extends Serializable> void toCsvDataMultiple(JFCControlUtil.ControlType parent_control, C cont, CP cont_p, String itemname, String contitemname, Class<SItem> sItemClazz, List<String> list, List<Serializable> storedata, Map colMap, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataMultiple(parent_control, cont, cont_p, itemname, contitemname, sItemClazz, list, storedata, colMap, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataHeaderNormal(S entity, String modelId, String itemname, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        String itemname2 = this.getChildPart(itemname);
        if (targetSet == null || targetSet.contains(itemname2)) {
            this.addItemCountMap(itemBeginCntMap, itemname2, list.size());
            this.toCsvDataHeaderNormal(entity, modelId, itemname, list, p);
            this.addItemCountMap(itemEndCntMap, itemname2, list.size());
        }
    }

    protected int toCsvDataHeaderNormal(S entity, String modelId, String itemname, int k, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap, Map colMap) {
        String itemname2 = this.getChildPart(itemname);
        int ret = 0;
        if (targetSet == null || targetSet.contains(itemname2)) {
            this.addItemCountMap(itemBeginCntMap, itemname2, list.size());
            ret = this.toCsvDataHeaderNormal(entity, modelId, itemname, k, list, p, colMap);
            this.addItemCountMap(itemEndCntMap, itemname2, list.size());
        }
        return ret;
    }

    protected void toCsvDataHeaderMultiple(S entity, String modelId, String itemname, Map colMap, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataHeaderMultiple(entity, modelId, itemname, colMap, list, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void toCsvDataHeaderCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        String itemname2 = this.getChildPart(itemname);
        if (targetSet == null || targetSet.contains(itemname2)) {
            this.addItemCountMap(itemBeginCntMap, itemname2, list.size());
            this.toCsvDataHeaderCheckbox(entity, modelId, itemname, pItemClazz, list, p);
            this.addItemCountMap(itemEndCntMap, itemname2, list.size());
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> int toCsvDataHeaderCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, int k, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap, Map colMap) {
        String itemname2 = this.getChildPart(itemname);
        int ret = 0;
        if (targetSet == null || targetSet.contains(itemname2)) {
            this.addItemCountMap(itemBeginCntMap, itemname2, list.size());
            ret = this.toCsvDataHeaderCheckbox(entity, modelId, itemname, pItemClazz, k, list, p, colMap);
            this.addItemCountMap(itemEndCntMap, itemname2, list.size());
        }
        return ret;
    }

    protected void toCsvDataHeaderModelitemNormal(S entity, String modelId, String itemname, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataHeaderModelitemNormal(entity, modelId, itemname, list, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataHeaderModelitemMultiple(S entity, String modelId, String modelitemname, String itemname, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataHeaderModelitemMultiple(entity, modelId, modelitemname, itemname, list, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected void toCsvDataHeaderModelitemContainer(S entity, String modelId, String itemname, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataHeaderModelitemContainer(entity, modelId, itemname, list, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    protected <PItem extends JFCPresentationModelitemStorerefBase> void toCsvDataHeaderModelitemContainerCheckbox(S entity, String modelId, String itemname, Class<PItem> pItemClazz, List<String> list, ActionParameter p, Set<String> targetSet, Map<String, List<Integer>> itemBeginCntMap, Map<String, List<Integer>> itemEndCntMap) {
        if (targetSet == null || targetSet.contains(itemname)) {
            this.addItemCountMap(itemBeginCntMap, itemname, list.size());
            this.toCsvDataHeaderModelitemContainerCheckbox(entity, modelId, itemname, pItemClazz, list, p);
            this.addItemCountMap(itemEndCntMap, itemname, list.size());
        }
    }

    public static boolean containsOne(Set<String> set, String[] items) {
        for (String s : items) {
            if (!set.contains(s)) continue;
            return true;
        }
        return false;
    }

    public String[] getPrimaryKeyModelitems() {
        throw new IllegalStateException();
    }

    public String getModelId() {
        throw new IllegalStateException();
    }

    public boolean containsPrimaryKeyHeader(String header, ActionParameter p) {
        String[] mitemnames;
        String modelId = this.getModelId();
        for (String mitemname : mitemnames = this.getPrimaryKeyModelitems()) {
            if (!header.equals(this.getCSVHeaderRValue(null, modelId, mitemname, p))) continue;
            return true;
        }
        return false;
    }

    public String[] getPrimaryKeyForCsvData(String[] _data, String[] _header, ActionParameter p) {
        String modelId = this.getModelId();
        int _rkeylen = this.getPrimaryKeyModelitems().length;
        String[] _ret = new String[_rkeylen];
        int _len = _header.length;
        if (_len > _data.length) {
            _len = _data.length;
        }
        for (int i = 0; i < _len; ++i) {
            String _key = _header[i];
            String _content = _data[i];
            for (int j = 0; j < _rkeylen; ++j) {
                String mitemname = this.getPrimaryKeyModelitems()[j];
                if (!_key.equals(this.getCSVHeaderRValue(null, modelId, mitemname, p))) continue;
                _ret[j] = _content;
            }
        }
        return _ret;
    }
}

