/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.util.HashMap;
import java.util.Map;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.Changelog;
import jp.jasminesoft.jfc.app.ChangelogType;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ChangelogFormatter {
    private static ChangelogFormatter _instance;
    private static Map<String, String> fmap;

    private ChangelogFormatter() {
        fmap = new HashMap<String, String>();
    }

    public static ChangelogFormatter getInstance() {
        if (_instance == null) {
            _instance = new ChangelogFormatter();
        }
        return _instance;
    }

    public String format(Changelog changelog) {
        String locale_str_ = changelog.getLocaleStr();
        ChangelogType type = changelog.getType();
        String id = changelog.getId();
        String item = changelog.getItem();
        String key = "__jfc_common.changelog.format." + type.toString().toLowerCase();
        Object item18n = null;
        String format_ = fmap.get(key);
        if (format_ == null) {
            format_ = JFCUtils.getRValue(key, locale_str_);
            fmap.put(key, format_);
        }
        if (format_.indexOf("%item18n") >= 0) {
            int ptr = item.indexOf("[");
            if (ptr > 0) {
                int ptr2;
                String p2;
                String p1 = item.substring(0, ptr);
                String tp = p1 + "." + (p2 = item.substring((ptr2 = item.indexOf("].")) + 2));
                item18n = JFCUtils.getRValue(id + "." + tp, locale_str_);
                item18n = StringUtils.isBlank((CharSequence)item18n) ? id + "." + tp + "[" + item.substring(ptr + 1, ptr2) + "]" : (String)item18n + "[" + item.substring(ptr + 1, ptr2) + "]";
            } else {
                item18n = JFCUtils.getRValue(id + "." + item, locale_str_);
                if (StringUtils.isBlank((CharSequence)item18n)) {
                    item18n = id + "." + item;
                }
            }
        }
        String s = format_;
        s = StringUtil.replaceAll((String)s, (String)"%model", (String)id);
        if (item18n != null) {
            s = StringUtil.replaceAll((String)s, (String)"%item18n", (String)item18n);
        }
        s = StringUtil.replaceAll((String)s, (String)"%item", (String)item);
        s = StringUtil.replaceAll((String)s, (String)"%ovalue", (String)StringUtil.removeCRLF((String)StringUtils.defaultString((String)changelog.getOriginalValue())));
        s = StringUtil.replaceAll((String)s, (String)"%uvalue", (String)StringUtil.removeCRLF((String)StringUtils.defaultString((String)changelog.getUpdatedValue())));
        return s;
    }

    public static void main(String[] args) {
    }
}

