/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.sql.SQLException;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.app.GetSeqProcessBean;
import jp.jasminesoft.jfc.app.GetSequenceProcessBean;
import jp.jasminesoft.jfc.app.UpdateSeqProcessBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonService {
    private static final Logger logger = LogManager.getLogger(CommonService.class);

    public static int getSequence(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSequence0(p, name), Integer.TYPE).intValue();
    }

    public static int getSequenceAsInteger(ActionParameter p, String name) throws Exception {
        return CommonService.getSequence(p, name);
    }

    public static byte getSequenceAsByte(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSequence0(p, name), Byte.TYPE).byteValue();
    }

    public static short getSequenceAsShort(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSequence0(p, name), Short.TYPE).shortValue();
    }

    public static long getSequenceAsLong(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSequence0(p, name), Long.TYPE).longValue();
    }

    private static long getSequence0(ActionParameter p, String name) throws Exception {
        GetSequenceProcessBean pbean = new GetSequenceProcessBean(p);
        pbean.setParameter("seq_name", name);
        long seq = 0L;
        try {
            Object obj = pbean.process();
            if (obj == null) {
                throw new SQLException("GetSequenceProcessBean return null value");
            }
            if (obj instanceof String) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00225), LogCodeManager.getMessage(LogCode.JFC00225, p.user, (String)obj));
                throw new SQLException((String)obj);
            }
            if (obj instanceof Long) {
                seq = (Long)obj;
            }
        }
        catch (SecurityException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00226), LogCodeManager.getMessage(LogCode.JFC00226, p.user, e.getMessage()));
            logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            pbean.release();
        }
        return seq;
    }

    public static int getSeq(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSeq0(p, name, null, Integer.TYPE), Integer.TYPE).intValue();
    }

    public static int getSeqAsInteger(ActionParameter p, String name) throws Exception {
        return CommonService.getSeq(p, name);
    }

    public static byte getSeqAsByte(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSeq0(p, name, null, Byte.TYPE), Byte.TYPE).byteValue();
    }

    public static short getSeqAsShort(ActionParameter p, String name) throws Exception {
        return CommonService.VALUE(CommonService.getSeq0(p, name, null, Short.TYPE), Short.TYPE).shortValue();
    }

    public static long getSeqAsLong(ActionParameter p, String name) throws Exception {
        return CommonService.getSeq0(p, name, null, Long.TYPE);
    }

    private static Number VALUE(long v, Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            if (v > Integer.MAX_VALUE) {
                v = Integer.MIN_VALUE;
            }
            return new Integer((int)v);
        }
        if (type.equals(Short.TYPE)) {
            if (v > 32767L) {
                v = -32768L;
            }
            return new Short((short)v);
        }
        if (type.equals(Byte.TYPE)) {
            if (v > 127L) {
                v = -128L;
            }
            return new Byte((byte)v);
        }
        return new Long(v);
    }

    private static long getSeq0(ActionParameter p, String name, Map<String, Object> param, Class<?> type) throws Exception {
        GetSeqProcessBean pbean = new GetSeqProcessBean(p);
        pbean.setParameter("seq_name", name);
        pbean.setParameter("seq_type", type);
        if (param != null) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                pbean.setParameter(entry.getKey(), entry.getValue());
            }
        }
        long seq = 0L;
        try {
            Object obj = pbean.process();
            if (obj == null) {
                throw new SQLException("GetSeqProcessBean return null value");
            }
            if (obj instanceof String) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00228), LogCodeManager.getMessage(LogCode.JFC00228, p.user, (String)obj));
                throw new SQLException((String)obj);
            }
            if (obj instanceof Long) {
                seq = (Long)obj;
            }
        }
        catch (SecurityException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00229), LogCodeManager.getMessage(LogCode.JFC00229, p.user, e.getMessage()));
            throw e;
        }
        finally {
            pbean.release();
        }
        return seq;
    }

    public static int updateSeq(ActionParameter p, String name, int num) throws Exception {
        return CommonService.updateSeq(p, name, num, true);
    }

    public static int updateSeq(ActionParameter p, String name, int num, boolean ismaxnow) throws Exception {
        long obj = CommonService.updateSeq0(p, name, num, ismaxnow);
        return CommonService.VALUE(obj, Integer.TYPE).intValue();
    }

    public static long updateSeq(ActionParameter p, String name, long num) throws Exception {
        return CommonService.updateSeq(p, name, num, true);
    }

    public static long updateSeq(ActionParameter p, String name, long num, boolean ismaxnow) throws Exception {
        return CommonService.updateSeq0(p, name, num, ismaxnow);
    }

    public static byte updateSeq(ActionParameter p, String name, byte num) throws Exception {
        return CommonService.updateSeq(p, name, num, true);
    }

    public static byte updateSeq(ActionParameter p, String name, byte num, boolean ismaxnow) throws Exception {
        long obj = CommonService.updateSeq0(p, name, num, ismaxnow);
        return CommonService.VALUE(obj, Byte.TYPE).byteValue();
    }

    public static short updateSeq(ActionParameter p, String name, short num) throws Exception {
        return CommonService.updateSeq(p, name, num, true);
    }

    public static short updateSeq(ActionParameter p, String name, short num, boolean ismaxnow) throws Exception {
        long obj = CommonService.updateSeq0(p, name, num, ismaxnow);
        return CommonService.VALUE(obj, Short.TYPE).shortValue();
    }

    private static long updateSeq0(ActionParameter p, String name, Number num, boolean ismaxnow) throws Exception {
        UpdateSeqProcessBean pbean = new UpdateSeqProcessBean(p);
        pbean.setParameter("seq_name", name);
        pbean.setParameter("num", num);
        pbean.setParameter("ismaxnow", ismaxnow);
        long seq = 0L;
        try {
            Object obj = pbean.process();
            if (obj == null) {
                throw new SQLException("UpdateSeqProcessBean return null value");
            }
            if (obj instanceof String) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00231), LogCodeManager.getMessage(LogCode.JFC00231, p.user, (String)obj));
                throw new SQLException((String)obj);
            }
            if (obj instanceof Long) {
                seq = (Long)obj;
            }
        }
        catch (SecurityException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00232), LogCodeManager.getMessage(LogCode.JFC00232, p.user, e.getMessage()));
            throw e;
        }
        finally {
            pbean.release();
        }
        return seq;
    }
}

